/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.henshin.diagram.edit.helpers.AmalgamationEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.TransformationSystemEditHelper;
import org.eclipse.emf.henshin.diagram.parsers.UnitNameParser;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.View;

public class RuleNameParser
extends UnitNameParser {
    public RuleNameParser(View view) {
        super(view);
        if (!RootObjectEditHelper.isRuleView(view)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected boolean isUnitEmpty(TransformationUnit unit) {
        if (unit instanceof Rule) {
            Rule rule = (Rule)unit;
            return rule.getLhs().getNodes().isEmpty() && rule.getRhs().getNodes().isEmpty() && rule.getParameters().isEmpty();
        }
        return super.isUnitEmpty(unit);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String root = "";
        Node rootObject = RootObjectEditHelper.getRootObject(this.unitView);
        if (rootObject != null) {
            root = " @" + rootObject.getType().getName();
        }
        return String.valueOf(super.getPrintString(element, flags)) + root;
    }

    @Override
    protected CommandResult doParsing(String value) throws ExecutionException {
        String rootType;
        String name;
        Rule rule = (Rule)this.unitView.getElement();
        int at = value.indexOf(64);
        if (at < 0) {
            name = value;
            rootType = null;
        } else {
            name = value.substring(0, at).trim();
            rootType = value.substring(at + 1).trim();
            if (rootType.isEmpty()) {
                rootType = null;
            }
        }
        super.doParsing(name);
        Node oldRoot = RootObjectEditHelper.getRootObject(this.unitView);
        if (!(rootType == null || oldRoot != null && rootType.equals(oldRoot.getType().getName()))) {
            EClassifier[] eclassifiers;
            EClass rootClass = null;
            EClassifier[] eClassifierArray = eclassifiers = TransformationSystemEditHelper.findEClassifierByName(rule.getTransformationSystem(), rootType);
            int n = eclassifiers.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier ec = eClassifierArray[n2];
                if (ec instanceof EClass) break;
                ++n2;
            }
            if (rootClass != null) {
                RootObjectEditHelper.setRootObjectType(this.unitView, rootClass);
            }
        }
        if (rootType == null && oldRoot != null) {
            RootObjectEditHelper.setRootObject(this.unitView, null);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected void doSetName(TransformationUnit unit, String name) {
        AmalgamationEditHelper.renameKernelRule((Rule)unit, name);
    }
}

