/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.conditions.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.script.ScriptEngine;
import org.eclipse.emf.henshin.matching.conditions.attribute.AttributeCondition;

public class AttributeConditionHandler {
    Collection<AttributeCondition> attributeConditions = new ArrayList<AttributeCondition>();
    Map<String, Collection<AttributeCondition>> involvedConditions = new HashMap<String, Collection<AttributeCondition>>();
    Collection<String> assignedParameters = new HashSet<String>();
    ScriptEngine scriptEngine;

    public AttributeConditionHandler(Map<String, Collection<String>> conditionParameters, ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
        for (String conditionString : conditionParameters.keySet()) {
            Collection<String> usedParameters = conditionParameters.get(conditionString);
            AttributeCondition attributeCondition = new AttributeCondition(conditionString, usedParameters, scriptEngine);
            this.attributeConditions.add(attributeCondition);
            for (String usedParameter : usedParameters) {
                Collection<AttributeCondition> conditionList = this.involvedConditions.get(usedParameter);
                if (conditionList == null) {
                    conditionList = new ArrayList<AttributeCondition>();
                    this.involvedConditions.put(usedParameter, conditionList);
                }
                conditionList.add(attributeCondition);
            }
        }
    }

    public boolean setParameter(String parameterName, Object value) {
        boolean result = true;
        if (!this.assignedParameters.contains(parameterName)) {
            this.assignedParameters.add(parameterName);
            this.scriptEngine.put(parameterName, value);
            Collection<AttributeCondition> conditionList = this.involvedConditions.get(parameterName);
            if (conditionList != null) {
                for (AttributeCondition condition : conditionList) {
                    condition.removeParameter(parameterName);
                    boolean bl = result = result && condition.eval();
                }
            }
        }
        return result;
    }

    public void unsetParameter(String parameterName) {
        if (this.assignedParameters.contains(parameterName)) {
            this.assignedParameters.remove(parameterName);
            Collection<AttributeCondition> conditionList = this.involvedConditions.get(parameterName);
            if (conditionList != null) {
                for (AttributeCondition condition : this.involvedConditions.get(parameterName)) {
                    condition.addParameter(parameterName);
                }
            }
        }
    }

    public boolean isSet(String parameterName) {
        return this.assignedParameters.contains(parameterName);
    }

    public Object getParameter(String parameterName) {
        return this.scriptEngine.get(parameterName);
    }

    public Map<String, Object> getParameterValues() {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        for (String parameterName : this.assignedParameters) {
            parameterValues.put(parameterName, this.scriptEngine.get(parameterName));
        }
        return parameterValues;
    }
}

