/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.util.TransformationOptions;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.Trace;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.hashcodes.HashCodeMap;
import org.eclipse.emf.henshin.statespace.impl.AbstractStateSpaceManager;
import org.eclipse.emf.henshin.statespace.properties.ParametersPropertiesManager;
import org.eclipse.emf.henshin.statespace.util.StateSpaceMonitor;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public class StateSpaceManagerImpl
extends AbstractStateSpaceManager {
    private final Map<State, Model> modelCache = Collections.synchronizedMap(new Cache());
    private final Map<Model, HashCodeMap> codesCache = Collections.synchronizedMap(new Cache());
    private final Stack<EmfEngine> engines = new Stack();
    private final Object explorerLock = new Object();

    public StateSpaceManagerImpl(StateSpace stateSpace) {
        super(stateSpace);
    }

    @Override
    protected boolean isOpen(State state) throws StateSpaceException {
        List<Transition> transitions = this.doExplore(state);
        HashSet<Transition> matched = new HashSet<Transition>();
        for (Transition current : transitions) {
            State generated = current.getTarget();
            State target = this.getState(generated.getModel(), generated.getHashCode());
            if (target == null) {
                return true;
            }
            Transition transition = StateSpaceManagerImpl.findTransition(state, target, current.getRule(), current.getParameterIDs());
            if (transition == null) {
                return true;
            }
            matched.add(transition);
        }
        if (!matched.containsAll((Collection<?>)state.getOutgoing())) {
            throw new StateSpaceException("Illegal transition in state " + state.getIndex());
        }
        return false;
    }

    @Override
    public Model getModel(State state) throws StateSpaceException {
        if (state.getModel() != null) {
            return state.getModel();
        }
        Model cached = this.modelCache.get(state);
        if (cached != null) {
            return cached;
        }
        StateSpaceSearch search = new StateSpaceSearch(){

            @Override
            protected boolean shouldStop(State current, Trace trace) {
                return current.getModel() != null || StateSpaceManagerImpl.this.modelCache.get(current) != null;
            }
        };
        boolean found = search.depthFirst(state, true);
        if (!found) {
            throw new StateSpaceException("Unable to derive state model for state " + state.getIndex());
        }
        Model start = search.getCurrentState().getModel();
        if (start == null) {
            start = this.modelCache.get(search.getCurrentState());
        }
        Model model = this.deriveModel(start, search.getTrace());
        if (this.getStateSpace().getEqualityHelper().isGraphEquality()) {
            this.hashCode(model);
        }
        this.modelCache.put(state, model);
        return model;
    }

    private void storeModel(State state, Model model) {
        if (state.isInitial()) {
            return;
        }
        int states = this.getStateSpace().getStates().size();
        states = states - states % 1000 + 1000;
        int stored = (int)(Math.log10(states) * 1.5);
        int index = state.getIndex() + 1;
        if (index % stored != 0) {
            model = null;
        }
        state.setModel(model);
    }

    private Model deriveModel(Model start, Trace path) throws StateSpaceException {
        EmfEngine engine = this.acquireEngine();
        Model model = start.getCopy(null);
        for (Transition transition : path) {
            Rule rule = transition.getRule();
            if (rule == null || !this.getStateSpace().getRules().contains((Object)rule)) {
                throw new StateSpaceException("Illegal transition in state " + transition.getSource());
            }
            RuleApplication application = StateSpaceManagerImpl.createRuleApplication(model, rule, engine);
            List matches = application.findAllMatches();
            if (matches.size() <= transition.getMatch()) {
                throw new StateSpaceException("Illegal transition in state " + transition.getSource());
            }
            Match match = (Match)matches.get(transition.getMatch());
            application.setMatch(match);
            application.apply();
            this.storeModel(transition.getTarget(), model.getCopy(null));
        }
        this.releaseEngine(engine);
        this.storeModel(path.getSource(), start);
        return model;
    }

    @Override
    public List<State> exploreStates(List<State> states, boolean generateLocation) throws StateSpaceException {
        ArrayList<State> result = new ArrayList<State>();
        try {
            for (State state : states) {
                result.addAll(this.exploreState(state, generateLocation));
            }
        }
        catch (Throwable t) {
            if (t instanceof StateSpaceException) {
                throw (StateSpaceException)t;
            }
            throw new StateSpaceException(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<State> exploreState(State state, boolean generateLocation) throws StateSpaceException {
        int maxStateDistance = this.getStateSpace().getMaxStateDistance();
        if (maxStateDistance >= 0 && this.getStateDistance(state) >= maxStateDistance) {
            return Collections.emptyList();
        }
        List<Transition> transitions = this.doExplore(state);
        int newStates = 0;
        ArrayList<State> result = new ArrayList<State>(transitions.size());
        StateSpaceMonitor monitor = new StateSpaceMonitor(this.getStateSpace());
        Object object = this.explorerLock;
        synchronized (object) {
            monitor.setActive(true);
        }
        for (Transition current : transitions) {
            Rule rule = current.getRule();
            int match = current.getMatch();
            int[] parameters = current.getParameterIDs();
            int hashCode = current.getTarget().getHashCode();
            Model transformed = current.getTarget().getModel();
            boolean newState = false;
            int[] location = generateLocation ? StateSpaceManagerImpl.shiftedLocation(state, newStates++) : null;
            State target = this.getState(transformed, hashCode);
            Object object2 = this.explorerLock;
            synchronized (object2) {
                if (target == null) {
                    target = this.findState(transformed, hashCode, monitor.getAddedStates());
                } else if (monitor.getRemovedStates().contains(target)) {
                    target = null;
                }
                if (target == null) {
                    target = this.createOpenState(transformed, hashCode, location);
                    monitor.getAddedStates().remove(target);
                    newState = true;
                }
            }
            if (newState || StateSpaceManagerImpl.findTransition(state, target, rule, parameters) == null) {
                this.createTransition(state, target, rule, match, parameters);
            }
            if (!newState) continue;
            this.storeModel(target, transformed);
            result.add(target);
        }
        object = this.explorerLock;
        synchronized (object) {
            monitor.setActive(false);
        }
        this.setOpen(state, false);
        return result;
    }

    protected List<Transition> doExplore(State state) throws StateSpaceException {
        EmfEngine engine = this.acquireEngine();
        Model model = this.getModel(state);
        boolean ignoreNodeIDs = this.getStateSpace().getEqualityHelper().isIgnoreNodeIDs();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (Rule rule : this.getStateSpace().getRules()) {
            RuleApplication application = StateSpaceManagerImpl.createRuleApplication(model, rule, engine);
            List matches = application.findAllMatches();
            List<Node> parameters = ignoreNodeIDs ? null : ParametersPropertiesManager.getParameters(this.getStateSpace(), rule);
            int i = 0;
            while (i < matches.size()) {
                Match match = (Match)matches.get(i);
                Model transformed = model.getCopy(match);
                EmfGraph graph = StateSpaceManagerImpl.createEmfGraph(transformed);
                application = StateSpaceManagerImpl.createRuleApplication(graph, rule, engine);
                application.setMatch(match);
                application.apply();
                Resource resource = transformed.getResource();
                for (EObject root : graph.getRootObjects()) {
                    if (resource.getContents().contains((Object)root)) continue;
                    resource.getContents().add((Object)root);
                }
                State newState = StateSpaceFactory.eINSTANCE.createState();
                newState.setModel(transformed);
                if (!ignoreNodeIDs) {
                    transformed.updateNodeIDs();
                    int[] nodeIDs = transformed.getNodeIDs();
                    newState.setNodeIDs(nodeIDs);
                    newState.setNodeCount(nodeIDs.length);
                }
                newState.setHashCode(this.hashCode(transformed));
                Transition newTransition = StateSpaceFactory.eINSTANCE.createTransition();
                newTransition.setRule(rule);
                newTransition.setMatch(i);
                newTransition.setTarget(newState);
                if (!ignoreNodeIDs) {
                    int[] paramIDs = new int[parameters.size()];
                    int p = 0;
                    while (p < paramIDs.length) {
                        Node node = parameters.get(p);
                        EObject matched = (EObject)match.getNodeMapping().get(node);
                        if (matched == null) {
                            matched = (EObject)application.getComatch().getNodeMapping().get(node);
                        }
                        paramIDs[p] = (Integer)transformed.getNodeIDsMap().get((Object)matched);
                        ++p;
                    }
                    newTransition.setParameterIDs(paramIDs);
                    newTransition.setParameterCount(paramIDs.length);
                }
                transitions.add(newTransition);
                ++i;
            }
        }
        this.releaseEngine(engine);
        return transitions;
    }

    private State findState(Model model, int hashCode, Collection<State> states) throws StateSpaceException {
        for (State state : states) {
            if (hashCode != state.getHashCode() || !this.equals(model, this.getModel(state))) continue;
            return state;
        }
        return null;
    }

    @Override
    protected int hashCode(Model model) {
        if (this.getStateSpace().getEqualityHelper().isGraphEquality()) {
            HashCodeMap map = new HashCodeMap();
            int hashcode = this.getStateSpace().getEqualityHelper().hashCode(model, map);
            this.codesCache.put(model, map);
            return hashcode;
        }
        return this.getStateSpace().getEqualityHelper().hashCode(model, null);
    }

    @Override
    protected boolean equals(Model model1, Model model2) {
        if (this.getStateSpace().getEqualityHelper().isGraphEquality()) {
            HashCodeMap map2;
            HashCodeMap map1 = this.codesCache.get(model1);
            if (map1 == null) {
                map1 = new HashCodeMap();
                this.getStateSpace().getEqualityHelper().hashCode(model1, map1);
                this.codesCache.put(model1, map1);
            }
            if ((map2 = this.codesCache.get(model2)) == null) {
                map2 = new HashCodeMap();
                this.getStateSpace().getEqualityHelper().hashCode(model2, map2);
                this.codesCache.put(model2, map2);
            }
            return this.getStateSpace().getEqualityHelper().equals(model1, map1, model2, map2);
        }
        return super.equals(model1, model2);
    }

    private static EmfGraph createEmfGraph(Model model) {
        EmfGraph graph = new EmfGraph();
        for (EObject root : model.getResource().getContents()) {
            graph.addRoot(root);
        }
        return graph;
    }

    private static RuleApplication createRuleApplication(EmfGraph graph, Rule rule, EmfEngine engine) {
        engine.setEmfGraph(graph);
        return new RuleApplication((InterpreterEngine)engine, rule);
    }

    private static RuleApplication createRuleApplication(Model model, Rule rule, EmfEngine engine) {
        EmfGraph graph = StateSpaceManagerImpl.createEmfGraph(model);
        return StateSpaceManagerImpl.createRuleApplication(graph, rule, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmfEngine acquireEngine() {
        Stack<EmfEngine> stack = this.engines;
        synchronized (stack) {
            if (!this.engines.isEmpty()) {
                return this.engines.pop();
            }
            EmfEngine engine = new EmfEngine();
            TransformationOptions options = new TransformationOptions();
            options.setDeterministic(true);
            engine.setOptions(options);
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEngine(EmfEngine engine) {
        Stack<EmfEngine> stack = this.engines;
        synchronized (stack) {
            this.engines.push(engine);
        }
    }

    private static int[] shiftedLocation(State base, int index) {
        int[] location = base.getLocation();
        double angle = Math.PI * (double)index * 0.17;
        location[0] = (int)((double)location[0] + 60.0 * Math.cos(angle));
        location[1] = (int)((double)location[1] + 60.0 * Math.sin(angle));
        return location;
    }

    public void clearStateModelCache() {
        int index = 0;
        for (State state : this.getStateSpace().getStates()) {
            if (++index % 10 == 0 || state.isInitial()) continue;
            state.setModel(null);
        }
        this.modelCache.clear();
        this.codesCache.clear();
        System.gc();
    }

    protected void performExplorationSanityCheck(State state) throws StateSpaceException {
        List<Transition> transitions = this.doExplore(state);
        int i = 0;
        while (i < 25) {
            List<Transition> transitions2 = this.doExplore(state);
            if (transitions.size() != transitions2.size()) {
                this.markTainted();
                throw new StateSpaceException("Sanity check 1 failed!");
            }
            int j = 0;
            while (j < transitions.size()) {
                Transition t1 = transitions.get(j);
                Transition t2 = transitions2.get(j);
                if (t1.getRule() != t2.getRule() || t1.getMatch() != t2.getMatch()) {
                    this.markTainted();
                    throw new StateSpaceException("Sanity check 2 failed!");
                }
                if (!this.equals(t1.getTarget().getModel(), t2.getTarget().getModel())) {
                    this.markTainted();
                    throw new StateSpaceException("Sanity check 3 failed!");
                }
                if (t1.getTarget().getHashCode() != t2.getTarget().getHashCode()) {
                    this.markTainted();
                    throw new StateSpaceException("Sanity check 4 failed!");
                }
                ++j;
            }
            ++i;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        public static final int CACHE_SIZE = 4096;
        private static final long serialVersionUID = 1L;

        Cache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 4096;
        }
    }
}

