/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.hashcodes;

import java.util.HashMap;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;

public class HashCodeCollisionCounter {
    public static double getNumStatesPerHash(StateSpace stateSpace) {
        HashMap<Integer, Integer> numStatesPerHash = new HashMap<Integer, Integer>();
        for (State state : stateSpace.getStates()) {
            int hashcode = state.getHashCode();
            Integer numStates = (Integer)numStatesPerHash.get(hashcode);
            if (numStates == null) {
                numStatesPerHash.put(hashcode, 1);
                continue;
            }
            numStatesPerHash.put(hashcode, numStates + 1);
        }
        int sum = 0;
        for (Integer count : numStatesPerHash.values()) {
            sum += count.intValue();
        }
        double average = (double)sum / (double)numStatesPerHash.values().size();
        return average;
    }
}

