/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class RemoveMappedNodesMenuContributor
extends MenuContributor {
    public static MenuContributor INSTANCE = new RemoveMappedNodesMenuContributor();
    private static final String COMMAND_LABEL_IMAGE = "RemoveImageNode";
    private static final String COMMAND_LABEL_IMAGE_RHS = "RemoveImageNode_FromRhs";
    private static final String COMMAND_LABEL_IMAGE_NC = "RemoveImageNode_FromNestedCondition";
    private static final String COMMAND_LABEL_IMAGE_ALL = "RemoveImageNode_All";
    private static final String COMMAND_LABEL_ORIGIN = "RemoveOriginNode";

    @Override
    protected void contributeActions(IMenuManager menuManager, List<?> selection) {
        this.buildRemoveMappingImages(menuManager, selection);
        this.buildRemoveMappingOrigin(menuManager, selection);
    }

    private void buildRemoveMappingImages(IMenuManager menuManager, List<?> selection) {
        Command cmd;
        EList mappings;
        if (selection.size() != 1 || !(selection.get(0) instanceof Node)) {
            return;
        }
        Node node = (Node)selection.get(0);
        if (node.eContainer() == null) {
            return;
        }
        MenuManager subMenu = new MenuManager(this.getLabel(COMMAND_LABEL_IMAGE));
        if (HenshinRuleAnalysisUtil.isLHS((Graph)node.getGraph()) || HenshinRuleAnalysisUtil.isRHS((Graph)node.getGraph())) {
            mappings = node.getGraph().getContainerRule().getMappings();
        } else if (node.getGraph().eContainer() instanceof NestedCondition) {
            mappings = ((NestedCondition)node.getGraph().eContainer()).getMappings();
        } else {
            return;
        }
        ArrayList<Mapping> ruleMappings = new ArrayList<Mapping>();
        ArrayList<Mapping> conditionMappings = new ArrayList<Mapping>();
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() != node || mapping.getImage() == null) continue;
            if (HenshinRuleAnalysisUtil.isRHS((Graph)mapping.getImage().getGraph())) {
                ruleMappings.add(mapping);
            }
            if (!HenshinRuleAnalysisUtil.isConclusion((Graph)mapping.getImage().getGraph())) continue;
            conditionMappings.add(mapping);
        }
        ArrayList<Command> cmds = new ArrayList<Command>();
        for (Mapping mapping : ruleMappings) {
            cmd = RemoveCommand.create((EditingDomain)this.domain, (Object)mapping.getImage());
            cmds.add(cmd);
            subMenu.add(this.createAction(String.valueOf(this.getLabel(COMMAND_LABEL_IMAGE_RHS)) + ": " + mapping.getImage().getName(), cmd));
        }
        if (ruleMappings.size() > 0 && conditionMappings.size() > 0) {
            subMenu.add((IContributionItem)new Separator());
        }
        for (Mapping mapping : conditionMappings) {
            cmd = RemoveCommand.create((EditingDomain)this.domain, (Object)mapping.getImage());
            cmds.add(cmd);
            subMenu.add(this.createAction(String.valueOf(this.getLabel(COMMAND_LABEL_IMAGE_NC)) + ": " + mapping.getImage().getGraph().getName(), cmd));
        }
        if (ruleMappings.size() + conditionMappings.size() > 1) {
            subMenu.add((IContributionItem)new Separator());
            CompoundCommand removeAllCmd = new CompoundCommand();
            for (Command cmd2 : cmds) {
                removeAllCmd.append(cmd2);
            }
            subMenu.add(this.createAction(String.valueOf(this.getLabel(COMMAND_LABEL_IMAGE_ALL)) + "(" + cmds.size() + ")", (Command)removeAllCmd));
        }
        if (subMenu.getSize() > 0) {
            menuManager.add((IContributionItem)subMenu);
        }
    }

    private void buildRemoveMappingOrigin(IMenuManager menuManager, List<?> selection) {
        if (selection.size() != 1) {
            return;
        }
        if (!(selection.get(0) instanceof Node)) {
            return;
        }
        Node node = (Node)selection.get(0);
        if (node.eContainer() == null) {
            return;
        }
        if (HenshinRuleAnalysisUtil.isLHS((Graph)node.getGraph())) {
            return;
        }
        if (HenshinRuleAnalysisUtil.isRHS((Graph)node.getGraph())) {
            for (Mapping mapping : node.getGraph().getContainerRule().getMappings()) {
                if (mapping.getImage() != node) continue;
                menuManager.add(this.createAction(String.valueOf(this.getLabel(COMMAND_LABEL_ORIGIN)) + ": " + mapping.getOrigin().getName(), RemoveCommand.create((EditingDomain)this.domain, (Object)mapping.getOrigin())));
                return;
            }
        }
        if (HenshinRuleAnalysisUtil.isConclusion((Graph)node.getGraph())) {
            NestedCondition nc = (NestedCondition)node.getGraph().eContainer();
            for (Mapping mapping : this.getMappingsToFormula((Formula)nc)) {
                if (mapping.getImage() != node) continue;
                menuManager.add(this.createAction(String.valueOf(this.getLabel(COMMAND_LABEL_ORIGIN)) + ": " + mapping.getOrigin().getName(), RemoveCommand.create((EditingDomain)this.domain, (Object)mapping.getOrigin())));
                return;
            }
        }
    }

    protected Collection<Mapping> getMappingsToFormula(Formula formula) {
        if (formula.eContainer() instanceof Formula) {
            return this.getMappingsToFormula((Formula)formula.eContainer());
        }
        if (formula.eContainer() instanceof Graph) {
            Graph graph = (Graph)formula.eContainer();
            if (HenshinRuleAnalysisUtil.isConclusion((Graph)graph)) {
                return ((NestedCondition)graph.eContainer()).getMappings();
            }
            if (HenshinRuleAnalysisUtil.isLHS((Graph)graph) || HenshinRuleAnalysisUtil.isRHS((Graph)graph)) {
                return graph.getContainerRule().getMappings();
            }
            throw new IllegalArgumentException("Forumla not properly connected to model!");
        }
        throw new IllegalArgumentException("Forumla not properly connected to model!");
    }
}

