/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.tikz;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceExporter;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.layout.TransitionBendpointHelper;

public class TikZStateSpaceExporter
implements StateSpaceExporter {
    public void export(StateSpace stateSpace, URI uri, IProgressMonitor monitor) throws IOException {
        File file = new File(uri.toFileString());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 65536);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        int states = stateSpace.getStates().size();
        int transitions = stateSpace.getTransitionCount();
        monitor.beginTask("Exporting state space...", states + transitions + 1);
        writer.write("\\begin{tikzpicture}[scale=0.5]\n");
        writer.write("\\definecolor{normfill}{rgb}{" + TikZStateSpaceExporter.color2String(State.COLOR_DEFAULT) + "}\n");
        writer.write("\\definecolor{initfill}{rgb}{" + TikZStateSpaceExporter.color2String(State.COLOR_INITIAL) + "}\n");
        writer.write("\\definecolor{openfill}{rgb}{" + TikZStateSpaceExporter.color2String(State.COLOR_OPEN) + "}\n");
        writer.write("\\definecolor{termfill}{rgb}{" + TikZStateSpaceExporter.color2String(State.COLOR_TERMINAL) + "}\n");
        writer.write("\\tikzstyle{henstate}=[circle,draw,fill=normfill,inner sep=1pt,minimum size=4mm,font=\\small]\n");
        writer.write("\\tikzstyle{heninit}=[fill=initfill]\n");
        writer.write("\\tikzstyle{henopen}=[fill=openfill]\n");
        writer.write("\\tikzstyle{henterm}=[fill=termfill]\n");
        writer.write("\\tikzstyle{hentrans}=[->,>=stealth',bend angle=15,font=\\small]\n\n");
        monitor.worked(1);
        for (State state : stateSpace.getStates()) {
            int[] location = state.getLocation();
            int index = state.getIndex();
            writer.write("\\node at(" + location[0] + "pt," + -location[1] + "pt) [henstate");
            if (state.isInitial()) {
                writer.write(",heninit");
            } else if (state.isOpen()) {
                writer.write(",henopen");
            } else if (state.isTerminal()) {
                writer.write(",henterm");
            }
            writer.write("] (s" + index + ") {" + index + "};\n");
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            writer.close();
            return;
        }
        writer.write("\n");
        for (State state : stateSpace.getStates()) {
            int source = state.getIndex();
            for (Transition transition : state.getOutgoing()) {
                int target = transition.getTarget().getIndex();
                String label = transition.getLabel();
                int distance = TransitionBendpointHelper.getBendpointDistance((Transition)transition);
                String bend = distance != 0 ? ",bend left=" + Math.abs(distance) : "";
                writer.write("\\draw (s" + source + ") edge[hentrans" + bend + "] node[auto] {" + label + "} (s" + target + ");\n");
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                writer.close();
                return;
            }
        }
        writer.write("\n\\end{tikzpicture}\n");
        writer.close();
        monitor.done();
    }

    private static String color2String(int[] rgb) {
        return String.valueOf((double)rgb[0] / 255.0) + "," + (double)rgb[1] / 255.0 + "," + (double)rgb[2] / 255.0;
    }

    public String getName() {
        return "TikZ";
    }

    public String[] getFileExtensions() {
        return new String[]{"tex"};
    }
}

