/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Rule;

public class Matches {
    public static void assertObjectContainedInAllMatches(Rule r, EmfGraph graph, EObject object) throws AssertionError {
        Matches.assertObjectContainedInAllMatches(r, new EmfEngine(graph), object);
    }

    public static void assertObjectContainedInAllMatches(Rule r, EmfEngine engine, EObject object) throws AssertionError {
        Matches.assertObjectContainedInAllMatches(new RuleApplication((InterpreterEngine)engine, r), object);
    }

    public static void assertObjectContainedInAllMatches(RuleApplication ra, EObject object) throws AssertionError {
        boolean cMatch = false;
        for (Match m : ra.findAllMatches()) {
            cMatch = false;
            if (m.getNodeMapping().values().contains(object)) {
                cMatch = true;
            }
            if (!cMatch) {
                throw new AssertionError((Object)"expected: Object contained in every match, but it's not");
            }
        }
        if (ra.findAllMatches().size() == 0) {
            throw new AssertionError((Object)"expected: Object contained in every match, but Rule produces no matches");
        }
    }

    public static void assertObjectContainedInNoMatch(Rule r, EmfGraph graph, EObject object) throws AssertionError {
        Matches.assertObjectContainedInNoMatch(r, new EmfEngine(graph), object);
    }

    public static void assertObjectContainedInNoMatch(Rule r, EmfEngine engine, EObject object) throws AssertionError {
        Matches.assertObjectContainedInNoMatch(new RuleApplication((InterpreterEngine)engine, r), object);
    }

    public static void assertObjectContainedInNoMatch(RuleApplication ra, EObject object) throws AssertionError {
        for (Match m : ra.findAllMatches()) {
            if (m.getNodeMapping().values().contains(object)) {
                throw new AssertionError((Object)"expected: Object contained in no match, but contained in at least one");
            }
        }
    }

    public static void assertObjectContainedInNMatches(Rule r, EmfGraph graph, EObject object, int n) throws AssertionError {
        Matches.assertObjectContainedInNMatches(r, new EmfEngine(graph), object, n);
    }

    public static void assertObjectContainedInNMatches(Rule r, EmfEngine engine, EObject object, int n) throws AssertionError {
        Matches.assertObjectContainedInNMatches(new RuleApplication((InterpreterEngine)engine, r), object, n);
    }

    public static void assertObjectContainedInNMatches(RuleApplication ra, EObject object, int n) throws AssertionError {
        int num = n;
        for (Match m : ra.findAllMatches()) {
            if (m.getNodeMapping().values().contains(object)) {
                --num;
            }
            if (num < 0) {
                throw new AssertionError((Object)("expected: Object contained in " + n + " matches, but contained in more"));
            }
        }
        if (num > 0) {
            throw new AssertionError((Object)("expected: Object contained in " + n + " matches, but contained in less"));
        }
    }

    public static void assertObjectContainedInAtLeastOneMatch(Rule r, EmfGraph graph, EObject object) throws AssertionError {
        Matches.assertObjectContainedInAtLeastOneMatch(r, new EmfEngine(graph), object);
    }

    public static void assertObjectContainedInAtLeastOneMatch(Rule r, EmfEngine engine, EObject object) throws AssertionError {
        Matches.assertObjectContainedInAtLeastOneMatch(new RuleApplication((InterpreterEngine)engine, r), object);
    }

    public static void assertObjectContainedInAtLeastOneMatch(RuleApplication ra, EObject object) throws AssertionError {
        for (Match m : ra.findAllMatches()) {
            if (!m.getNodeMapping().values().contains(object)) continue;
            return;
        }
        throw new AssertionError((Object)("expected: Object is contained in at least one match of " + ra.getRule().getName() + ", but is contained in none"));
    }

    public static void assertNoObjectFromGroupContainedInAnyMatch(Rule r, EmfGraph graph, Collection<? extends EObject> group) {
        Matches.assertNoObjectFromGroupContainedInAnyMatch(r, new EmfEngine(graph), group);
    }

    public static void assertNoObjectFromGroupContainedInAnyMatch(Rule r, EmfEngine engine, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertNoObjectFromGroupContainedInAnyMatch(new RuleApplication((InterpreterEngine)engine, r), group);
    }

    public static void assertNoObjectFromGroupContainedInAnyMatch(RuleApplication ra, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : ra.findAllMatches()) {
            for (EObject eObject : group) {
                if (m.getNodeMapping().values().contains(eObject)) {
                    throw new AssertionError((Object)("expected: No object from group is contained in any match, but at least " + eObject + " is contained in at least one"));
                }
            }
        }
    }

    public static void assertGroupContainedInNoMatch(Rule r, EmfGraph graph, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertGroupContainedInNoMatch(r, new EmfEngine(graph), group);
    }

    public static void assertGroupContainedInNoMatch(Rule r, EmfEngine engine, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertGroupContainedInNoMatch(new RuleApplication((InterpreterEngine)engine, r), group);
    }

    public static void assertGroupContainedInNoMatch(RuleApplication ra, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : ra.findAllMatches()) {
            if (m.getNodeMapping().values().containsAll(group)) {
                throw new AssertionError((Object)"expected: Group is contained in no match, but is contained in at least one");
            }
        }
    }

    public static void assertGroupContainedInAtLeastOneMatch(Rule r, EmfGraph graph, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertGroupContainedInAtLeastOneMatch(r, new EmfEngine(graph), group);
    }

    public static void assertGroupContainedInAtLeastOneMatch(Rule r, EmfEngine engine, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertGroupContainedInAtLeastOneMatch(new RuleApplication((InterpreterEngine)engine, r), group);
    }

    public static void assertGroupContainedInAtLeastOneMatch(RuleApplication ra, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : ra.findAllMatches()) {
            if (!m.getNodeMapping().values().containsAll(group)) continue;
            return;
        }
        throw new AssertionError((Object)("expected: Group is contained in at least one match of " + ra.getRule().getName() + ", but is contained in none"));
    }

    public static void assertAnyObjectFromGroupContainedInAtLeastOneMatch(Rule r, EmfGraph graph, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertAnyObjectFromGroupContainedInAtLeastOneMatch(r, new EmfEngine(graph), group);
    }

    public static void assertAnyObjectFromGroupContainedInAtLeastOneMatch(Rule r, EmfEngine engine, Collection<? extends EObject> group) throws AssertionError {
        Matches.assertAnyObjectFromGroupContainedInAtLeastOneMatch(new RuleApplication((InterpreterEngine)engine, r), group);
    }

    public static void assertAnyObjectFromGroupContainedInAtLeastOneMatch(RuleApplication ra, Collection<? extends EObject> group) throws AssertionError {
        List matches = ra.findAllMatches();
        for (Match m : matches) {
            for (EObject eObject : group) {
                if (!m.getNodeMapping().values().contains(eObject)) continue;
                return;
            }
        }
        throw new AssertionError((Object)"expected: At least one object from group is contained in at least one match, but isn't.");
    }

    public static void assertElementMatchedByUnitApplication(UnitApplication ua, EObject element) throws AssertionError {
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (!ra.getMatch().getNodeMapping().containsValue(element)) continue;
            return;
        }
        throw new AssertionError((Object)("expected: Element " + element + " matched by a Rule in the UnitApplication, but wasn't."));
    }

    public static void assertElementNotMatchedByUnitApplication(UnitApplication ua, EObject element) throws AssertionError {
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (ra.getMatch().getNodeMapping().containsValue(element)) {
                throw new AssertionError((Object)("expected: Element " + element + " not matched by a Rule in the UnitApplication, but was matched by " + ra.getRule().getName()));
            }
        }
    }

    public static void assertElementMatchedByUnitApplicationNTimes(UnitApplication ua, EObject element, int n) throws AssertionError {
        int ctr = n;
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (!ra.getMatch().getNodeMapping().containsValue(element)) continue;
            --ctr;
        }
        if (ctr == 0) {
            return;
        }
        throw new AssertionError((Object)("expected: Element " + element + " matched by a Rule in the UnitApplication " + n + " times, but was matched " + (n - ctr) + " times"));
    }

    public static void assertGroupMatchedByUnitApplication(UnitApplication ua, Collection<? extends EObject> group) throws AssertionError {
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (!ra.getMatch().getNodeMapping().values().containsAll(group)) continue;
            return;
        }
        throw new AssertionError((Object)"expected: Group matched by unit application");
    }

    public static void assertGroupNotMatchedByUnitApplication(UnitApplication ua, Collection<? extends EObject> group) throws AssertionError {
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (ra.getMatch().getNodeMapping().values().containsAll(group)) {
                throw new AssertionError((Object)"expected: Group not matched by unit application");
            }
        }
    }

    public static void assertNoElementInGroupMatchedByAnyRuleInUnitApplication(UnitApplication ua, Collection<? extends EObject> group) throws AssertionError {
        for (RuleApplication ra : ua.getAppliedRules()) {
            for (EObject eObject : group) {
                if (ra.getMatch().getNodeMapping().containsValue(eObject)) {
                    throw new AssertionError((Object)("Expected: No element from group matched by any RuleApplication, but <" + eObject + "> was matched by <" + ra.getRule().getName() + ">"));
                }
            }
        }
    }

    public static void assertAllElementsInGroupMatchedByUnitApplication(UnitApplication ua, Collection<? extends EObject> group) throws AssertionError {
        HashMap<EObject, Boolean> matchStatus = new HashMap<EObject, Boolean>();
        for (EObject eObject : group) {
            matchStatus.put(eObject, false);
        }
        for (RuleApplication ruleApplication : ua.getAppliedRules()) {
            for (EObject eo : ruleApplication.getMatch().getNodeMapping().values()) {
                if (!matchStatus.containsKey(eo)) continue;
                matchStatus.put(eo, true);
            }
        }
        if (matchStatus.containsValue(false)) {
            throw new AssertionError((Object)"Expected: All elements from group are matched, but some are not.");
        }
    }

    public static void assertGroupIsMatched(RuleApplication ra, Collection<? extends EObject> group) throws AssertionError {
        HashMap<EObject, Boolean> matchContained = new HashMap<EObject, Boolean>();
        for (EObject eObject : group) {
            matchContained.put(eObject, false);
        }
        for (Match match : ra.findAllMatches()) {
            for (EObject eo2 : match.getNodeMapping().values()) {
                matchContained.put(eo2, true);
            }
        }
        if (matchContained.containsValue(false)) {
            System.out.println("~~~~~~");
            for (Map.Entry entry : matchContained.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                System.out.println(entry.getKey() + " -> " + entry.getValue());
            }
            throw new AssertionError((Object)"expected: group is matched, but some elements aren't.");
        }
    }

    public static void assertOnlyGroupIsMatched(RuleApplication ra, Collection<? extends EObject> group) throws AssertionError {
        if (ra.getInterpreterEngine() instanceof EmfEngine && !ra.getRule().isInjectiveMatching()) {
            HashMap<EObject, Integer> matchContents = new HashMap<EObject, Integer>();
            for (EObject eObject : group) {
                if (matchContents.containsKey(eObject)) {
                    matchContents.put(eObject, (Integer)matchContents.get(eObject) + 1);
                    continue;
                }
                matchContents.put(eObject, 1);
            }
            for (Match match : ra.findAllMatches()) {
                for (EObject eo : match.getNodeMapping().values()) {
                    if (group.contains(eo)) {
                        matchContents.put(eo, (Integer)matchContents.get(eo) - 1);
                        continue;
                    }
                    throw new AssertionError((Object)"expected: entire group + only elements from group are matched, but match contains elements not in group");
                }
            }
            for (Integer n : matchContents.values()) {
                if (n != 0) {
                    throw new AssertionError((Object)"expected: group is matched, but some elements aren't.");
                }
            }
        } else {
            HashMap<EObject, Boolean> matchContents = new HashMap<EObject, Boolean>();
            for (EObject eObject : group) {
                matchContents.put(eObject, false);
            }
            for (Match match : ra.findAllMatches()) {
                for (EObject eo : match.getNodeMapping().values()) {
                    if (group.contains(eo)) {
                        matchContents.put(eo, true);
                        continue;
                    }
                    throw new AssertionError((Object)"expected: entire group + only elements from group are matched, but match contains elements not in group");
                }
            }
            if (matchContents.containsValue(false)) {
                throw new AssertionError((Object)"expected: group is matched, but some elements aren't.");
            }
        }
    }

    public static void assertMatchIsGroup(Match match, Collection<? extends EObject> group) throws AssertionError {
        HashMap<EObject, Integer> matchContents = new HashMap<EObject, Integer>();
        for (EObject eObject : group) {
            if (matchContents.containsKey(eObject)) {
                matchContents.put(eObject, (Integer)matchContents.get(eObject) + 1);
                continue;
            }
            matchContents.put(eObject, 1);
        }
        for (EObject eObject : match.getNodeMapping().values()) {
            if (group.contains(eObject)) {
                matchContents.put(eObject, (Integer)matchContents.get(eObject) - 1);
                continue;
            }
            throw new AssertionError((Object)"match contains elements not in group");
        }
        for (Integer n : matchContents.values()) {
            if (n != 0) {
                throw new AssertionError((Object)"expected: match is group, but some elements in the group are not in the match");
            }
        }
    }
}

