/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.matching.constraints.Solution;
import org.eclipse.emf.henshin.matching.constraints.Variable;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;

public class Match {
    private Rule rule;
    private Map<Node, EObject> nodeMapping;
    private Map<Parameter, Object> parameterValues;

    public Match(Rule rule, Map<Parameter, Object> parameterValues, Map<Node, EObject> nodeMapping) {
        this.parameterValues = parameterValues;
        this.nodeMapping = nodeMapping;
        this.rule = rule;
    }

    public Match(Rule rule, Solution solution, Map<Node, Variable> node2variable) {
        if (solution != null) {
            this.parameterValues = new HashMap<Parameter, Object>();
            for (String parameterName : solution.getParameterValues().keySet()) {
                Parameter parameter = rule.getParameterByName(parameterName);
                if (parameter == null) continue;
                this.parameterValues.put(parameter, solution.getParameterValues().get(parameterName));
            }
            this.nodeMapping = new HashMap<Node, EObject>();
            Map objectMatch = solution.getObjectMatches();
            for (Node node : rule.getLhs().getNodes()) {
                Variable var = node2variable.get(node);
                EObject eObject = (EObject)objectMatch.get(var);
                this.nodeMapping.put(node, eObject);
            }
        }
        this.rule = rule;
    }

    public Map<Parameter, Object> getParameterValues() {
        return this.parameterValues;
    }

    public Map<Node, EObject> getNodeMapping() {
        return this.nodeMapping;
    }

    public boolean overlapsWith(Match match) {
        ArrayList<EObject> thistargets = new ArrayList<EObject>(this.nodeMapping.values());
        ArrayList<EObject> matchtargets = new ArrayList<EObject>(match.getNodeMapping().values());
        thistargets.retainAll(matchtargets);
        if (thistargets.size() == 0) {
            return false;
        }
        return thistargets.size() != 0;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isComplete() {
        if (this.nodeMapping == null && this.rule.getLhs().getNodes().size() > 0) {
            return false;
        }
        for (Node node : this.rule.getLhs().getNodes()) {
            if (this.nodeMapping.get(node) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (!this.isComplete()) {
            return false;
        }
        for (Node node : this.rule.getLhs().getNodes()) {
            if (!node.getType().isSuperTypeOf(this.nodeMapping.get(node).eClass())) continue;
            return false;
        }
        for (Node node : this.rule.getLhs().getNodes()) {
            EObject source = this.nodeMapping.get(node);
            for (Edge edge : node.getOutgoing()) {
                List targetObjects;
                EReference edgeType = edge.getType();
                EObject target = this.nodeMapping.get(edge.getTarget());
                if (!(edgeType.isMany() ? !(targetObjects = (List)source.eGet((EStructuralFeature)edgeType)).contains(target) : source.eGet((EStructuralFeature)edgeType) != target)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Match)) {
            return false;
        }
        Match match = (Match)arg0;
        if (this.rule != match.getRule()) {
            return false;
        }
        for (Parameter param : this.getParameterValues().keySet()) {
            if (this.getParameterValues().get(param) == match.getParameterValues().get(param)) continue;
            return false;
        }
        for (Node node : this.getNodeMapping().keySet()) {
            if (this.getNodeMapping().get(node) == match.getNodeMapping().get(node)) continue;
            return false;
        }
        return true;
    }
}

