/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    private static final ImmutableList<?> EMPTY_IMMUTABLE_LIST = new EmptyImmutableList();

    public static <E> ImmutableList<E> of() {
        return EMPTY_IMMUTABLE_LIST;
    }

    public static <E> ImmutableList<E> of(E element) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(element));
    }

    public static <E> ImmutableList<E> of(E e1, E e2) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2));
    }

    public static <E> ImmutableList<E> of(E e1, E e2, E e3) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2, e3));
    }

    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2, e3, e4));
    }

    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2, e3, e4, e5));
    }

    public static <E> ImmutableList<E> of(E ... elements) {
        return elements.length == 0 ? ImmutableList.of() : new RegularImmutableList(ImmutableList.copyIntoArray(elements));
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableList) {
            ImmutableList list = (ImmutableList)elements;
            return list;
        }
        return ImmutableList.copyOfInternal(Collections2.toCollection(elements));
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> elements) {
        return ImmutableList.copyOfInternal(Lists.newArrayList(elements));
    }

    private static <E> ImmutableList<E> copyOfInternal(Collection<?> collection) {
        int size = collection.size();
        return size == 0 ? ImmutableList.of() : new RegularImmutableList(ImmutableList.copyIntoArray(collection, size));
    }

    private ImmutableList() {
    }

    @Override
    public abstract int indexOf(@Nullable Object var1);

    @Override
    public abstract int lastIndexOf(@Nullable Object var1);

    @Override
    public abstract ImmutableList<E> subList(int var1, int var2);

    @Override
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    private static Object[] copyIntoArray(Object ... source) {
        Object[] array = new Object[source.length];
        int index = 0;
        Object[] objectArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
            ++n2;
        }
        return array;
    }

    private static Object[] copyIntoArray(Iterable<?> source, int size) {
        Object[] array = new Object[size];
        int index = 0;
        for (Object element : source) {
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        return array;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    /* synthetic */ ImmutableList(ImmutableList immutableList) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyImmutableList
    extends ImmutableList<Object> {
        private EmptyImmutableList() {
            super(null);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object target) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + ", list size is 0");
        }

        @Override
        public int indexOf(Object target) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            return -1;
        }

        @Override
        public ImmutableList<Object> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException("Invalid range: " + fromIndex + ".." + toIndex + ", list size is 0");
            }
            return this;
        }

        @Override
        public ListIterator<Object> listIterator() {
            return Iterators.emptyListIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int start) {
            if (start != 0) {
                throw new IndexOutOfBoundsException("Invalid index: " + start + ", list size is 0");
            }
            return Iterators.emptyListIterator();
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            return targets.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof List && ((List)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_IMMUTABLE_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegularImmutableList<E>
    extends ImmutableList<E> {
        private final int offset;
        private final int size;
        private final Object[] array;

        private RegularImmutableList(Object[] array, int offset, int size) {
            super(null);
            this.offset = offset;
            this.size = size;
            this.array = array;
        }

        private RegularImmutableList(Object[] array) {
            this(array, 0, array.length);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object target) {
            return this.indexOf(target) != -1;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.forArray(this.array, this.offset, this.size);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.size()];
            System.arraycopy(this.array, this.offset, newArray, 0, this.size);
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] other) {
            if (other.length < this.size) {
                other = ObjectArrays.newArray(other, this.size);
            } else if (other.length > this.size) {
                other[this.size] = null;
            }
            System.arraycopy(this.array, this.offset, other, 0, this.size);
            return other;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Invalid index: " + index + ", list size is " + this.size);
            }
            return (E)this.array[index + this.offset];
        }

        @Override
        public int indexOf(Object target) {
            if (target != null) {
                int i = this.offset;
                while (i < this.offset + this.size) {
                    if (this.array[i].equals(target)) {
                        return i - this.offset;
                    }
                    ++i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            if (target != null) {
                int i = this.offset + this.size - 1;
                while (i >= this.offset) {
                    if (this.array[i].equals(target)) {
                        return i - this.offset;
                    }
                    --i;
                }
            }
            return -1;
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Invalid range: " + fromIndex + ".." + toIndex + ", list size is " + this.size);
            }
            return fromIndex == toIndex ? ImmutableList.of() : new RegularImmutableList<E>(this.array, this.offset + fromIndex, toIndex - fromIndex);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int start) {
            if (start < 0 || start > this.size) {
                throw new IndexOutOfBoundsException("Invalid index: " + start + ", list size is " + this.size);
            }
            return new ListIterator<E>(start){
                int index;
                {
                    this.index = n;
                }

                @Override
                public boolean hasNext() {
                    return this.index < RegularImmutableList.this.size;
                }

                @Override
                public boolean hasPrevious() {
                    return this.index > 0;
                }

                @Override
                public int nextIndex() {
                    return this.index;
                }

                @Override
                public int previousIndex() {
                    return this.index - 1;
                }

                @Override
                public E next() {
                    Object result;
                    try {
                        result = RegularImmutableList.this.get(this.index);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    return result;
                }

                @Override
                public E previous() {
                    Object result;
                    try {
                        result = RegularImmutableList.this.get(this.index - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new NoSuchElementException();
                    }
                    --this.index;
                    return result;
                }

                @Override
                public void set(E o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof List)) {
                return false;
            }
            List that = (List)object;
            if (that.size() != this.size()) {
                return false;
            }
            int index = this.offset;
            if (object instanceof RegularImmutableList) {
                RegularImmutableList other = (RegularImmutableList)object;
                int i = other.offset;
                while (i < other.offset + other.size) {
                    if (!this.array[index++].equals(other.array[i])) {
                        return false;
                    }
                    ++i;
                }
            } else {
                for (Object element : that) {
                    if (this.array[index++].equals(element)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            int i = this.offset;
            while (i < this.offset + this.size) {
                hashCode = 31 * hashCode + this.array[i].hashCode();
                ++i;
            }
            return hashCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.size() * 16);
            sb.append('[').append(this.array[this.offset]);
            int i = this.offset + 1;
            while (i < this.offset + this.size) {
                sb.append(", ").append(this.array[i]);
                ++i;
            }
            return sb.append(']').toString();
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableList.of(this.elements);
        }
    }
}

