/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.inject.asm.AnnotationVisitor;
import com.google.inject.asm.Attribute;
import com.google.inject.asm.ClassReader;
import com.google.inject.asm.ClassVisitor;
import com.google.inject.asm.FieldVisitor;
import com.google.inject.asm.Label;
import com.google.inject.asm.MethodVisitor;
import com.google.inject.asm.Type;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class LineNumbers {
    private final Class cls;
    private Map<String, Integer> lines = new HashMap<String, Integer>();
    private String source;
    private int firstLine = Integer.MAX_VALUE;

    public LineNumbers(Class cls) throws IOException {
        this.cls = cls;
        InputStream in = cls.getResourceAsStream("/" + cls.getName().replace('.', '/') + ".class");
        if (in == null) {
            throw new IllegalArgumentException("Cannot find bytecode for " + cls);
        }
        new ClassReader(in).accept(new LineNumberReader(), 0);
    }

    public String getSource() {
        return this.source;
    }

    public Integer getLineNumber(Member member) {
        if (!this.cls.equals(member.getDeclaringClass())) {
            throw new IllegalArgumentException("Member " + member + " belongs to " + member.getDeclaringClass() + ", not " + this.cls);
        }
        return this.lines.get(LineNumbers.getKey(member));
    }

    public int getFirstLine() {
        return this.firstLine == Integer.MAX_VALUE ? 1 : this.firstLine;
    }

    private static String getKey(Member member) {
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            return member.getName() + Type.getMethodDescriptor((Method)member);
        }
        return "<init>" + Type.getConstructorDescriptor((Constructor)member);
    }

    private class LineNumberReader
    implements ClassVisitor,
    MethodVisitor {
        private int line = -1;
        private String pendingMethod;
        private String name;

        private LineNumberReader() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 2) != 0) {
                return null;
            }
            this.pendingMethod = name + desc;
            this.line = -1;
            return this;
        }

        public void visitSource(String source, String debug) {
            LineNumbers.this.source = source;
        }

        public void visitLineNumber(int line, Label start) {
            if (line < LineNumbers.this.firstLine) {
                LineNumbers.this.firstLine = line;
            }
            this.line = line;
            if (this.pendingMethod != null) {
                LineNumbers.this.lines.put(this.pendingMethod, line);
                this.pendingMethod = null;
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 181 && this.name.equals(owner) && !LineNumbers.this.lines.containsKey(name) && this.line != -1) {
                LineNumbers.this.lines.put(name, this.line);
            }
        }

        public void visitEnd() {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitAttribute(Attribute attr) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        public void visitCode() {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitVarInsn(int opcode, int var) {
        }
    }
}

