/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.store;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.index.ecore.emfindex.EmfindexFactory;
import org.eclipse.emf.index.ecore.emfindex.impl.AbstractBaseDescriptorImpl;
import org.eclipse.emf.index.ecore.emfindex.impl.ContainerDescriptorImpl;
import org.eclipse.emf.index.ecore.emfindex.impl.EObjectDescriptorImpl;
import org.eclipse.emf.index.ecore.emfindex.impl.EReferenceDescriptorImpl;
import org.eclipse.emf.index.ecore.emfindex.impl.ResourceDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexUpdaterImpl
implements IndexUpdater {
    protected MemoryIndexImpl index;

    @Inject
    public IndexUpdaterImpl(MemoryIndexImpl index) {
        this.index = index;
    }

    public void createContainer(String containerName, Map<String, String> userData) {
        this.assertNotNull(containerName);
        ContainerDescriptorImpl containerDescriptor = this.internalCreateOrUpdateContainer(containerName);
        this.updateUserData(containerDescriptor, userData);
    }

    private void assertNotNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public void deleteContainer(String containerName) {
        String normalizedContainerName = this.normalizeContainerName(containerName);
        ContainerDescriptorImpl containerDescriptor = this.findContainerDescriptor(normalizedContainerName);
        if (containerDescriptor != null) {
            this.remove((Object)containerDescriptor);
        }
    }

    public void createOrUpdateResource(String containerName, URI resourceURI, long version, Map<String, String> userData) {
        this.assertNotNull(resourceURI);
        ResourceDescriptorImpl resourceDescriptor = this.internalCreateOrUpdateResource(containerName, resourceURI, version);
        resourceDescriptor.getEObjectDescriptors().clear();
        resourceDescriptor.getEReferenceDescriptors().clear();
        this.updateUserData(resourceDescriptor, userData);
    }

    public void deleteResource(URI resourceURI) {
        this.assertNotNull(resourceURI);
        ResourceDescriptorImpl resourceDescriptor = this.findResourceDescriptor(resourceURI);
        this.remove((Object)resourceDescriptor);
    }

    public void createOrUpdateEObject(URI resourceURI, String fragment, String name, EClass type, Map<String, String> userData) {
        this.assertNotNull(resourceURI);
        this.assertNotNull(fragment);
        this.assertNotNull(name);
        EObjectDescriptorImpl eObjectDescriptor = this.internalCreateOrUpdateEObject(resourceURI, fragment, name, type);
        this.updateUserData(eObjectDescriptor, userData);
    }

    public void deleteEObject(URI resourceURI, String fragment) {
        EObjectDescriptorImpl eObjectDescriptor;
        this.assertNotNull(resourceURI);
        this.assertNotNull(fragment);
        ResourceDescriptorImpl resourceDescriptor = this.findResourceDescriptor(resourceURI);
        if (resourceDescriptor != null && (eObjectDescriptor = this.findEObjectDescriptor(resourceDescriptor, fragment)) != null) {
            this.remove((Object)eObjectDescriptor);
        }
    }

    public void createOrUpdateEReference(URI sourceResourceURI, String sourceFragment, URI targetEObjectURI, EReference reference, Map<String, String> userData) {
        this.assertNotNull(sourceResourceURI);
        this.assertNotNull(sourceFragment);
        this.assertNotNull(targetEObjectURI);
        this.assertNotNull(reference);
        EReferenceDescriptorImpl eReferenceDescriptor = this.internalCreateOrUpdateEReference(sourceResourceURI, sourceFragment, targetEObjectURI, reference);
        this.updateUserData(eReferenceDescriptor, userData);
    }

    public void deleteEReference(URI sourceResourceURI, String sourceFragment, URI targetEObjectURI, EReference reference) {
        EReferenceDescriptorImpl eReferenceDescriptor;
        this.assertNotNull(sourceResourceURI);
        this.assertNotNull(sourceFragment);
        this.assertNotNull(targetEObjectURI);
        this.assertNotNull(reference);
        ResourceDescriptorImpl sourceResourceDescriptor = this.findResourceDescriptor(sourceResourceURI);
        if (sourceResourceDescriptor != null && (eReferenceDescriptor = this.findEReferenceDescriptor(sourceResourceDescriptor, sourceFragment, targetEObjectURI, reference)) != null) {
            this.remove((Object)eReferenceDescriptor);
        }
    }

    private String normalizeContainerName(String containerName) {
        String realContainerName = containerName != null ? containerName : "EMFINDEX_DEFAULT_CONTAINER";
        return realContainerName;
    }

    private ContainerDescriptorImpl internalCreateOrUpdateContainer(String containerName) {
        String realContainerName = this.normalizeContainerName(containerName);
        ContainerDescriptorImpl exisitingContainerDescriptor = this.findContainerDescriptor(realContainerName);
        if (exisitingContainerDescriptor != null) {
            return exisitingContainerDescriptor;
        }
        ContainerDescriptorImpl newContainerDescriptor = (ContainerDescriptorImpl)EmfindexFactory.eINSTANCE.createContainerDescriptor();
        newContainerDescriptor.setName(realContainerName);
        this.index.createResource().getContents().add((Object)newContainerDescriptor);
        return newContainerDescriptor;
    }

    private ResourceDescriptorImpl internalCreateOrUpdateResource(String containerName, URI resourceURI, long version) {
        ContainerDescriptor existingContainerDescriptor;
        ResourceDescriptorImpl resourceDescriptor = this.findResourceDescriptor(resourceURI);
        if (resourceDescriptor == null) {
            resourceDescriptor = (ResourceDescriptorImpl)EmfindexFactory.eINSTANCE.createResourceDescriptor();
            resourceDescriptor.setURI(resourceURI);
            resourceDescriptor.setIndexedVersion(version);
        }
        if ((existingContainerDescriptor = resourceDescriptor.getContainer()) == null || containerName != null) {
            ContainerDescriptorImpl newContainerDescriptor = this.internalCreateOrUpdateContainer(containerName);
            resourceDescriptor.setContainer(newContainerDescriptor);
        }
        return resourceDescriptor;
    }

    private EObjectDescriptorImpl internalCreateOrUpdateEObject(URI resourceURI, String fragment, String name, EClass type) {
        ResourceDescriptorImpl resourceDescriptor = this.internalCreateOrUpdateResource(null, resourceURI, 0L);
        EObjectDescriptorImpl existingEObjectDescriptor = this.findEObjectDescriptor(resourceDescriptor, fragment);
        if (existingEObjectDescriptor != null) {
            existingEObjectDescriptor.setName(name);
            existingEObjectDescriptor.setEClass(type);
            return existingEObjectDescriptor;
        }
        EObjectDescriptorImpl eObjectDescriptor = (EObjectDescriptorImpl)EmfindexFactory.eINSTANCE.createEObjectDescriptor();
        eObjectDescriptor.setName(name);
        eObjectDescriptor.setFragment(fragment);
        eObjectDescriptor.setResourceDescriptor(resourceDescriptor);
        eObjectDescriptor.setEClass(type);
        EObjectDescriptorImpl newEObjectDescriptor = eObjectDescriptor;
        return newEObjectDescriptor;
    }

    private EReferenceDescriptorImpl internalCreateOrUpdateEReference(URI sourceResourceURI, String sourceFragment, URI targetEObjectURI, EReference reference) {
        ResourceDescriptorImpl sourceResourceDescriptor = this.internalCreateOrUpdateResource(null, sourceResourceURI, 0L);
        EReferenceDescriptorImpl existingEReferenceDescriptor = this.findEReferenceDescriptor(sourceResourceDescriptor, sourceFragment, targetEObjectURI, reference);
        if (existingEReferenceDescriptor != null) {
            return existingEReferenceDescriptor;
        }
        EReferenceDescriptorImpl eReferenceDescriptor = (EReferenceDescriptorImpl)EmfindexFactory.eINSTANCE.createEReferenceDescriptor();
        eReferenceDescriptor.setSourceFragment(sourceFragment);
        eReferenceDescriptor.setTargetFragment(targetEObjectURI.fragment());
        eReferenceDescriptor.setTargetResourceURI(targetEObjectURI.trimFragment());
        eReferenceDescriptor.setEReference(reference);
        eReferenceDescriptor.setSourceResourceDescriptor(sourceResourceDescriptor);
        EReferenceDescriptorImpl newEReferenceDescriptor = eReferenceDescriptor;
        return newEReferenceDescriptor;
    }

    private ContainerDescriptorImpl findContainerDescriptor(final String containerName) {
        Iterator filter = Iterators.filter(this.index.allContainerDescriptors(), (Predicate)new Predicate<ContainerDescriptor>(){

            public boolean apply(ContainerDescriptor containerDescriptor) {
                return containerName.equals(containerDescriptor.getName());
            }
        });
        return (ContainerDescriptorImpl)(filter.hasNext() ? (ContainerDescriptor)filter.next() : null);
    }

    private ResourceDescriptorImpl findResourceDescriptor(URI resourceURI) {
        Iterator<ResourceDescriptor> descriptors = this.index.allResourceDescriptors();
        while (descriptors.hasNext()) {
            ResourceDescriptor resourceDescriptor = descriptors.next();
            if (!resourceDescriptor.getURI().equals((Object)resourceURI)) continue;
            return (ResourceDescriptorImpl)resourceDescriptor;
        }
        return null;
    }

    private EObjectDescriptorImpl findEObjectDescriptor(ResourceDescriptor resourceDescriptor, final String fragment) {
        Iterator filter = Iterators.filter(resourceDescriptor.getEObjectDescriptors().iterator(), (Predicate)new Predicate<EObjectDescriptor>(){

            public boolean apply(EObjectDescriptor eObjectDescriptor) {
                return eObjectDescriptor.equals(fragment);
            }
        });
        return (EObjectDescriptorImpl)(filter.hasNext() ? (EObjectDescriptor)filter.next() : null);
    }

    private EReferenceDescriptorImpl findEReferenceDescriptor(ResourceDescriptorImpl sourceResourceDescriptor, final String sourceFragment, final URI targetEObjectURI, final EReference reference) {
        Iterator filter = Iterators.filter((Iterator)sourceResourceDescriptor.getEReferenceDescriptors().iterator(), (Predicate)new Predicate<EReferenceDescriptor>(){

            public boolean apply(EReferenceDescriptor eReferenceDescriptor) {
                return eReferenceDescriptor.getSourceFragment().equals(sourceFragment) && eReferenceDescriptor.getTargetFragmentURI().equals((Object)targetEObjectURI) && eReferenceDescriptor.getEReference().equals(reference);
            }
        });
        return (EReferenceDescriptorImpl)(filter.hasNext() ? (EReferenceDescriptor)filter.next() : null);
    }

    private void remove(Object oldObject) {
        if (oldObject instanceof InternalEObject) {
            InternalEObject oldEObject = (InternalEObject)oldObject;
            Resource.Internal resource = ((InternalEObject)oldObject).eDirectResource();
            EcoreUtil.remove((EObject)oldEObject);
            if (resource != null) {
                if (resource.getContents().isEmpty()) {
                    this.index.deleteResource((Resource)resource);
                } else {
                    resource.setModified(true);
                }
            }
        }
    }

    private void updateUserData(AbstractBaseDescriptorImpl baseDescriptor, Map<String, String> userData) {
        baseDescriptor.unsetUserData();
        if (userData != null) {
            for (Map.Entry<String, String> userDataEntry : userData.entrySet()) {
                baseDescriptor.setUserData(userDataEntry.getKey(), userDataEntry.getValue());
            }
        }
    }
}

