/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.initializer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.eef.codegen.core.initializer.AbstractPropertiesInitializer;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;
import org.eclipse.emf.eef.codegen.extended.flow.CleanEEFEditorSources;
import org.eclipse.emf.eef.codegen.extended.flow.GenerateEEFEditorModels;
import org.eclipse.emf.eef.codegen.extended.flow.OverrideEMFEditorCode;
import org.eclipse.emf.eef.codegen.flow.ConditionalStep;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.Workflow;
import org.eclipse.emf.eef.codegen.flow.impl.AddDependency;
import org.eclipse.emf.eef.codegen.flow.impl.GenerateEEFCode;
import org.eclipse.emf.eef.codegen.flow.impl.GenerateEEFModels;
import org.eclipse.emf.eef.codegen.flow.impl.GenerateEMFEditCode;
import org.eclipse.emf.eef.codegen.flow.impl.GenerateEMFEditorCode;
import org.eclipse.emf.eef.codegen.flow.impl.GenerateEMFModelCode;
import org.eclipse.emf.eef.codegen.flow.impl.InitializeGenModel;
import org.eclipse.emf.eef.codegen.flow.impl.MergePluginXML;
import org.eclipse.emf.eef.codegen.flow.util.GenmodelHelper;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;
import org.eclipse.emf.eef.runtime.ui.EEFExtendedRuntime;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EEFEditorInitializer
extends AbstractPropertiesInitializer {
    private static final String CLEAN_EEF_EDITOR_SOURCE = "Clean EEF editor source";
    private static final String WORKFLOW_NAME = "Generate EEF Editor";
    private static final String GENERATING_THE_GENMODEL = "Generating the GenModel";
    private static final String GENERATE_EMF_MODEL_CODE = "Generate EMF Model Code";
    private static final String GENERATE_EMF_EDIT_CODE = "Generate EMF Edit Code";
    private static final String GENERATE_EMF_EDITOR_CODE = "Generate EMF Editor Code";
    private static final String GENERATE_EEF_MODELS = "Generate EEF models";
    private static final String ADDING_EEF_RUNTIME_DEPENDENCY = "Adding EEF Runtime dependency";
    private static final String GENERATE_EEF_CODE = "Generate EEF code";
    private static final String MERGING_GENERATED_PLUGIN_XML_FILES = "Merging generated plugin.xml files";
    private static final String GENERATE_EEF_EDITOR_MODELS = "Generate EEF Editor models";
    private static final String ADDING_EEF_EXTENDED_RUNTIME_DEPENDENCY = "Adding EEF Extended Runtime dependency";
    private static final String GENERATE_EEF_EDITOR_CODE = "Generate EEF Editor code";
    private ResourceSet resourceSet;
    private IFile modelFile;
    private IWorkbenchPartSite activeSite;

    public EEFEditorInitializer(IFile selectedFile, IWorkbenchPartSite activeSite) {
        this.modelFile = selectedFile;
        this.activeSite = activeSite;
    }

    public void initialize(URI modelURI, IContainer targetFolder) throws Exception {
        this.resourceSet = new ResourceSetImpl();
        this.registerResourceFactories(this.resourceSet);
        this.registerPackages(this.resourceSet);
        EObject model = EMFHelper.load((URI)modelURI, (ResourceSet)this.resourceSet);
        if (model instanceof EPackage) {
            final Workflow workflow = new Workflow(WORKFLOW_NAME, this.activeSite.getShell());
            workflow.setResourceSet(this.resourceSet);
            final GenmodelHelper helper = new GenmodelHelper(this.resourceSet, this.modelFile, targetFolder);
            CleanEEFEditorSources cleanEEFEditorSources = new CleanEEFEditorSources(CLEAN_EEF_EDITOR_SOURCE, this.modelFile, targetFolder);
            ConditionalStep conditon = new ConditionalStep((Step)cleanEEFEditorSources){

                public boolean condition() {
                    return helper.getGenModelFile().isAccessible();
                }
            };
            workflow.addStep(CLEAN_EEF_EDITOR_SOURCE, (Step)conditon);
            InitializeGenModel initializeGenModelStep = new InitializeGenModel(GENERATING_THE_GENMODEL, this.modelFile, targetFolder, helper.genmodelFileName()){

                public boolean validateExecution() {
                    boolean genmodelExists = helper.getGenModelFile().exists();
                    if (genmodelExists) {
                        try {
                            ((WorkflowVariable)this.getGenModelURI()).setValue((Object)helper.genmodelURI());
                            ((WorkflowVariable)this.genmodel()).setValue((Object)EMFHelper.load((URI)helper.genmodelURI(), (ResourceSet)this.resourceSet));
                        }
                        catch (IOException e) {
                            EEFExtendedRuntime.INSTANCE.log((Object)e);
                            return true;
                        }
                    }
                    return !genmodelExists;
                }

                public void configureGenModel(GenModel genModel) {
                    genModel.setModelDirectory(String.valueOf(genModel.getModelDirectory()) + "-gen");
                    genModel.setEditDirectory(String.valueOf(genModel.getEditDirectory()) + "-gen");
                    genModel.setEditorDirectory(String.valueOf(genModel.getEditorDirectory()) + "-gen");
                }
            };
            workflow.addStep(GENERATING_THE_GENMODEL, (Step)initializeGenModelStep);
            GenerateEMFModelCode generateEMFModelCode = new GenerateEMFModelCode(GENERATE_EMF_MODEL_CODE, initializeGenModelStep.genmodel());
            workflow.addStep(GENERATE_EMF_MODEL_CODE, (Step)generateEMFModelCode);
            GenerateEMFEditCode generateEMFEditCode = new GenerateEMFEditCode(GENERATE_EMF_EDIT_CODE, initializeGenModelStep.genmodel());
            workflow.addStep(GENERATE_EMF_EDIT_CODE, (Step)generateEMFEditCode);
            GenerateEMFEditorCode generateEMFEditorCode = new GenerateEMFEditorCode(GENERATE_EMF_EDITOR_CODE, initializeGenModelStep.genmodel());
            workflow.addStep(GENERATE_EMF_EDITOR_CODE, (Step)generateEMFEditorCode);
            GenerateEEFModels generateEEFModels = new GenerateEEFModels(GENERATE_EEF_MODELS, modelURI, generateEMFEditCode.genProject(), initializeGenModelStep.getGenModelURI(), helper.eefmodelsFolderPath()){

                public boolean validateExecution() {
                    boolean modelsExist;
                    boolean bl = modelsExist = helper.getEEFPropertiesComponentsModel().exists() && helper.getEEFPropertiesEEFGenModel().exists();
                    if (modelsExist) {
                        try {
                            ((WorkflowVariable)this.getEEFModelsFolder()).setValue((Object)helper.getEEFModelsFolder());
                            ((WorkflowVariable)this.getEEFGenModel()).setValue((Object)EMFHelper.load((URI)GenmodelHelper.computePropertiesEEFGenModelURI((IContainer)helper.getEEFModelsFolder(), (URI)helper.genmodelURI()), (ResourceSet)this.resourceSet));
                        }
                        catch (IOException e) {
                            EEFExtendedRuntime.INSTANCE.log((Object)e);
                            return true;
                        }
                    }
                    return !modelsExist;
                }
            };
            workflow.addStep(GENERATE_EEF_MODELS, (Step)generateEEFModels);
            AddDependency addDependency = new AddDependency(ADDING_EEF_RUNTIME_DEPENDENCY, generateEMFEditCode.genProject(), "org.eclipse.emf.eef.runtime");
            workflow.addStep(ADDING_EEF_RUNTIME_DEPENDENCY, (Step)addDependency);
            GenerateEEFCode generateEEFCode = new GenerateEEFCode(GENERATE_EEF_CODE, generateEEFModels.getEEFGenModel());
            workflow.addStep(GENERATE_EEF_CODE, (Step)generateEEFCode);
            MergePluginXML mergePluginXML = new MergePluginXML(MERGING_GENERATED_PLUGIN_XML_FILES, generateEMFEditCode.genProject());
            workflow.addStep(MERGING_GENERATED_PLUGIN_XML_FILES, (Step)mergePluginXML);
            GenerateEEFEditorModels generateEEFEditorModels = new GenerateEEFEditorModels(GENERATE_EEF_EDITOR_MODELS, modelURI, generateEMFEditCode.genProject(), initializeGenModelStep.getGenModelURI(), generateEEFModels.getEEFModelsFolder()){

                public boolean validateExecution() {
                    boolean modelsExist;
                    boolean bl = modelsExist = helper.getEEFEditorComponentsModel().exists() && helper.getEEFEditorEEFGenModel().exists();
                    if (modelsExist) {
                        try {
                            ((WorkflowVariable)this.getEEFGenModel()).setValue((Object)EMFHelper.load((URI)GenmodelHelper.computeEditorEEFGenModelURI((IContainer)helper.getEEFModelsFolder(), (URI)helper.genmodelURI()), (ResourceSet)this.resourceSet));
                        }
                        catch (IOException e) {
                            EEFExtendedRuntime.INSTANCE.log((Object)e);
                            return true;
                        }
                    }
                    return !modelsExist;
                }
            };
            workflow.addStep(GENERATE_EEF_EDITOR_MODELS, (Step)generateEEFEditorModels);
            AddDependency addExtendedRuntimeDependency = new AddDependency(ADDING_EEF_EXTENDED_RUNTIME_DEPENDENCY, generateEMFEditorCode.genProject(), "org.eclipse.emf.eef.runtime.extended");
            workflow.addStep(ADDING_EEF_EXTENDED_RUNTIME_DEPENDENCY, (Step)addExtendedRuntimeDependency);
            OverrideEMFEditorCode generateEEFEditorCode = new OverrideEMFEditorCode(GENERATE_EEF_EDITOR_CODE, generateEEFEditorModels.getEEFGenModel());
            workflow.addStep(GENERATE_EEF_EDITOR_CODE, (Step)generateEEFEditorCode);
            if (workflow.prepare()) {
                WorkspaceModifyOperation runnable = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        workflow.execute(monitor);
                    }
                };
                new ProgressMonitorDialog(new Shell()).run(true, true, (IRunnableWithProgress)runnable);
            }
        }
    }
}

