/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal.failover;

import java.text.MessageFormat;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.failover.NOOPFailOverStrategy;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryFailOverStrategy
extends NOOPFailOverStrategy {
    public static final int RETRY_FOREVER = -1;
    private int retries;

    public RetryFailOverStrategy(IConnector connector, int retries) {
        super(connector);
        this.retries = retries;
    }

    public RetryFailOverStrategy(IConnector connector) {
        this(connector, -1);
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isRetryingForever() {
        return this.retries < 0;
    }

    @Override
    public void handleFailOver(ISignalProtocol<?> protocol, Exception reason) {
        Exception exception = null;
        int max = this.isRetryingForever() ? Integer.MAX_VALUE : this.retries;
        int i = 0;
        while (i < max) {
            try {
                this.handleOpen(protocol);
                return;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                exception = ex;
                ++i;
            }
        }
        if (exception != null) {
            throw WrappedException.wrap(exception);
        }
    }

    @Override
    public String toString() {
        String arg = this.isRetryingForever() ? "forever" : Integer.valueOf(this.retries);
        return MessageFormat.format("RetryFailOverStrategy[retries={0}]", arg);
    }
}

