/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.EMFOperationCommand;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.impl.WorkspaceCommandStackImpl;
import org.eclipse.emf.workspace.internal.EMFWorkspacePlugin;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultNameTrigger;
import org.eclipse.emf.workspace.tests.fixtures.LogCapture;
import org.eclipse.emf.workspace.tests.fixtures.NullCommand;
import org.eclipse.emf.workspace.tests.fixtures.SelfOpeningEMFCompositeOperation;

public class WorkbenchCommandStackTest
extends AbstractTest {
    private IUndoContext defaultContext;

    public WorkbenchCommandStackTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(WorkbenchCommandStackTest.class, "Command Stack Tests");
    }

    public void test_execute() {
        NullCommand cmd = new NullCommand();
        this.getCommandStack().execute((Command)cmd);
        IUndoableOperation[] operations = this.history.getUndoHistory(this.defaultContext);
        WorkbenchCommandStackTest.assertNotNull((Object)operations);
        WorkbenchCommandStackTest.assertEquals((int)1, (int)operations.length);
        IUndoableOperation operation = operations[0];
        WorkbenchCommandStackTest.assertTrue((boolean)(operation instanceof EMFCommandOperation));
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)((EMFCommandOperation)operation).getCommand());
    }

    public void test_undo_redo() {
        NullCommand cmd = new NullCommand();
        this.getCommandStack().execute((Command)cmd);
        Command undo = this.getCommandStack().getUndoCommand();
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)undo);
        Command redo = this.getCommandStack().getRedoCommand();
        WorkbenchCommandStackTest.assertNull((Object)redo);
        this.getCommandStack().undo();
        undo = this.getCommandStack().getUndoCommand();
        WorkbenchCommandStackTest.assertNull((Object)undo);
        redo = this.getCommandStack().getRedoCommand();
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)redo);
        this.getCommandStack().redo();
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)this.getCommandStack().getUndoCommand());
    }

    public void test_mostRecentCommand() {
        NullCommand cmd = new NullCommand();
        this.getCommandStack().execute((Command)new NullCommand());
        this.getCommandStack().execute((Command)cmd);
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().execute((Command)new NullCommand());
        WorkbenchCommandStackTest.assertNotSame((Object)((Object)cmd), (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().undo();
        WorkbenchCommandStackTest.assertNotSame((Object)((Object)cmd), (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().undo();
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        WorkbenchCommandStackTest.assertNotSame((Object)((Object)cmd), (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().redo();
        WorkbenchCommandStackTest.assertSame((Object)((Object)cmd), (Object)this.getCommandStack().getMostRecentCommand());
    }

    public void test_flush() {
        this.getCommandStack().execute((Command)new NullCommand());
        this.getCommandStack().execute((Command)new NullCommand());
        IUndoableOperation[] operations = this.history.getUndoHistory(this.defaultContext);
        WorkbenchCommandStackTest.assertNotNull((Object)operations);
        WorkbenchCommandStackTest.assertEquals((int)2, (int)operations.length);
        this.getCommandStack().flush();
        operations = this.history.getUndoHistory(this.defaultContext);
        WorkbenchCommandStackTest.assertNotNull((Object)operations);
        WorkbenchCommandStackTest.assertEquals((int)0, (int)operations.length);
    }

    public void test_flushingOnResourceUnload() {
        SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getLibrary_Name(), (Object)"foo");
        this.getCommandStack().execute((Command)cmd);
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        IUndoableOperation[] operations = this.history.getUndoHistory((IUndoContext)resctx);
        WorkbenchCommandStackTest.assertNotNull((Object)operations);
        WorkbenchCommandStackTest.assertEquals((int)1, (int)operations.length);
        IUndoableOperation operation = operations[0];
        IUndoContext[] contexts = operation.getContexts();
        WorkbenchCommandStackTest.assertEquals((int)2, (int)contexts.length);
        WorkbenchCommandStackTest.assertTrue((resctx.matches(contexts[0]) && this.defaultContext.matches(contexts[1]) || resctx.matches(contexts[1]) && this.defaultContext.matches(contexts[0]) ? 1 : 0) != 0);
        this.testResource.unload();
        operations = this.history.getUndoHistory((IUndoContext)resctx);
        WorkbenchCommandStackTest.assertNotNull((Object)operations);
        WorkbenchCommandStackTest.assertEquals((int)0, (int)operations.length);
    }

    public void testUndoContextPropagationFromTriggerListeners() {
        TransactionalEditingDomain domain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        UndoContext undoContext = new UndoContext();
        domain.addResourceSetListener((ResourceSetListener)new ResourceSetListenerImpl((IUndoContext)undoContext, domain){
            private final /* synthetic */ IUndoContext val$undoContext;
            private final /* synthetic */ TransactionalEditingDomain val$domain;
            {
                this.val$undoContext = iUndoContext;
                this.val$domain = transactionalEditingDomain;
            }

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                AbstractOperation op = new AbstractOperation(""){

                    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        return Status.OK_STATUS;
                    }

                    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        return Status.OK_STATUS;
                    }

                    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        return Status.OK_STATUS;
                    }
                };
                op.addContext(this.val$undoContext);
                return new EMFOperationCommand(this.val$domain, (IUndoableOperation)op);
            }
        });
        final Resource r = domain.getResourceSet().createResource(URI.createURI((String)"file://foo.xml"));
        ResourceUndoContext resCtx = new ResourceUndoContext(domain, r);
        AbstractEMFOperation op = new AbstractEMFOperation(domain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                r.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                return Status.OK_STATUS;
            }
        };
        WorkbenchCommandStackTest.assertTrue((op.getContexts().length == 0 ? 1 : 0) != 0);
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            WorkbenchCommandStackTest.fail();
        }
        WorkbenchCommandStackTest.assertNotNull((Object)op.getContexts());
        List<IUndoContext> opContexts = Arrays.asList(op.getContexts());
        WorkbenchCommandStackTest.assertTrue((boolean)opContexts.contains(resCtx));
        WorkbenchCommandStackTest.assertTrue((boolean)opContexts.contains(undoContext));
        op.removeContext((IUndoContext)undoContext);
        op.removeContext((IUndoContext)resCtx);
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)op, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            WorkbenchCommandStackTest.fail();
        }
        WorkbenchCommandStackTest.assertNotNull((Object)op.getContexts());
        opContexts = Arrays.asList(op.getContexts());
        WorkbenchCommandStackTest.assertTrue((boolean)opContexts.contains(resCtx));
        WorkbenchCommandStackTest.assertTrue((boolean)opContexts.contains(undoContext));
        op.removeContext((IUndoContext)undoContext);
        op.removeContext((IUndoContext)resCtx);
    }

    public void testSaveIsDoneAPIs() {
        TransactionalEditingDomain domain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        final Resource r = domain.getResourceSet().createResource(URI.createURI((String)"file://foo.xml"));
        RecordingCommand op = new RecordingCommand(domain){

            protected void doExecute() {
                r.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        };
        BasicCommandStack stack = (BasicCommandStack)domain.getCommandStack();
        OperationHistoryFactory.getOperationHistory().setLimit(((WorkspaceCommandStackImpl)stack).getDefaultUndoContext(), 0);
        OperationHistoryFactory.getOperationHistory().setLimit(((WorkspaceCommandStackImpl)stack).getDefaultUndoContext(), 20);
        stack.saveIsDone();
        WorkbenchCommandStackTest.assertFalse((boolean)stack.isSaveNeeded());
        stack.execute((Command)op);
        WorkbenchCommandStackTest.assertTrue((boolean)stack.isSaveNeeded());
        stack.undo();
        WorkbenchCommandStackTest.assertFalse((boolean)stack.isSaveNeeded());
        stack.redo();
        WorkbenchCommandStackTest.assertTrue((boolean)stack.isSaveNeeded());
        stack.saveIsDone();
        WorkbenchCommandStackTest.assertFalse((boolean)stack.isSaveNeeded());
        stack.execute((Command)op);
        WorkbenchCommandStackTest.assertTrue((boolean)stack.isSaveNeeded());
    }

    public void test_isSaveNeeded_214325() {
        TransactionalEditingDomain domain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        final Resource r = domain.getResourceSet().createResource(URI.createURI((String)"file://foo.xml"));
        RecordingCommand op = new RecordingCommand(domain){

            protected void doExecute() {
                r.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        };
        BasicCommandStack stack = (BasicCommandStack)domain.getCommandStack();
        OperationHistoryFactory.getOperationHistory().setLimit(((WorkspaceCommandStackImpl)stack).getDefaultUndoContext(), 0);
        OperationHistoryFactory.getOperationHistory().setLimit(((WorkspaceCommandStackImpl)stack).getDefaultUndoContext(), 20);
        WorkbenchCommandStackTest.assertFalse((boolean)stack.isSaveNeeded());
        stack.execute((Command)op);
        WorkbenchCommandStackTest.assertTrue((boolean)stack.isSaveNeeded());
        stack.saveIsDone();
        WorkbenchCommandStackTest.assertFalse((boolean)stack.isSaveNeeded());
        stack.undo();
        WorkbenchCommandStackTest.assertTrue((boolean)stack.isSaveNeeded());
    }

    public void test_triggerRollback_146853() {
        final RuntimeException error = new RuntimeException();
        TriggerListener testListener = new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new RecordingCommand(domain, "Error"){

                    protected void doExecute() {
                        throw error;
                    }
                };
            }
        };
        LogCapture logCapture = new LogCapture(this.getCommandStack(), EMFWorkspacePlugin.getPlugin().getBundle());
        try {
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                protected void doExecute() {
                    WorkbenchCommandStackTest.this.root.getWriters().clear();
                    WorkbenchCommandStackTest.this.root.getStock().clear();
                    WorkbenchCommandStackTest.this.root.getBranches().clear();
                }
            });
            logCapture.assertLogged(error);
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getWriters().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getStock().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getBranches().isEmpty());
        }
        finally {
            logCapture.stop();
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_triggerRollback_cancel_146853() {
        OperationCanceledException error = new OperationCanceledException();
        TriggerListener testListener = new TriggerListener((RuntimeException)error){
            private final /* synthetic */ RuntimeException val$error;
            {
                this.val$error = runtimeException;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new RecordingCommand(domain, "Error"){

                    protected void doExecute() {
                        throw val$error;
                    }
                };
            }
        };
        LogCapture logCapture = new LogCapture(this.getCommandStack(), EMFWorkspacePlugin.getPlugin().getBundle());
        try {
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                protected void doExecute() {
                    WorkbenchCommandStackTest.this.root.getWriters().clear();
                    WorkbenchCommandStackTest.this.root.getStock().clear();
                    WorkbenchCommandStackTest.this.root.getBranches().clear();
                }
            });
            IStatus log = logCapture.getLastLog();
            WorkbenchCommandStackTest.assertNull((Object)log);
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getWriters().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getStock().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getBranches().isEmpty());
        }
        finally {
            logCapture.stop();
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_triggerRollback_operation_146853() {
        final RuntimeException error = new RuntimeException();
        TriggerListener testListener = new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new RecordingCommand(domain, "Error"){

                    protected void doExecute() {
                        throw error;
                    }
                };
            }
        };
        try {
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            try {
                IStatus status = new AbstractEMFOperation(this.domain, "test"){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        WorkbenchCommandStackTest.this.root.getWriters().clear();
                        WorkbenchCommandStackTest.this.root.getStock().clear();
                        WorkbenchCommandStackTest.this.root.getBranches().clear();
                        return Status.OK_STATUS;
                    }
                }.execute(null, null);
                WorkbenchCommandStackTest.assertEquals((int)4, (int)status.getSeverity());
            }
            catch (ExecutionException e) {
                WorkbenchCommandStackTest.fail((String)("Execution failed: " + e.getLocalizedMessage()));
            }
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getWriters().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getStock().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getBranches().isEmpty());
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_triggerRollback_operation_cancel_146853() {
        OperationCanceledException error = new OperationCanceledException();
        TriggerListener testListener = new TriggerListener((RuntimeException)error){
            private final /* synthetic */ RuntimeException val$error;
            {
                this.val$error = runtimeException;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new RecordingCommand(domain, "Error"){

                    protected void doExecute() {
                        throw val$error;
                    }
                };
            }
        };
        try {
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            try {
                IStatus status = new AbstractEMFOperation(this.domain, "test"){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        WorkbenchCommandStackTest.this.root.getWriters().clear();
                        WorkbenchCommandStackTest.this.root.getStock().clear();
                        WorkbenchCommandStackTest.this.root.getBranches().clear();
                        return Status.OK_STATUS;
                    }
                }.execute(null, null);
                WorkbenchCommandStackTest.assertEquals((int)8, (int)status.getSeverity());
            }
            catch (ExecutionException e) {
                WorkbenchCommandStackTest.fail((String)("Execution failed: " + e.getLocalizedMessage()));
            }
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getWriters().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getStock().isEmpty());
            WorkbenchCommandStackTest.assertFalse((boolean)this.root.getBranches().isEmpty());
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_recordingCommandsAsTriggers_bug157103() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger(){

            @Override
            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                RecordingCommand result = null;
                final Library newLibrary = (Library)notification.getNewValue();
                if (newLibrary.getName() == null || newLibrary.getName().length() == 0) {
                    result = new RecordingCommand(domain){

                        protected void doExecute() {
                            newLibrary.setName("New Library");
                        }
                    };
                }
                return result;
            }
        });
        final Library[] newLibrary = new Library[1];
        UndoContext ctx = new UndoContext();
        AbstractEMFOperation operation = new AbstractEMFOperation(this.domain, "Test"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                WorkbenchCommandStackTest.this.root.getBranches().add((Object)newLibrary[0]);
                WorkbenchCommandStackTest.assertNull((Object)newLibrary[0].getName());
                return Status.OK_STATUS;
            }
        };
        operation.addContext((IUndoContext)ctx);
        try {
            this.history.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            WorkbenchCommandStackTest.fail((String)("Failed to execute test operation: " + e.getLocalizedMessage()));
        }
        this.startReading();
        WorkbenchCommandStackTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        this.commit();
        try {
            this.history.undo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            WorkbenchCommandStackTest.fail((String)("Failed to undo test operation: " + e.getLocalizedMessage()));
        }
        WorkbenchCommandStackTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        WorkbenchCommandStackTest.assertNull((Object)newLibrary[0].eResource());
        WorkbenchCommandStackTest.assertNull((Object)newLibrary[0].getName());
        try {
            this.history.redo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            WorkbenchCommandStackTest.fail((String)("Failed to redo test operation: " + e.getLocalizedMessage()));
        }
        WorkbenchCommandStackTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        WorkbenchCommandStackTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
    }

    public void test_rollbackNotifiesCommandStackListeners_175725() {
        CommandStack stack;
        class TestCSL
        implements CommandStackListener {
            int invocationCount = 0;

            TestCSL() {
            }

            public void commandStackChanged(EventObject event) {
                ++this.invocationCount;
            }
        }
        TestCSL listener;
        block5: {
            listener = new TestCSL();
            stack = this.domain.getCommandStack();
            stack.addCommandStackListener((CommandStackListener)listener);
            Book book = (Book)this.find("root/Root Book");
            WorkbenchCommandStackTest.assertNotNull((Object)book);
            Command command = SetCommand.create((EditingDomain)this.domain, (Object)book, (Object)EXTLibraryPackage.Literals.BOOK__TITLE, null);
            try {
                try {
                    validationEnabled = true;
                    stack.execute(command);
                }
                catch (Exception e) {
                    this.fail(e);
                    validationEnabled = false;
                    stack.removeCommandStackListener((CommandStackListener)listener);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                validationEnabled = false;
                stack.removeCommandStackListener((CommandStackListener)listener);
                throw throwable;
            }
            validationEnabled = false;
            stack.removeCommandStackListener((CommandStackListener)listener);
        }
        WorkbenchCommandStackTest.assertEquals((String)"Command-stack listener invoked wrong number of times", (int)1, (int)listener.invocationCount);
        WorkbenchCommandStackTest.assertFalse((String)"Should not have an undo command", (boolean)stack.canUndo());
    }

    public void test_undoRedoNotifyListeners_173839() {
        Command redoCmd;
        Command undoCmd;
        Command command;
        class TestCSL
        implements CommandStackListener {
            int invocationCount = 0;

            TestCSL() {
            }

            public void commandStackChanged(EventObject event) {
                ++this.invocationCount;
            }
        }
        TestCSL listener;
        block5: {
            listener = new TestCSL();
            CommandStack stack = this.domain.getCommandStack();
            stack.addCommandStackListener((CommandStackListener)listener);
            Book book = (Book)this.find("root/Root Book");
            WorkbenchCommandStackTest.assertNotNull((Object)book);
            command = SetCommand.create((EditingDomain)this.domain, (Object)book, (Object)EXTLibraryPackage.Literals.BOOK__TITLE, (Object)"New Title");
            undoCmd = null;
            redoCmd = null;
            try {
                try {
                    stack.execute(command);
                    listener.invocationCount = 0;
                    stack.undo();
                    redoCmd = stack.getRedoCommand();
                    stack.redo();
                    undoCmd = stack.getUndoCommand();
                }
                catch (Exception e) {
                    this.fail(e);
                    stack.removeCommandStackListener((CommandStackListener)listener);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                stack.removeCommandStackListener((CommandStackListener)listener);
                throw throwable;
            }
            stack.removeCommandStackListener((CommandStackListener)listener);
        }
        WorkbenchCommandStackTest.assertEquals((String)"Command-stack listener invoked wrong number of times", (int)2, (int)listener.invocationCount);
        WorkbenchCommandStackTest.assertSame((Object)command, (Object)undoCmd);
        WorkbenchCommandStackTest.assertSame((Object)command, (Object)redoCmd);
    }

    public void test_nestedExecutionInOpenComposite_203352() {
        SelfOpeningEMFCompositeOperation operation = new SelfOpeningEMFCompositeOperation(this.domain){

            @Override
            protected IStatus doExecute(IOperationHistory history, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return history.execute((IUndoableOperation)new AbstractEMFOperation(WorkbenchCommandStackTest.this.domain, "Test"){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        (this).WorkbenchCommandStackTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                        return Status.OK_STATUS;
                    }
                }, monitor, info);
            }
        };
        try {
            this.history.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            WorkbenchCommandStackTest.fail((String)("Failed to execute test operation: " + e.getLocalizedMessage()));
        }
        ResourceUndoContext expected = new ResourceUndoContext(this.domain, this.testResource);
        WorkbenchCommandStackTest.assertTrue((boolean)operation.hasContext((IUndoContext)expected));
    }

    public void test_nestedExecutionInAbstractOperation_244654() {
        AbstractOperation operation = new AbstractOperation("Test"){
            private AbstractEMFOperation delegate;
            {
                this.delegate = new AbstractEMFOperation(WorkbenchCommandStackTest.this.domain, "Delegate"){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        (this).WorkbenchCommandStackTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                        return Status.OK_STATUS;
                    }
                };
            }

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.delegate.execute(monitor, info);
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.delegate.redo(monitor, info);
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.delegate.undo(monitor, info);
            }
        };
        WorkbenchCommandStackTest.assertTrue((operation.getContexts().length == 0 ? 1 : 0) != 0);
        try {
            this.history.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            WorkbenchCommandStackTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        ResourceUndoContext expected = new ResourceUndoContext(this.domain, this.testResource);
        WorkbenchCommandStackTest.assertTrue((String)"Operation missing expected context", (boolean)operation.hasContext((IUndoContext)expected));
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.defaultContext = ((IWorkspaceCommandStack)this.getCommandStack()).getDefaultUndoContext();
    }

    @Override
    protected void doTearDown() throws Exception {
        this.defaultContext = null;
        super.doTearDown();
    }

    ResourceUndoContext getResourceUndoContext(IUndoableOperation operation) {
        ResourceUndoContext result = null;
        IUndoContext[] contexts = operation.getContexts();
        int i = 0;
        while (result == null && i < contexts.length) {
            if (contexts[i] instanceof ResourceUndoContext) {
                result = (ResourceUndoContext)contexts[i];
            }
            ++i;
        }
        return result;
    }
}

