/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.util.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.BookOnTape;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.Employee;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Person;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IResourceUndoContextPolicy;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.tests.fixtures.TestPackageBuilder;

public class ResourceUndoContextTest
extends TestCase {
    private ResourceUndoContext ctx1;
    private ResourceUndoContext ctx2;
    private ResourceUndoContext ctx3;
    private Resource res1;
    private Resource res2;
    private Resource res3;
    private Listener listener;
    private TestPackageBuilder packageBuilder;

    public ResourceUndoContextTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ResourceUndoContextTest.class, "Resource Undo Context Tests");
    }

    public void test_matches() {
        ResourceUndoContextTest.assertFalse((boolean)this.ctx1.matches((IUndoContext)this.ctx3));
        ResourceUndoContextTest.assertTrue((boolean)this.ctx2.matches((IUndoContext)this.ctx3));
    }

    public void test_getAffectedResources_attribute() {
        Library library = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res1.getContents().add((Object)library);
        this.listener.notifications.clear();
        library.setName("Foo");
        ResourceUndoContextTest.assertFalse((boolean)this.listener.notifications.isEmpty());
        Set affected = ResourceUndoContext.getAffectedResources(this.listener.notifications);
        ResourceUndoContextTest.assertEquals(Collections.singleton(this.res1), (Object)affected);
    }

    public void test_getAffectedResources_localRef() {
        Library library = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res1.getContents().add((Object)library);
        BookOnTape book = EXTLibraryFactory.eINSTANCE.createBookOnTape();
        library.getStock().add((Object)book);
        Employee person = EXTLibraryFactory.eINSTANCE.createEmployee();
        library.getEmployees().add((Object)person);
        this.listener.notifications.clear();
        book.setReader((Person)person);
        ResourceUndoContextTest.assertFalse((boolean)this.listener.notifications.isEmpty());
        Set affected = ResourceUndoContext.getAffectedResources(this.listener.notifications);
        ResourceUndoContextTest.assertEquals(Collections.singleton(this.res1), (Object)affected);
    }

    public void test_getAffectedResources_remoteRef_bidirectional() {
        Library library1 = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res1.getContents().add((Object)library1);
        Library library2 = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res2.getContents().add((Object)library2);
        Book book = EXTLibraryFactory.eINSTANCE.createBook();
        library1.getStock().add((Object)book);
        Writer writer = EXTLibraryFactory.eINSTANCE.createWriter();
        library2.getWriters().add((Object)writer);
        this.listener.notifications.clear();
        book.setAuthor(writer);
        ResourceUndoContextTest.assertFalse((boolean)this.listener.notifications.isEmpty());
        Set affected = ResourceUndoContext.getAffectedResources(this.listener.notifications);
        HashSet<Resource> expected = new HashSet<Resource>();
        expected.add(this.res1);
        expected.add(this.res2);
        ResourceUndoContextTest.assertEquals(expected, (Object)affected);
    }

    public void test_getAffectedResources_remoteRef_unidirectional() {
        Library library1 = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res1.getContents().add((Object)library1);
        Library library2 = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res2.getContents().add((Object)library2);
        BookOnTape book = EXTLibraryFactory.eINSTANCE.createBookOnTape();
        library1.getStock().add((Object)book);
        Employee person = EXTLibraryFactory.eINSTANCE.createEmployee();
        library2.getEmployees().add((Object)person);
        this.listener.notifications.clear();
        book.setReader((Person)person);
        ResourceUndoContextTest.assertFalse((boolean)this.listener.notifications.isEmpty());
        Set affected = ResourceUndoContext.getAffectedResources(this.listener.notifications);
        HashSet<Resource> expected = new HashSet<Resource>();
        expected.add(this.res1);
        expected.add(this.res2);
        ResourceUndoContextTest.assertEquals(expected, (Object)affected);
    }

    public void test_getAffectedResources_deletedElement_126113() {
        Library library1 = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res1.getContents().add((Object)library1);
        Library library2 = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.res2.getContents().add((Object)library2);
        BookOnTape book = EXTLibraryFactory.eINSTANCE.createBookOnTape();
        library1.getStock().add((Object)book);
        Employee person = EXTLibraryFactory.eINSTANCE.createEmployee();
        library2.getEmployees().add((Object)person);
        book.setReader((Person)person);
        this.listener.notifications.clear();
        library2.getEmployees().remove((Object)person);
        book.setReader(null);
        ResourceUndoContextTest.assertFalse((boolean)this.listener.notifications.isEmpty());
        Set affected = ResourceUndoContext.getAffectedResources(this.listener.notifications);
        HashSet<Resource> expected = new HashSet<Resource>();
        expected.add(this.res1);
        expected.add(this.res2);
        ResourceUndoContextTest.assertEquals(expected, (Object)affected);
        ResourceUndoContextTest.assertFalse((boolean)affected.contains(null));
    }

    public void test_unsettableManyReference_264220() {
        EFactory factory = this.packageBuilder.getPackage().getEFactoryInstance();
        EObject anA = factory.create(this.packageBuilder.getA());
        EObject aB = factory.create(this.packageBuilder.getB());
        EObject anotherB = factory.create(this.packageBuilder.getB());
        anA.eAdapters().add((Object)this.listener);
        this.res1.getContents().add((Object)aB);
        this.res2.getContents().add((Object)anotherB);
        EList bs = (EList)anA.eGet((EStructuralFeature)this.packageBuilder.getA_b());
        bs.add((Object)aB);
        bs.add((Object)anotherB);
        this.listener.notifications.clear();
        anA.eUnset((EStructuralFeature)this.packageBuilder.getA_b());
        try {
            HashSet<Resource> expectedResources = new HashSet<Resource>();
            expectedResources.add(this.res1);
            expectedResources.add(this.res2);
            ResourceUndoContextTest.assertEquals(expectedResources, (Object)IResourceUndoContextPolicy.DEFAULT.getContextResources(null, this.listener.notifications));
        }
        catch (ClassCastException e) {
            ResourceUndoContextTest.fail((String)"Should not get CCE in the resource undo-context policy");
        }
    }

    protected void setUp() throws Exception {
        TransactionalEditingDomain domain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain((IOperationHistory)new DefaultOperationHistory());
        this.res1 = new ResourceImpl();
        this.res2 = new ResourceImpl();
        this.res3 = new ResourceImpl();
        this.ctx1 = new ResourceUndoContext(domain, this.res1);
        this.ctx2 = new ResourceUndoContext(domain, this.res2);
        this.ctx3 = new ResourceUndoContext(domain, this.res2);
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getResources().add((Object)this.res1);
        rset.getResources().add((Object)this.res2);
        rset.getResources().add((Object)this.res3);
        this.listener = new Listener();
        rset.eAdapters().add((Object)this.listener);
        this.packageBuilder = new TestPackageBuilder();
    }

    protected void tearDown() throws Exception {
        this.packageBuilder.dispose();
        this.listener = null;
        this.res1 = null;
        this.res2 = null;
        this.res3 = null;
        this.ctx1 = null;
        this.ctx2 = null;
        this.ctx3 = null;
    }

    protected void fail(Exception e) {
        e.printStackTrace();
        ResourceUndoContextTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    private static class Listener
    extends EContentAdapter {
        final List<Notification> notifications = new ArrayList<Notification>();

        private Listener() {
        }

        public void notifyChanged(Notification notification) {
            this.notifications.add(notification);
            super.notifyChanged(notification);
        }
    }
}

