/*
 * Copyright (c) 2018, 2025 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.tests.bugzilla;

import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.IRepositoryConfig;

import java.util.Map;

/**
 * Bug 541437 - Repository UUID management seems broken.
 *
 * @author Eike Stepper
 */
public class Bugzilla_541437_Test extends AbstractCDOTest
{
  @Override
  protected void initTestProperties(Map<String, Object> properties)
  {
    super.initTestProperties(properties);
    properties.put(IRepository.Props.OVERRIDE_UUID, null);
  }

  public void testUUIDWithoutOverride() throws Exception
  {
    String oldUUID = getRepository().getUUID();
    assertNotSame(null, oldUUID);
    assertNotSame(getRepository().getName(), oldUUID);
  }

  @Requires(IRepositoryConfig.CAPABILITY_RESTARTABLE)
  public void testUUIDAfterRestart() throws Exception
  {
    String oldUUID = getRepository().getUUID();
    restartRepository();

    String newUUID = getRepository().getUUID();
    assertEquals(oldUUID, newUUID);
  }
}
