/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchVersionImpl;
import org.eclipse.net4j.util.ObjectUtil;

public class CDORevisableImpl
extends CDOBranchVersionImpl
implements CDORevisable {
    private long timeStamp;
    private long revised;

    public CDORevisableImpl(CDOBranch branch, int version, long timeStamp, long revised) {
        super(branch, version);
        this.timeStamp = timeStamp;
        this.revised = revised;
    }

    public CDORevisableImpl(CDORevisable source) {
        super(source.getBranch(), source.getVersion());
        this.timeStamp = source.getTimeStamp();
        this.revised = source.getRevised();
    }

    public CDORevisableImpl(CDOBranch branch, int version) {
        super(branch, version);
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getRevised() {
        return this.revised;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.hashCode((long)this.timeStamp) ^ ObjectUtil.hashCode((long)this.revised) ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDORevisable) {
            CDORevisable that = (CDORevisable)obj;
            return this.timeStamp == that.getTimeStamp() && this.revised == that.getRevised() && this.getBranch().equals(that.getBranch()) && this.getVersion() == that.getVersion();
        }
        return false;
    }

    @Override
    public String toString() {
        return MessageFormat.format("{0}v{1}[{2}-{3}]", this.getBranch().getID(), this.getVersion(), CDOCommonUtil.formatTimeStamp(this.timeStamp), CDOCommonUtil.formatTimeStamp(this.revised));
    }
}

