/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.MethodFactory;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.impl.store.access.CacheableConglomerate;
import org.apache.derby.impl.store.access.PropertyConglomerate;
import org.apache.derby.impl.store.access.RAMAccessUndoHandler;
import org.apache.derby.impl.store.access.RAMTransaction;
import org.apache.derby.impl.store.access.RAMTransactionContext;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class RAMAccessManager
implements AccessFactory,
CacheableFactory,
ModuleControl,
PropertySetCallback {
    private RawStoreFactory rawstore;
    private Hashtable<String, MethodFactory> implhash = new Hashtable();
    private Hashtable<UUID, MethodFactory> formathash = new Hashtable();
    private Properties serviceProperties;
    LockingPolicy system_default_locking_policy;
    private PropertyConglomerate xactProperties;
    private PropertyFactory pf;
    protected LockingPolicy[] table_level_policy;
    protected LockingPolicy[] record_level_policy;
    protected ConglomerateFactory[] conglom_map;
    private CacheManager conglom_cache;
    private long conglom_nextid = 0L;

    protected LockingPolicy getDefaultLockingPolicy() {
        return this.system_default_locking_policy;
    }

    RawStoreFactory getRawStore() {
        return this.rawstore;
    }

    PropertyConglomerate getTransactionalProperties() {
        return this.xactProperties;
    }

    private void boot_load_conglom_map() throws StandardException {
        this.conglom_map = new ConglomerateFactory[2];
        MethodFactory mfactory = this.findMethodFactoryByImpl("heap");
        if (mfactory == null || !(mfactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", "heap");
        }
        this.conglom_map[0] = (ConglomerateFactory)mfactory;
        mfactory = this.findMethodFactoryByImpl("BTREE");
        if (mfactory == null || !(mfactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", "BTREE");
        }
        this.conglom_map[1] = (ConglomerateFactory)mfactory;
    }

    protected abstract int getSystemLockLevel();

    protected abstract void bootLookupSystemLockLevel(TransactionController var1) throws StandardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextConglomId(int factory_type) throws StandardException {
        long conglomid;
        SanityManager.ASSERT(factory_type >= 0 && factory_type <= 15);
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            if (this.conglom_nextid == 0L) {
                this.conglom_nextid = (this.rawstore.getMaxContainerId() >> 4) + 1L;
            }
            conglomid = this.conglom_nextid++;
        }
        return conglomid << 4 | (long)factory_type;
    }

    ConglomerateFactory getFactoryFromConglomId(long conglom_id) throws StandardException {
        try {
            return this.conglom_map[(int)(0xFL & conglom_id)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StandardException.newException("XSAI2.S", conglom_id);
        }
    }

    private void conglomCacheInit() throws StandardException {
        CacheFactory cf = (CacheFactory)RAMAccessManager.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.conglom_cache = cf.newCacheManager(this, "ConglomerateDirectoryCache", 200, 300);
    }

    Conglomerate conglomCacheFind(long conglomid) throws StandardException {
        Conglomerate conglom = null;
        Long conglomid_obj = conglomid;
        CacheableConglomerate cache_entry = (CacheableConglomerate)this.conglom_cache.find(conglomid_obj);
        if (cache_entry != null) {
            conglom = cache_entry.getConglom();
            this.conglom_cache.release(cache_entry);
        }
        return conglom;
    }

    protected void conglomCacheInvalidate() throws StandardException {
        this.conglom_cache.ageOut();
    }

    void conglomCacheAddEntry(long conglomid, Conglomerate conglom) throws StandardException {
        CacheableConglomerate conglom_entry = (CacheableConglomerate)this.conglom_cache.create(conglomid, conglom);
        this.conglom_cache.release(conglom_entry);
    }

    void conglomCacheRemoveEntry(long conglomid) throws StandardException {
        CacheableConglomerate conglom_entry = (CacheableConglomerate)this.conglom_cache.findCached(conglomid);
        if (conglom_entry != null) {
            this.conglom_cache.remove(conglom_entry);
        }
    }

    RAMTransactionContext getCurrentTransactionContext() {
        RAMTransactionContext rtc = (RAMTransactionContext)RAMAccessManager.getContext("RAMInternalContext");
        if (rtc == null) {
            rtc = (RAMTransactionContext)RAMAccessManager.getContext("RAMChildContext");
        }
        if (rtc == null) {
            rtc = (RAMTransactionContext)RAMAccessManager.getContext("RAMTransactionContext");
        }
        return rtc;
    }

    @Override
    public void createFinished() throws StandardException {
        this.rawstore.createFinished();
    }

    @Override
    public MethodFactory findMethodFactoryByFormat(UUID format) {
        MethodFactory factory = this.formathash.get(format);
        if (factory != null) {
            return factory;
        }
        Enumeration<MethodFactory> e = this.formathash.elements();
        while (e.hasMoreElements()) {
            factory = e.nextElement();
            if (!factory.supportsFormat(format)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public MethodFactory findMethodFactoryByImpl(String impltype) throws StandardException {
        Properties conglomProperties;
        MethodFactory factory;
        block5: {
            factory = this.implhash.get(impltype);
            if (factory != null) {
                return factory;
            }
            Enumeration<MethodFactory> e = this.implhash.elements();
            while (e.hasMoreElements()) {
                factory = e.nextElement();
                if (!factory.supportsImplementation(impltype)) continue;
                return factory;
            }
            factory = null;
            conglomProperties = new Properties(this.serviceProperties);
            conglomProperties.put("derby.access.Conglomerate.type", impltype);
            try {
                factory = (MethodFactory)RAMAccessManager.bootServiceModule(false, this, "org.apache.derby.iapi.store.access.conglomerate.MethodFactory", impltype, conglomProperties);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("XBM02.D")) break block5;
                throw se;
            }
        }
        conglomProperties = null;
        if (factory != null) {
            this.registerAccessMethod(factory);
            return factory;
        }
        return null;
    }

    @Override
    public LockFactory getLockFactory() {
        return this.rawstore.getLockFactory();
    }

    @Override
    public TransactionController getTransaction(ContextManager cm) throws StandardException {
        return this.getAndNameTransaction(cm, "UserTransaction");
    }

    @Override
    public TransactionController getAndNameTransaction(ContextManager cm, String transName) throws StandardException {
        if (cm == null) {
            return null;
        }
        RAMTransactionContext rtc = (RAMTransactionContext)cm.getContext("RAMTransactionContext");
        if (rtc == null) {
            Transaction rawtran = this.rawstore.findUserTransaction(cm, transName);
            RAMTransaction rt = new RAMTransaction(this, rawtran, null);
            rtc = new RAMTransactionContext(cm, "RAMTransactionContext", rt, false);
            RAMTransaction tc = rtc.getTransaction();
            if (this.xactProperties != null) {
                rawtran.setup(tc);
                tc.commit();
            }
            rawtran.setDefaultLockingPolicy(this.system_default_locking_policy);
            tc.commit();
            return tc;
        }
        return rtc.getTransaction();
    }

    @Override
    public Object startXATransaction(ContextManager cm, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        RAMTransaction xa_tc = null;
        SanityManager.ASSERT(global_id != null);
        SanityManager.ASSERT(branch_id != null);
        if (cm == null) {
            return null;
        }
        RAMTransactionContext rtc = (RAMTransactionContext)cm.getContext("RAMTransactionContext");
        if (rtc == null) {
            Transaction rawtran = this.rawstore.startGlobalTransaction(cm, format_id, global_id, branch_id);
            xa_tc = new RAMTransaction(this, rawtran, null);
            rtc = new RAMTransactionContext(cm, "RAMTransactionContext", xa_tc, false);
            if (this.xactProperties != null) {
                rawtran.setup(xa_tc);
                xa_tc.commitNoSync(5);
            }
            rawtran.setDefaultLockingPolicy(this.system_default_locking_policy);
            xa_tc.commitNoSync(5);
        } else {
            SanityManager.THROWASSERT("RAMTransactionContext found on stack.");
        }
        return xa_tc;
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        return this.rawstore.getXAResourceManager();
    }

    @Override
    public void registerAccessMethod(MethodFactory factory) {
        this.implhash.put(factory.primaryImplementationType(), factory);
        this.formathash.put(factory.primaryFormat(), factory);
    }

    @Override
    public boolean isReadOnly() {
        return this.rawstore.isReadOnly();
    }

    @Override
    public void createReadMeFiles() throws StandardException {
        this.rawstore.createDataWarningFile();
        LogFactory logFactory = (LogFactory)RAMAccessManager.findServiceModule(this, this.rawstore.getLogFactoryModule());
        logFactory.createDataWarningFile();
        DataFactory dataFactory = (DataFactory)RAMAccessManager.findServiceModule(this, this.rawstore.getDataFactoryModule());
        PersistentService ps = RAMAccessManager.getMonitor().getServiceType(this.rawstore);
        ps.createDataWarningFile(dataFactory.getStorageFactory());
    }

    private void addPropertySetNotification(PropertySetCallback who, TransactionController tc) {
        this.pf.addPropertySetNotification(who);
        Hashtable<Object, Object> d = new Hashtable<Object, Object>();
        try {
            this.xactProperties.getProperties(tc, d, false, false);
        }
        catch (StandardException se) {
            return;
        }
        boolean dbOnly = PropertyUtil.isDBOnly(d);
        who.init(dbOnly, d);
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        return this.rawstore.getTransactionInfo();
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws StandardException {
        this.rawstore.startReplicationMaster(dbmaster, host, port, replicationMode);
    }

    @Override
    public void failover(String dbname) throws StandardException {
        this.rawstore.failover(dbname);
    }

    @Override
    public void stopReplicationMaster() throws StandardException {
        this.rawstore.stopReplicationMaster();
    }

    @Override
    public void freeze() throws StandardException {
        SecurityUtil.authorize(Securable.FREEZE_DATABASE);
        this.rawstore.freeze();
    }

    @Override
    public void unfreeze() throws StandardException {
        SecurityUtil.authorize(Securable.UNFREEZE_DATABASE);
        this.rawstore.unfreeze();
    }

    @Override
    public void backup(String backupDir, boolean wait) throws StandardException {
        SecurityUtil.authorize(wait ? Securable.BACKUP_DATABASE : Securable.BACKUP_DATABASE_NOWAIT);
        this.rawstore.backup(backupDir, wait);
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws StandardException {
        SecurityUtil.authorize(wait ? Securable.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE : Securable.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT);
        this.rawstore.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws StandardException {
        SecurityUtil.authorize(Securable.DISABLE_LOG_ARCHIVE_MODE);
        this.rawstore.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
    }

    @Override
    public void checkpoint() throws StandardException {
        SecurityUtil.authorize(Securable.CHECKPOINT_DATABASE);
        this.rawstore.checkpoint();
    }

    @Override
    public void waitForPostCommitToFinishWork() {
        this.rawstore.getDaemon().waitUntilQueueIsEmpty();
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.serviceProperties = startParams;
        this.boot_load_conglom_map();
        if (create) {
            this.conglom_nextid = 1L;
        }
        this.rawstore = (RawStoreFactory)RAMAccessManager.bootServiceModule(create, this, "org.apache.derby.iapi.store.raw.RawStoreFactory", this.serviceProperties);
        this.rawstore.setUndoInsertEventHandler(new RAMAccessUndoHandler(this));
        RAMAccessManager.bootServiceModule(create, this, "org.apache.derby.iapi.services.property.PropertyFactory", startParams);
        this.conglomCacheInit();
        RAMTransaction tc = (RAMTransaction)this.getAndNameTransaction(RAMAccessManager.getContextService().getCurrentContextManager(), "UserTransaction");
        int lock_mode = 2;
        this.system_default_locking_policy = tc.getRawStoreXact().newLockingPolicy(lock_mode, 5, true);
        this.table_level_policy = new LockingPolicy[6];
        this.table_level_policy[0] = tc.getRawStoreXact().newLockingPolicy(2, 0, true);
        this.table_level_policy[1] = tc.getRawStoreXact().newLockingPolicy(2, 1, true);
        this.table_level_policy[2] = tc.getRawStoreXact().newLockingPolicy(2, 2, true);
        this.table_level_policy[3] = tc.getRawStoreXact().newLockingPolicy(2, 3, true);
        this.table_level_policy[4] = tc.getRawStoreXact().newLockingPolicy(2, 4, true);
        this.table_level_policy[5] = tc.getRawStoreXact().newLockingPolicy(2, 5, true);
        this.record_level_policy = new LockingPolicy[6];
        this.record_level_policy[0] = tc.getRawStoreXact().newLockingPolicy(1, 0, true);
        this.record_level_policy[1] = tc.getRawStoreXact().newLockingPolicy(1, 1, true);
        this.record_level_policy[2] = tc.getRawStoreXact().newLockingPolicy(1, 2, true);
        this.record_level_policy[3] = tc.getRawStoreXact().newLockingPolicy(1, 3, true);
        this.record_level_policy[4] = tc.getRawStoreXact().newLockingPolicy(1, 4, true);
        this.record_level_policy[5] = tc.getRawStoreXact().newLockingPolicy(1, 5, true);
        for (int i = 0; i < 5; ++i) {
            SanityManager.ASSERT(this.table_level_policy[i] != null, "table_level_policy[" + i + "] is null");
            SanityManager.ASSERT(this.record_level_policy[i] != null, "record_level_policy[" + i + "] is null");
        }
        tc.commit();
        this.pf = (PropertyFactory)RAMAccessManager.findServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        this.xactProperties = new PropertyConglomerate(tc, create, startParams, this.pf);
        if (create) {
            this.rawstore.createDataWarningFile();
        }
        this.rawstore.getRawStoreProperties(tc);
        this.bootLookupSystemLockLevel(tc);
        lock_mode = this.getSystemLockLevel() == 7 ? 2 : 1;
        this.system_default_locking_policy = tc.getRawStoreXact().newLockingPolicy(lock_mode, 5, true);
        this.addPropertySetNotification(this.getLockFactory(), tc);
        this.addPropertySetNotification(this, tc);
        tc.commit();
        tc.destroy();
        tc = null;
        SanityManager.ASSERT(true);
        SanityManager.ASSERT(true);
        SanityManager.ASSERT(true);
        SanityManager.ASSERT(true);
        SanityManager.ASSERT(true);
    }

    @Override
    public void stop() {
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("encryptionAlgorithm")) {
            throw StandardException.newException("XBCXD.S", new Object[0]);
        }
        if (key.equals("encryptionProvider")) {
            throw StandardException.newException("XBCXE.S", new Object[0]);
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) throws StandardException {
        return null;
    }

    @Override
    public Cacheable newCacheable(CacheManager cm) {
        return new CacheableConglomerate(this);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object startSystemModule(String factoryInterface) throws StandardException {
        return Monitor.startSystemModule(factoryInterface);
    }

    private static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, Properties properties) throws StandardException {
        return Monitor.bootServiceModule(create, serviceModule, factoryInterface, properties);
    }

    private static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, String identifier, Properties properties) throws StandardException {
        return Monitor.bootServiceModule(create, serviceModule, factoryInterface, identifier, properties);
    }

    private static Object findServiceModule(Object serviceModule, String factoryInterface) throws StandardException {
        return Monitor.findServiceModule(serviceModule, factoryInterface);
    }
}

