/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.util.Properties;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.impl.jdbc.authentication.LDAPAuthenticationSchemeImpl;
import org.apache.derby.shared.common.error.StandardException;

public class JNDIAuthenticationService
extends AuthenticationServiceBase {
    private String authenticationProvider;

    @Override
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        this.authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return this.authenticationProvider != null && StringUtil.SQLEqualsIgnoreCase(this.authenticationProvider, "LDAP");
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        super.boot(create, properties);
        LDAPAuthenticationSchemeImpl aJNDIAuthscheme = new LDAPAuthenticationSchemeImpl(this, properties);
        this.setAuthenticationService(aJNDIAuthscheme);
    }
}

