/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class DropSequenceConstantAction
extends DDLConstantAction {
    private final String sequenceName;
    private final SchemaDescriptor schemaDescriptor;

    DropSequenceConstantAction(SchemaDescriptor sd, String sequenceName) {
        this.sequenceName = sequenceName;
        this.schemaDescriptor = sd;
    }

    public String toString() {
        return "DROP SEQUENCE " + this.sequenceName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        dd.clearSequenceCaches();
        SequenceDescriptor sequenceDescriptor = dd.getSequenceDescriptor(this.schemaDescriptor, this.sequenceName);
        if (sequenceDescriptor == null) {
            throw StandardException.newException("X0X81.S", "SEQUENCE", this.schemaDescriptor.getObjectName() + "." + this.sequenceName);
        }
        sequenceDescriptor.drop(lcc);
    }
}

