/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.tests.db.DBConfig;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;

public abstract class AbstractSetupDBConfig
extends DBConfig {
    private static final long serialVersionUID = 1L;
    private transient DataSource setupDataSource;

    public AbstractSetupDBConfig(String name) {
        super(name);
    }

    protected String getDBName(String repoName) {
        return "test_" + repoName;
    }

    @Override
    protected DataSource createDataSource(String repoName) {
        String dbName = this.getDBName(repoName);
        if (!this.isRestarting()) {
            this.initDatabase(dbName);
        }
        try {
            return this.createDataSourceForDB(dbName);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void initDatabase(String dbName) {
        block5: {
            this.dropDatabase(dbName);
            Connection connection = null;
            Statement stmt = null;
            try {
                try {
                    connection = this.getSetupConnection();
                    stmt = connection.createStatement();
                    this.initDatabase(connection, stmt, dbName);
                }
                catch (SQLException sQLException) {
                    DBUtil.close(stmt);
                    DBUtil.close((Connection)connection);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
            DBUtil.close((Statement)stmt);
            DBUtil.close((Connection)connection);
        }
    }

    protected void initDatabase(Connection connection, Statement stmt, String dbName) throws SQLException {
        stmt.execute("CREATE DATABASE " + dbName);
    }

    protected void dropDatabase(String dbName) {
        block6: {
            Connection connection = null;
            Statement stmt = null;
            try {
                try {
                    connection = this.getSetupConnection();
                    stmt = connection.createStatement();
                    this.dropDatabase(connection, stmt, dbName);
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() != this.getErrorCodeDatabaseDoesNotExist()) {
                        ex.printStackTrace();
                    }
                    DBUtil.close((Statement)stmt);
                    DBUtil.close((Connection)connection);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
            DBUtil.close((Statement)stmt);
            DBUtil.close((Connection)connection);
        }
    }

    protected int getErrorCodeDatabaseDoesNotExist() {
        return 1008;
    }

    protected void dropDatabase(Connection connection, Statement stmt, String dbName) throws SQLException {
        stmt.execute("DROP DATABASE " + dbName);
    }

    protected final Connection getSetupConnection() {
        try {
            return this.getSetupDataSource().getConnection();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected final DataSource getSetupDataSource() throws SQLException {
        if (this.setupDataSource == null) {
            this.setupDataSource = this.createDataSourceForDB(null);
        }
        return this.setupDataSource;
    }

    protected abstract DataSource createDataSourceForDB(String var1) throws SQLException;
}

