/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui.views;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.buddies.IBuddyCollaboration;
import org.eclipse.net4j.buddies.internal.ui.CollaborationsItemProvider;
import org.eclipse.net4j.buddies.internal.ui.bundle.OM;
import org.eclipse.net4j.buddies.internal.ui.messages.Messages;
import org.eclipse.net4j.buddies.internal.ui.views.BuddiesDropAdapter;
import org.eclipse.net4j.buddies.internal.ui.views.CollaborationsPane;
import org.eclipse.net4j.buddies.internal.ui.views.SessionManagerView;
import org.eclipse.net4j.buddies.ui.IFacilityPaneCreator;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.actions.SashLayoutAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.widgets.SashComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;

public class CollaborationsView
extends SessionManagerView {
    private SashComposite sashComposite;
    private Map<String, IFacilityPaneCreator> facilityPaneCreators = new HashMap<String, IFacilityPaneCreator>();

    public CollaborationsView() {
        this.initFacilityPaneCreators();
    }

    public CollaborationsPane getCollaborationsPane() {
        return (CollaborationsPane)this.sashComposite.getControl2();
    }

    public Map<String, IFacilityPaneCreator> getFacilityPaneCreators() {
        return this.facilityPaneCreators;
    }

    @Override
    protected Control createControl(Composite parent) {
        this.sashComposite = new SashComposite(parent, 0, 10, 30){

            protected Control createControl1(Composite parent) {
                return CollaborationsView.super.createControl(parent);
            }

            protected Control createControl2(Composite parent) {
                return new CollaborationsPane(parent, CollaborationsView.this);
            }
        };
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IContributionItem)new Separator());
        bars.getToolBarManager().add((IContributionItem)new Separator());
        this.getCollaborationsPane().fillActionBars(bars);
        BuddiesDropAdapter.support((StructuredViewer)this.getViewer());
        return this.sashComposite;
    }

    @Override
    protected void queryBuddiesManager() {
        super.queryBuddiesManager();
        this.getCollaborationsPane().setSession(this.getSession());
    }

    @Override
    public void notifyEvent(IEvent event) {
        super.notifyEvent(event);
        this.getCollaborationsPane().notifyEvent(event);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        super.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new SashLayoutAction.LayoutMenu(this.sashComposite));
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        IBuddyCollaboration collaboration;
        super.fillContextMenu(manager, selection);
        if (selection.size() == 1 && (collaboration = (IBuddyCollaboration)selection.getFirstElement()) != null) {
            manager.insertBefore("additions", (IContributionItem)new Separator());
            for (IFacilityPaneCreator c : this.facilityPaneCreators.values()) {
                String type = c.getType();
                if (collaboration.getFacility(type) != null) continue;
                StartFacilityAction action = new StartFacilityAction(collaboration, type, c.getImageDescriptor());
                manager.insertBefore("additions", (IAction)action);
            }
        }
    }

    protected void doubleClicked(Object object) {
        if (object instanceof IBuddyCollaboration) {
            IBuddyCollaboration collaboration = (IBuddyCollaboration)object;
            this.getCollaborationsPane().setActiveCollaboration(collaboration);
        }
    }

    protected IContainer<?> getContainer() {
        return this.getSession() != null ? this.getSession().getSelf() : ContainerUtil.emptyContainer();
    }

    @Override
    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new CollaborationsItemProvider(){

            @Override
            public Font getFont(Object obj) {
                if (obj instanceof IBuddyCollaboration && obj == CollaborationsView.this.getCollaborationsPane().getActiveCollaboration()) {
                    return this.getBold();
                }
                return super.getFont(obj);
            }
        };
    }

    protected void initFacilityPaneCreators() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.net4j.buddies.ui", "facilityPaneCreators");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("facilityPaneCreator".equals(element.getName())) {
                try {
                    IFacilityPaneCreator creator = (IFacilityPaneCreator)element.createExecutableExtension("class");
                    this.facilityPaneCreators.put(creator.getType(), creator);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    private final class StartFacilityAction
    extends SafeAction {
        private final String type;
        private IBuddyCollaboration collaboration;

        private StartFacilityAction(IBuddyCollaboration collaboration, String type, ImageDescriptor descriptor) {
            super(MessageFormat.format(Messages.getString("CollaborationsView_2"), StringUtil.cap((String)type)), 8);
            this.setToolTipText(MessageFormat.format(Messages.getString("CollaborationsView_3"), type));
            this.setImageDescriptor(descriptor);
            this.collaboration = collaboration;
            this.type = type;
        }

        protected void safeRun() throws Exception {
            this.collaboration.installFacility(this.type);
        }
    }
}

