/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.transfer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class RepositoryTransferDragListener
extends DragSourceAdapter {
    private static final Transfer[] TRANSFERS = new Transfer[]{PluginTransfer.getInstance(), FileTransfer.getInstance()};
    private StructuredViewer viewer;

    protected RepositoryTransferDragListener(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Transfer[] transferArray = TRANSFERS;
        int n = TRANSFERS.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer transfer = transferArray[n2];
            if (transfer.isSupportedType(event.dataType)) {
                event.data = this.getObject(selection, transfer);
                break;
            }
            ++n2;
        }
    }

    protected Object getObject(IStructuredSelection selection, Transfer transfer) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ExtendedDataOutputStream out = new ExtendedDataOutputStream((OutputStream)baos);
            CDOView view = null;
            for (Object object : selection) {
                if (!(object instanceof CDOResourceNode)) continue;
                CDOResourceNode node = (CDOResourceNode)object;
                CDOView nodeView = node.cdoView();
                if (view == null) {
                    view = nodeView;
                    int viewID = CDOViewRegistry.INSTANCE.getID(view);
                    out.writeInt(viewID);
                } else if (view != nodeView) continue;
                out.writeString(node.getPath());
            }
            out.writeString(null);
            byte[] data = baos.toByteArray();
            return new PluginTransferData("org.eclipse.emf.cdo.ui.RepositoryPluginDropAdapter", data);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public static RepositoryTransferDragListener support(StructuredViewer viewer) {
        RepositoryTransferDragListener dragListener = new RepositoryTransferDragListener(viewer);
        viewer.addDragSupport(19, TRANSFERS, (DragSourceListener)dragListener);
        return dragListener;
    }
}

