/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

class ImportClob
implements Clob {
    private ImportLobFile lobFile;
    private long position;
    private long length;
    private long clobLength;
    private String clobData = null;

    public ImportClob(ImportLobFile lobFile, long position, long length) throws IOException {
        this.lobFile = lobFile;
        this.position = position;
        this.length = length;
        this.clobLength = lobFile.getClobDataLength(position, length);
    }

    public ImportClob(String data) {
        this.clobData = data;
        this.clobLength = data.length();
    }

    @Override
    public long length() throws SQLException {
        return this.clobLength;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            if (this.clobData != null) {
                StringReader ir = new StringReader(this.clobData);
                LimitReader lr = new LimitReader(ir);
                lr.setLimit((int)this.clobLength);
                return lr;
            }
            return this.lobFile.getCharacterStream(this.position, this.length);
        }
        catch (Exception e) {
            throw LoadError.unexpectedError(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void free() throws SQLException {
        throw this.methodNotImplemented();
    }

    private SQLException methodNotImplemented() {
        return LoadError.unexpectedError(new Exception("Method not implemented"));
    }
}

