/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.util.concurrent.CountDownLatch;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.SynchronizingCorrelator;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class SynchronizingCorrelatorTest
extends AbstractOMTest {
    public void testPutConsumerFirst() throws Exception {
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        final CountDownLatch correlationEstablished = new CountDownLatch(1);
        final Boolean[] result = new Boolean[]{false};
        Thread consumer = new Thread(){

            @Override
            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                correlationEstablished.countDown();
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + String.valueOf(result[0]));
            }
        };
        consumer.start();
        SynchronizingCorrelatorTest.await(correlationEstablished);
        correlator.put((Object)"eike", (Object)true, 15000L);
        consumer.join(15000L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void testPutConsumerFirst1000() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.testPutConsumerFirst();
            ++i;
        }
    }

    public void testBlockingPutConsumerFirst() throws Exception {
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        final CountDownLatch correlationEstablished = new CountDownLatch(1);
        final Boolean[] result = new Boolean[]{false};
        Thread consumer = new Thread(){

            @Override
            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                correlationEstablished.countDown();
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + String.valueOf(result[0]));
            }
        };
        consumer.start();
        SynchronizingCorrelatorTest.await(correlationEstablished);
        boolean consumed = correlator.put((Object)"eike", (Object)true, 1000L);
        SynchronizingCorrelatorTest.msg("Consumed: " + consumed);
        SynchronizingCorrelatorTest.assertEquals((boolean)true, (boolean)consumed);
        consumer.join(1000L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void testBlockingPutConsumerFirst1000() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.testBlockingPutConsumerFirst();
            ++i;
        }
    }

    public void _testPutProducerFirst() throws Exception {
        final Boolean[] result = new Boolean[]{false};
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        correlator.put((Object)"eike", (Object)true, 15000L);
        Thread consumer = new Thread(){

            @Override
            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + String.valueOf(result[0]));
            }
        };
        consumer.start();
        Thread.sleep(10L);
        consumer.join(100L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void _testPutProducerFirst10() throws Exception {
        int i = 0;
        while (i < 10) {
            this._testPutProducerFirst();
            ++i;
        }
    }

    public void testBlockingPutProducerFirst() throws Exception {
        final Boolean[] result = new Boolean[]{false};
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        boolean consumed = correlator.put((Object)"eike", (Object)true, 50L);
        SynchronizingCorrelatorTest.msg("Consumed: " + consumed);
        SynchronizingCorrelatorTest.assertEquals((boolean)false, (boolean)consumed);
        Thread consumer = new Thread(){

            @Override
            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + String.valueOf(result[0]));
            }
        };
        consumer.start();
        Thread.sleep(10L);
        consumer.join(1000L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void testBlockingPutProducerFirst10() throws Exception {
        int i = 0;
        while (i < 10) {
            this.testBlockingPutProducerFirst();
            ++i;
        }
    }
}

