/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.buffer.IBufferPool;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.tests.data.HugeData;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.tests.AbstractOMTest;
import org.junit.Assert;

public class BufferStreamTest
extends AbstractOMTest {
    private static final short CHANNEL_ID = 0;

    public void testReadArray() throws Exception {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        final BufferInputStream in = new BufferInputStream();
        final byte[] result = new byte[2 * data.length];
        final AtomicInteger bytesRead = new AtomicInteger();
        IBufferPool bufferPool = Net4jUtil.createBufferPool();
        BufferOutputStream out = new BufferOutputStream((IBufferHandler)new BufferStreamPipe(in), (IBufferProvider)bufferPool, 0);
        Thread consumer = new Thread("CONSUMER"){

            @Override
            public void run() {
                try {
                    bytesRead.set(in.read(result));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        consumer.setDaemon(true);
        consumer.start();
        out.write(data);
        out.flushWithEOS();
        out.close();
        consumer.join(150000000000L);
        BufferStreamTest.assertEquals((int)data.length, (int)bytesRead.get());
        byte[] actual = new byte[bytesRead.get()];
        System.arraycopy(result, 0, actual, 0, bytesRead.get());
        Assert.assertArrayEquals((byte[])data, (byte[])actual);
    }

    public void testCopyBinary() throws Exception {
        byte[] data = HugeData.getBytes();
        final BufferInputStream in = new BufferInputStream();
        final ByteArrayOutputStream result = new ByteArrayOutputStream();
        IBufferPool bufferPool = Net4jUtil.createBufferPool();
        BufferOutputStream out = new BufferOutputStream((IBufferHandler)new BufferStreamPipe(in), (IBufferProvider)bufferPool, 0);
        Thread consumer = new Thread("CONSUMER"){

            @Override
            public void run() {
                try {
                    IOUtil.copyBinary((InputStream)in, (OutputStream)result);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        consumer.setDaemon(true);
        consumer.start();
        out.write(data);
        out.flushWithEOS();
        out.close();
        consumer.join(150000000000L);
        Assert.assertArrayEquals((byte[])data, (byte[])result.toByteArray());
    }

    private static final class BufferStreamPipe
    implements IBufferHandler {
        private final BufferInputStream in;

        public BufferStreamPipe(BufferInputStream in) {
            this.in = in;
        }

        public void handleBuffer(IBuffer buffer) {
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            short payload = (short)(byteBuffer.position() - 4);
            byteBuffer.flip();
            byteBuffer.putShort((short)0);
            byteBuffer.putShort(payload);
            this.in.handleBuffer(buffer);
        }
    }
}

