/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.Support;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.CompareWithActionProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.MergeFromActionProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.ReplaceWithActionProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.SwitchToActionProvider;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class CDOCheckoutDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private static final boolean COMPARE_SUPPORT_AVAILABLE = Support.UI_COMPARE.isAvailable();
    private static final EObject[] NO_OBJECTS = new EObject[0];

    public boolean isSupportedType(TransferData transferType) {
        return super.isSupportedType(transferType) || FileTransfer.getInstance().isSupportedType(transferType);
    }

    public IStatus validateDrop(Object target, int dropOperation, TransferData transferType) {
        Operation operation;
        Pair<CDOBranchPoint, CDOCheckout> result = CDOCheckoutDropAdapterAssistant.getSelectedBranchPoint(target, dropOperation, transferType);
        if (result != null) {
            CDOBranchPoint branchPoint = (CDOBranchPoint)result.getElement1();
            CDOCheckout checkout = (CDOCheckout)result.getElement2();
            if (dropOperation == 2) {
                if (checkout.isReadOnly() || branchPoint.getTimeStamp() == 0L) {
                    return Status.OK_STATUS;
                }
            } else {
                if (dropOperation == 1 && COMPARE_SUPPORT_AVAILABLE) {
                    return Status.OK_STATUS;
                }
                if (dropOperation == 4 && COMPARE_SUPPORT_AVAILABLE) {
                    return Status.OK_STATUS;
                }
            }
            return Status.CANCEL_STATUS;
        }
        if (dropOperation != 4 && (operation = Operation.getFor(target, transferType)) != null && operation.canDrop()) {
            if (dropOperation == 2 && !operation.canMove()) {
                this.getCommonDropAdapter().overrideOperation(1);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        if (target == null || dropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        TransferData transferType = dropAdapter.getCurrentTransfer();
        int dropOperation = dropAdapter.getCurrentOperation();
        Pair<CDOBranchPoint, CDOCheckout> result = CDOCheckoutDropAdapterAssistant.getSelectedBranchPoint(target, dropOperation, transferType);
        if (result != null) {
            CDOBranchPoint branchPoint = (CDOBranchPoint)result.getElement1();
            CDOCheckout checkout = (CDOCheckout)result.getElement2();
            if (dropOperation == 2) {
                if (checkout.isReadOnly() || branchPoint.getTimeStamp() == 0L) {
                    if (checkout.isOnline()) {
                        SwitchToActionProvider.switchTo(checkout, branchPoint);
                    } else {
                        ReplaceWithActionProvider.replaceWith(checkout, branchPoint);
                    }
                }
            } else if (dropOperation == 1 && COMPARE_SUPPORT_AVAILABLE) {
                MergeFromActionProvider.mergeFrom(checkout, branchPoint);
            } else if (dropOperation == 4 && COMPARE_SUPPORT_AVAILABLE) {
                CompareWithActionProvider.compareWith(checkout, branchPoint);
            }
            return Status.OK_STATUS;
        }
        Operation operation = Operation.getFor(target, transferType);
        if (operation != null) {
            operation.drop(dropOperation == 1);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private static Pair<CDOBranchPoint, CDOCheckout> getSelectedBranchPoint(Object target, int dropOperation, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IStructuredSelection ssel;
            CDOCheckout checkout;
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (target instanceof CDOCheckout && selection instanceof IStructuredSelection && (checkout = (CDOCheckout)target).isOpen() && (ssel = (IStructuredSelection)selection).size() == 1) {
                CDOBranchPoint branchPoint;
                CDOSession session;
                CDOCheckout otherCheckout;
                CDOBranchPoint branchPoint2;
                CDORepository repository;
                Object element = ssel.getFirstElement();
                if (element instanceof CDORepository && (repository = (CDORepository)element).isConnected()) {
                    element = repository.getSession().getBranchManager().getMainBranch();
                }
                if (element instanceof CDOCheckout && (branchPoint2 = checkout.getBranchPoint(otherCheckout = (CDOCheckout)element)) != null) {
                    element = branchPoint2;
                }
                if (element instanceof CDOBranch) {
                    CDOBranch branch = (CDOBranch)element;
                    element = branch.getHead();
                }
                if (element instanceof CDOBranchPoint && (session = CDOUtil.getSession((Object)(branchPoint = (CDOBranchPoint)element))) == checkout.getView().getSession()) {
                    return Pair.create((Object)branchPoint, (Object)checkout);
                }
            }
        }
        return null;
    }

    private static EObject[] getSelectedObjects() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return CDOCheckoutDropAdapterAssistant.getSelectedObjects((IStructuredSelection)selection);
        }
        return NO_OBJECTS;
    }

    private static EObject[] getSelectedObjects(IStructuredSelection selection) {
        try {
            ArrayList<EObject> selectedObjects = new ArrayList<EObject>();
            CDOCheckout.ObjectType firstObjectType = null;
            for (Object object : selection) {
                if (object instanceof CDOElement) {
                    CDOElement element = (CDOElement)object;
                    Object[] objectArray = element.getChildren();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        firstObjectType = CDOCheckoutDropAdapterAssistant.addSelectedObject(selectedObjects, firstObjectType, child);
                        ++n2;
                    }
                    continue;
                }
                firstObjectType = CDOCheckoutDropAdapterAssistant.addSelectedObject(selectedObjects, firstObjectType, object);
            }
            return selectedObjects.toArray(new EObject[selectedObjects.size()]);
        }
        catch (RuntimeException ex) {
            return NO_OBJECTS;
        }
    }

    private static CDOCheckout.ObjectType addSelectedObject(List<EObject> selectedObjects, CDOCheckout.ObjectType firstObjectType, Object object) {
        EObject eObject = (EObject)AdapterUtil.adapt((Object)object, EObject.class);
        if (eObject != null) {
            CDOCheckout.ObjectType objectType = CDOCheckout.ObjectType.valueFor((Object)eObject);
            if (objectType == null || objectType == CDOCheckout.ObjectType.Root) {
                throw new RuntimeException();
            }
            if (firstObjectType == null) {
                firstObjectType = objectType;
            } else {
                boolean isObject;
                boolean firstIsObject = firstObjectType == CDOCheckout.ObjectType.Object;
                boolean bl = isObject = objectType == CDOCheckout.ObjectType.Object;
                if (firstIsObject != isObject) {
                    throw new RuntimeException();
                }
            }
            selectedObjects.add(eObject);
        }
        return firstObjectType;
    }

    private static abstract class Operation<T extends EObject> {
        private final EObject[] objects;
        private final T target;

        public Operation(EObject[] objects, T target) {
            this.objects = objects;
            this.target = target;
        }

        public final EObject[] getObjects() {
            return this.objects;
        }

        public final T getTarget() {
            return this.target;
        }

        public boolean canDrop() {
            T target = this.getTarget();
            EObject[] objects = this.getObjects();
            CDOCheckout targetCheckout = CDOExplorerUtil.getCheckout(target);
            if (targetCheckout == null) {
                return false;
            }
            EObject[] eObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                EObject object = eObjectArray[n2];
                CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)object);
                if (checkout != targetCheckout) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean canMove() {
            EObject[] objects;
            T target = this.getTarget();
            EObject[] eObjectArray = objects = this.getObjects();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                EObject object = eObjectArray[n2];
                if (object == target || CDOExplorerUtil.getParent((Object)object) == target) {
                    return false;
                }
                ++n2;
            }
            LinkedList path = CDOExplorerUtil.getPath(target);
            if (path == null) {
                return false;
            }
            HashSet targetPath = new HashSet(path);
            EObject[] eObjectArray2 = objects;
            int n3 = objects.length;
            int n4 = 0;
            while (n4 < n3) {
                EObject object = eObjectArray2[n4];
                if (targetPath.contains(object)) {
                    return false;
                }
                ++n4;
            }
            return true;
        }

        public final void drop(final boolean copy) {
            final String title = (copy ? "Copy " : "Move ") + (CDOCheckout.ObjectType.valueFor((Object)this.objects[0]) == CDOCheckout.ObjectType.Object ? "objects" : "resource nodes");
            new Job(title){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(title, 111 + objects.length);
                    CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)objects[0]);
                    CDOTransaction transaction = checkout.openTransaction();
                    monitor.worked(1);
                    try {
                        try {
                            EcoreUtil.Copier copier = null;
                            if (copy) {
                                copier = new EcoreUtil.Copier();
                            }
                            ArrayList<EObject> transactionalObjects = new ArrayList<EObject>();
                            int i = 0;
                            while (i < objects.length) {
                                EObject object = objects[i];
                                EObject transactionalObject = transaction.getObject(object);
                                if (copier != null) {
                                    transactionalObject = copier.copy(transactionalObject);
                                } else {
                                    EcoreUtil.remove((EObject)transactionalObject);
                                }
                                transactionalObjects.add(transactionalObject);
                                monitor.worked(1);
                                ++i;
                            }
                            if (copier != null) {
                                copier.copyReferences();
                                monitor.worked(1);
                            }
                            EObject transactionalTarget = transaction.getObject(target);
                            this.insert(transactionalObjects, transactionalTarget, copy, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                            transaction.commit((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                            Status status = new Status(4, "org.eclipse.emf.cdo.explorer.ui", "The operation did not complete sucessfully.", (Throwable)ex);
                            monitor.done();
                            transaction.close();
                            return status;
                        }
                    }
                    finally {
                        monitor.done();
                        transaction.close();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        protected abstract void insert(List<? extends EObject> var1, T var2, boolean var3, IProgressMonitor var4);

        public static <T extends EObject> Operation<T> getFor(Object target, TransferData transferType) {
            EObject[] selectedObjects;
            if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (selectedObjects = CDOCheckoutDropAdapterAssistant.getSelectedObjects()).length != 0) {
                CDOCheckout.ObjectType objectType = CDOCheckout.ObjectType.valueFor((Object)selectedObjects[0]);
                if (objectType == CDOCheckout.ObjectType.Object) {
                    CDOResource resource;
                    if (target instanceof CDOResource && !(resource = (CDOResource)target).isRoot()) {
                        return new ObjectToResource(selectedObjects, resource);
                    }
                    if (target instanceof EObject && !(target instanceof CDOResourceNode)) {
                        return new ObjectToObject(selectedObjects, (EObject)target);
                    }
                    if (target instanceof CDOCheckout) {
                        CDOCheckout checkout = (CDOCheckout)target;
                        EObject rootObject = checkout.getRootObject();
                        if (rootObject instanceof CDOResource) {
                            return new ObjectToResource(selectedObjects, (CDOResource)rootObject);
                        }
                        if (!(rootObject instanceof CDOResourceNode)) {
                            return new ObjectToObject(selectedObjects, rootObject);
                        }
                    }
                } else {
                    if (target instanceof CDOCheckout) {
                        CDOResource resource;
                        CDOCheckout checkout = (CDOCheckout)target;
                        EObject rootObject = checkout.getRootObject();
                        if (rootObject instanceof CDOResourceFolder) {
                            return new ResourceNodeToFolder(selectedObjects, (CDOResourceFolder)rootObject);
                        }
                        if (rootObject instanceof CDOResource && (resource = (CDOResource)rootObject).isRoot()) {
                            return new ResourceNodeToRootResource(selectedObjects, resource);
                        }
                    }
                    if (target instanceof CDOResourceFolder) {
                        return new ResourceNodeToFolder(selectedObjects, (CDOResourceFolder)target);
                    }
                }
            }
            return null;
        }

        private static void setUniqueName(CDOResourceNode resourceNode, EList<? extends EObject> targetContents, boolean copy) {
            Object name;
            boolean nameConflict = false;
            String resourceName = resourceNode.getName();
            HashSet<Object> names = new HashSet<Object>();
            for (Object existingChild : targetContents) {
                if (existingChild == resourceNode) continue;
                name = ((CDOResourceNode)existingChild).getName();
                if (ObjectUtil.equals((Object)name, (Object)resourceName)) {
                    nameConflict = true;
                }
                names.add(name);
            }
            if (nameConflict) {
                String renamed = resourceName + (copy ? "-copy" : "-renamed");
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    name = renamed;
                    if (i != 0) {
                        name = (String)name + i;
                    }
                    if (!names.contains(name)) {
                        resourceNode.setName((String)name);
                        return;
                    }
                    ++i;
                }
            }
        }

        private static final class ObjectToObject
        extends Operation<EObject> {
            public ObjectToObject(EObject[] objects, EObject target) {
                super(objects, target);
            }

            @Override
            public boolean canDrop() {
                if (!super.canDrop()) {
                    return false;
                }
                Object target = this.getTarget();
                EObject[] objects = this.getObjects();
                class FeatureUsage {
                    private final int upperBound;
                    private int size;

                    public FeatureUsage(EReference feature, EObject eObject) {
                        this.upperBound = feature.getUpperBound();
                        if (feature.isMany()) {
                            List list = (List)eObject.eGet((EStructuralFeature)feature);
                            this.size = list.size();
                        } else if (feature.isUnsettable()) {
                            if (eObject.eIsSet((EStructuralFeature)feature)) {
                                this.size = 1;
                            }
                        } else {
                            Object value = eObject.eGet((EStructuralFeature)feature);
                            if (value != null) {
                                this.size = 1;
                            }
                        }
                    }

                    public boolean use() {
                        return ++this.size <= this.upperBound || this.upperBound == -1;
                    }
                }
                HashMap<EReference, FeatureUsage> usages = new HashMap<EReference, FeatureUsage>();
                for (EReference feature : target.eClass().getEAllContainments()) {
                    usages.put(feature, new FeatureUsage(feature, (EObject)target));
                }
                EObject[] eObjectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject object = eObjectArray[n2];
                    EReference feature = this.getTargetFeature(object, (EObject)target);
                    if (feature == null) {
                        return false;
                    }
                    FeatureUsage usage = (FeatureUsage)usages.get(feature);
                    if (usage == null || !usage.use()) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            protected void insert(List<? extends EObject> objects, EObject target, boolean copy, IProgressMonitor monitor) {
                for (EObject eObject : objects) {
                    EReference feature = this.getTargetFeature(eObject, target);
                    if (!feature.isMany()) continue;
                    List list = (List)target.eGet((EStructuralFeature)feature);
                    list.add(eObject);
                }
            }

            private EReference getTargetFeature(EObject object, EObject target) {
                EClass eClass = object.eClass();
                for (EReference feature : target.eClass().getEAllContainments()) {
                    EClass referenceType = feature.getEReferenceType();
                    if (!referenceType.isSuperTypeOf(eClass)) continue;
                    return feature;
                }
                return null;
            }
        }

        private static final class ObjectToResource
        extends Operation<CDOResource> {
            public ObjectToResource(EObject[] objects, CDOResource target) {
                super(objects, target);
            }

            @Override
            protected void insert(List<? extends EObject> objects, CDOResource target, boolean copy, IProgressMonitor monitor) {
                target.getContents().addAll(objects);
            }
        }

        private static final class ResourceNodeToFolder
        extends Operation<CDOResourceFolder> {
            public ResourceNodeToFolder(EObject[] objects, CDOResourceFolder target) {
                super(objects, target);
            }

            @Override
            protected void insert(List<? extends EObject> objects, CDOResourceFolder target, boolean copy, IProgressMonitor monitor) {
                EList nodes = target.getNodes();
                for (EObject eObject : objects) {
                    CDOResourceNode resourceNode = (CDOResourceNode)eObject;
                    Operation.setUniqueName(resourceNode, (EList<? extends EObject>)nodes, copy);
                    nodes.add((Object)resourceNode);
                }
            }
        }

        private static final class ResourceNodeToRootResource
        extends Operation<CDOResource> {
            public ResourceNodeToRootResource(EObject[] objects, CDOResource target) {
                super(objects, target);
            }

            @Override
            protected void insert(List<? extends EObject> objects, CDOResource target, boolean copy, IProgressMonitor monitor) {
                EList contents = target.getContents();
                for (EObject eObject : objects) {
                    CDOResourceNode resourceNode = (CDOResourceNode)eObject;
                    Operation.setUniqueName(resourceNode, (EList<? extends EObject>)contents, copy);
                    contents.add((Object)resourceNode);
                }
            }
        }
    }
}

