/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.om.log.OMLogger;

@FunctionalInterface
public interface ExceptionHandler {
    public void handleException(Object var1, Throwable var2, String var3, OMLogger var4);

    public static abstract class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.exceptionHandlers";

        public Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        @Override
        public abstract ExceptionHandler create(String var1) throws ProductCreationException;

        public static ExceptionHandler get(IManagedContainer container, String type) {
            return (ExceptionHandler)container.getElementOrNull(PRODUCT_GROUP, type, NO_DESCRIPTION);
        }

        public static void handle(Object catcher, Throwable ex, String message, OMLogger logger) {
            IManagedContainer container = ContainerUtil.getContainer(catcher);
            Factory.handle(catcher, ex, message, logger, container);
        }

        public static void handle(IManagedContainerProvider catcher, Throwable ex, String message, OMLogger logger) {
            Factory.handle((Object)catcher, ex, message, logger, catcher);
        }

        public static void handle(Object catcher, Throwable ex, String message, OMLogger logger, IManagedContainerProvider containerProvider) {
            IManagedContainer container = null;
            if (containerProvider != null) {
                container = containerProvider.getContainer();
            }
            Factory.handle(catcher, ex, message, logger, container);
        }

        public static void handle(Object catcher, Throwable ex, String message, OMLogger logger, IManagedContainer container) {
            ExceptionHandler handler = Factory.getForLogger(container, logger);
            if (handler != null) {
                try {
                    handler.handleException(catcher, ex, message, logger);
                }
                catch (Throwable throwable) {}
            } else {
                logger.error(message, ex);
            }
        }

        private static ExceptionHandler getForLogger(IManagedContainer container, OMLogger logger) {
            if (container != null) {
                String bundleID;
                ExceptionHandler handler;
                if (logger != null && (handler = Factory.get(container, bundleID = logger.getBundle().getBundleID())) != null) {
                    return handler;
                }
                ExceptionHandler handler2 = Factory.get(container, null);
                if (handler2 != null) {
                    return handler2;
                }
            }
            return null;
        }
    }
}

