/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.internal.db.DBConnection;
import org.eclipse.net4j.internal.db.DBDatabase;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBSchema;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBSchemaElement;
import org.eclipse.net4j.internal.db.ddl.delta.DBSchemaDelta;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;

public final class DBSchemaTransaction
implements IDBSchemaTransaction,
DBUtil.RunnableWithConnection<DBSchemaDelta> {
    private DBDatabase database;
    private DBConnection connection;
    private IDBSchema oldSchema;
    private IDBSchema oldSchemaCopy;
    private IDBSchema workingCopy;

    public DBSchemaTransaction(DBDatabase database) {
        this.database = database;
        this.oldSchema = database.getSchema();
        this.oldSchemaCopy = DBUtil.copySchema(this.oldSchema);
        IDBSchema copy = DBUtil.copySchema(this.oldSchema);
        this.workingCopy = DelegatingDBSchemaElement.wrap(copy);
    }

    @Override
    public DBDatabase getDatabase() {
        return this.database;
    }

    @Override
    public DBConnection getConnection() {
        return this.connection;
    }

    public void setConnection(DBConnection connection) {
        this.connection = connection;
    }

    @Override
    public IDBSchema getWorkingCopy() {
        return this.workingCopy;
    }

    @Override
    public DBSchemaDelta ensureSchema(IDBSchema schema, IDBDeltaVisitor.Filter.Policy policy) {
        IDBSchema workingCopy = this.getWorkingCopy();
        IDBDeltaVisitor.Copier copier = new IDBDeltaVisitor.Copier(policy);
        IDBSchemaDelta delta = schema.compare(workingCopy);
        delta.accept(copier);
        DBSchemaDelta result = (DBSchemaDelta)copier.getResult();
        result.setName(workingCopy.getName());
        result.applyTo(workingCopy);
        return result;
    }

    @Override
    public DBSchemaDelta ensureSchema(IDBSchema schema) {
        return this.ensureSchema(schema, DEFAULT_ENSURE_SCHEMA_POLICY);
    }

    @Override
    public DBSchemaDelta getSchemaDelta() {
        return (DBSchemaDelta)this.workingCopy.compare(this.oldSchemaCopy);
    }

    @Override
    public DBSchemaDelta commit() {
        if (this.connection == null) {
            return DBUtil.execute(this.database, this);
        }
        DBConnection connection = this.connection;
        try {
            DBSchemaDelta result = this.run(connection);
            connection.commit();
            return result;
        }
        catch (SQLException ex) {
            DBUtil.rollbackSilently(connection);
            throw new DBException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBSchemaDelta run(Connection connection) throws SQLException {
        DBSchemaDelta delta = this.getSchemaDelta();
        IDBSchema iDBSchema = this.oldSchema;
        synchronized (iDBSchema) {
            try {
                ((InternalDBSchema)this.oldSchema).unlock();
                DBAdapter adapter = this.database.getAdapter();
                adapter.updateSchema(connection, this.oldSchema, delta);
                ((DelegatingDBSchema)this.workingCopy).setDelegate(this.oldSchema);
            }
            finally {
                ((InternalDBSchema)this.oldSchema).lock();
                this.doClose(delta);
            }
        }
        return delta;
    }

    public void close() {
        this.doClose(null);
    }

    private void doClose(DBSchemaDelta delta) {
        if (!this.isClosed()) {
            this.database.closeSchemaTransaction(delta);
            this.connection = null;
            this.oldSchema = null;
            this.oldSchemaCopy = null;
            this.workingCopy = null;
        }
    }

    public boolean isClosed() {
        return this.workingCopy == null;
    }
}

