/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.security.ChallengeNegotiator;
import org.eclipse.net4j.util.security.IChallengeResponse;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.NegotiationContext;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.Randomizer;
import org.eclipse.net4j.util.security.ResponseNegotiator;
import org.eclipse.net4j.util.security.UserManager;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class SecurityTest
extends AbstractOMTest {
    private static final int TIMEOUT = 1000;
    private static final String USER_ID = "stepper";
    private static final char[] PASSWORD1 = "eike2007".toCharArray();
    private static final char[] PASSWORD2 = "invalid".toCharArray();
    private static final PasswordCredentials CREDENTIALS = new PasswordCredentials("stepper", PASSWORD1);
    private IPasswordCredentialsProvider credentialsProvider = new PasswordCredentialsProvider((IPasswordCredentials)CREDENTIALS);

    public void testRandomizerAcceptsSeedsBeforeActivation() {
        Randomizer randomizer = new Randomizer();
        randomizer.setSeed(2L);
    }

    public void testSuccess() throws Exception {
        Randomizer randomizer = new Randomizer();
        randomizer.activate();
        UserManager userManager = new UserManager();
        userManager.activate();
        userManager.addUser(USER_ID, PASSWORD1);
        PeerNegotiationContext challengeContext = new PeerNegotiationContext();
        PeerNegotiationContext responseContext = new PeerNegotiationContext();
        challengeContext.setPeer(responseContext);
        responseContext.setPeer(challengeContext);
        Thread challengeThread = new Thread((Runnable)challengeContext, "challengeThread");
        challengeThread.start();
        Thread responseThread = new Thread((Runnable)responseContext, "responseThread");
        responseThread.start();
        ResponseNegotiator responseNegotiator = new ResponseNegotiator();
        responseNegotiator.setCredentialsProvider(this.credentialsProvider);
        responseNegotiator.activate();
        responseNegotiator.negotiate((INegotiationContext)responseContext);
        ChallengeNegotiator challengeNegotiator = new ChallengeNegotiator();
        challengeNegotiator.setRandomizer((IRandomizer)randomizer);
        challengeNegotiator.setUserManager((IUserManager)userManager);
        challengeNegotiator.activate();
        challengeNegotiator.negotiate((INegotiationContext)challengeContext);
        Enum responseState = responseContext.waitUntilFinished(1000L);
        SecurityTest.assertEquals(IChallengeResponse.State.SUCCESS, responseState);
        Enum challengeState = challengeContext.waitUntilFinished(1000L);
        SecurityTest.assertEquals(IChallengeResponse.State.SUCCESS, challengeState);
        challengeContext.deactivate();
        responseContext.deactivate();
        challengeNegotiator.deactivate();
        responseNegotiator.deactivate();
        userManager.deactivate();
        randomizer.deactivate();
    }

    public void testFailure() throws Exception {
        Randomizer randomizer = new Randomizer();
        randomizer.activate();
        UserManager userManager = new UserManager();
        userManager.activate();
        userManager.addUser(USER_ID, PASSWORD2);
        PeerNegotiationContext challengeContext = new PeerNegotiationContext();
        PeerNegotiationContext responseContext = new PeerNegotiationContext();
        challengeContext.setPeer(responseContext);
        responseContext.setPeer(challengeContext);
        Thread challengeThread = new Thread((Runnable)challengeContext, "challengeThread");
        challengeThread.start();
        Thread responseThread = new Thread((Runnable)responseContext, "responseThread");
        responseThread.start();
        ResponseNegotiator responseNegotiator = new ResponseNegotiator();
        responseNegotiator.setCredentialsProvider(this.credentialsProvider);
        responseNegotiator.activate();
        responseNegotiator.negotiate((INegotiationContext)responseContext);
        ChallengeNegotiator challengeNegotiator = new ChallengeNegotiator();
        challengeNegotiator.setRandomizer((IRandomizer)randomizer);
        challengeNegotiator.setUserManager((IUserManager)userManager);
        challengeNegotiator.activate();
        challengeNegotiator.negotiate((INegotiationContext)challengeContext);
        Enum responseState = responseContext.waitUntilFinished(1000L);
        SecurityTest.assertEquals(IChallengeResponse.State.FAILURE, responseState);
        Enum challengeState = challengeContext.waitUntilFinished(1000L);
        SecurityTest.assertEquals(IChallengeResponse.State.FAILURE, challengeState);
        challengeContext.deactivate();
        responseContext.deactivate();
        challengeNegotiator.deactivate();
        responseNegotiator.deactivate();
        userManager.deactivate();
        randomizer.deactivate();
    }

    private final class PeerNegotiationContext
    extends NegotiationContext
    implements Runnable {
        private final BlockingQueue<ByteBuffer> queue = new LinkedBlockingQueue<ByteBuffer>();
        private volatile PeerNegotiationContext peer;
        private volatile String userID;
        private volatile boolean running;

        public PeerNegotiationContext getPeer() {
            return this.peer;
        }

        public void setPeer(PeerNegotiationContext peer) {
            this.peer = peer;
        }

        public String getUserID() {
            return this.userID;
        }

        public void setUserID(String userID) {
            this.userID = userID;
        }

        public ByteBuffer getBuffer() {
            return ByteBuffer.allocateDirect(4096);
        }

        public void transmitBuffer(ByteBuffer buffer) {
            buffer.flip();
            this.queue.add(buffer);
        }

        public void deactivate() {
            this.running = false;
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                INegotiationContext.Receiver receiver;
                if (this.peer == null || (receiver = this.peer.getReceiver()) == null) continue;
                ByteBuffer buffer = null;
                try {
                    buffer = this.queue.poll(50L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
                if (buffer == null) continue;
                receiver.receiveBuffer((INegotiationContext)this.peer, buffer);
            }
        }
    }
}

