/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.reviews.DropReview;
import org.eclipse.emf.cdo.lm.reviews.ReviewsFactory;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.CheckoutAction;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewDropReviewAction
extends LMAction.NewElement<Delivery> {
    private final DropType dropType;
    private String dropLabel;
    private boolean checkout;

    public NewDropReviewAction(IWorkbenchPage page, StructuredViewer viewer, Delivery delivery, DropType dropType) {
        super(page, viewer, "New " + dropType.getName() + " Review" + INTERACTIVE, "Add a new " + dropType.getName().toLowerCase() + " review to stream '" + delivery.getStream().getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(ReviewsEditPlugin.INSTANCE.getImage(dropType.isRelease() ? "full/obj16/ReleaseReview" : "full/obj16/DropReview")), "Add a new " + dropType.getName().toLowerCase() + " review to stream '" + delivery.getStream().getName() + "'.", dropType.isRelease() ? "icons/NewRelease.png" : "icons/NewDrop.png", (CDOObject)delivery);
        this.dropType = dropType;
    }

    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Delivery delivery = (Delivery)this.getContext();
        this.dropLabel = delivery.getVersion().toString();
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Version:");
        Text versionText = new Text(parent, 2056);
        versionText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        versionText.setText(this.dropLabel);
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Drop Label:");
        Text labelText = new Text(parent, 2052);
        labelText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        labelText.setText(this.dropLabel);
        labelText.addModifyListener(e -> {
            this.dropLabel = labelText.getText();
            this.validateDialog();
        });
        labelText.setFocus();
        labelText.selectAll();
        Button button = this.newCheckBox(parent, "Checkout");
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.checkout = button.getSelection();
            this.validateDialog();
        }));
    }

    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.dropLabel == null || this.dropLabel.isEmpty()) {
            return "A drop label must be entered.";
        }
        return super.doValidate(dialog);
    }

    protected CDOObject newElement(Delivery delivery, IProgressMonitor monitor) throws Exception {
        ISystemDescriptor systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)delivery);
        String author = systemDescriptor.getSystemRepository().getCredentials().getUserID();
        DropReview review = (DropReview)systemDescriptor.modify((ModelElement)delivery, d -> {
            DropReview r = ReviewsFactory.eINSTANCE.createDropReview();
            r.setDelivery(delivery);
            r.setDropType(this.dropType);
            r.setDropLabel(this.dropLabel);
            r.setVersion(d.getVersion());
            r.getDependencies().addAll(EcoreUtil.copyAll((Collection)d.getDependencies()));
            r.setAuthor(author);
            d.getStream().insertContent((Baseline)r);
            Annotation annotation = ReviewsPackage.getAnnotation((ModelElement)d, (boolean)true);
            annotation.getReferences().add((Object)r);
            return r;
        }, monitor);
        if (this.checkout) {
            if (review != null) {
                try {
                    String checkoutLabel = this.getCheckoutLabel(review);
                    CheckoutAction.checkout((Baseline)review, (String)checkoutLabel, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            } else {
                monitor.worked(1);
            }
        }
        return review;
    }

    private String getCheckoutLabel(DropReview review) {
        if (StringUtil.isEmpty((String)this.dropLabel)) {
            return "";
        }
        return "Module " + ((Delivery)this.getContext()).getModule().getName() + " - " + this.dropType.getName() + " Review " + review.getId() + " - " + this.dropLabel;
    }
}

