/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.cdo.ecore.dependencies.Addressable;
import org.eclipse.emf.cdo.ecore.dependencies.Element;
import org.eclipse.emf.cdo.ecore.dependencies.Link;
import org.eclipse.emf.cdo.ecore.dependencies.ModelContainer;
import org.eclipse.emf.cdo.ecore.dependencies.util.Graph;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public interface Model
extends Addressable {
    public static final Comparator<Model> TOPOLOGICAL_COMPARATOR = new Comparator<Model>(){

        @Override
        public int compare(Model m1, Model m2) {
            if (m1.dependsUpon(m2)) {
                return -1;
            }
            if (m2.dependsUpon(m1)) {
                return 1;
            }
            return ALPHABETICAL_COMPARATOR.compare(m1, m2);
        }
    };

    public ModelContainer getContainer();

    public void setContainer(ModelContainer var1);

    public IFile getFile();

    public boolean isWorkspace();

    public boolean isExists();

    public void setExists(boolean var1);

    public String getNsURI();

    public void setNsURI(String var1);

    public String getName();

    public void setName(String var1);

    public EList<Element> getElements();

    public EList<Link> getOutgoingLinks();

    public EList<Link> getIncomingLinks();

    public EList<Link> getBrokenLinks();

    public EList<Model> getDependencies();

    public EList<Model> getDependingModels();

    public EList<Model> getFlatDependencies();

    public EList<Model> getFlatDependingModels();

    public boolean dependsUpon(Model var1);

    public void addDependency(Model var1);

    public boolean hasBrokenLinks();

    public Element getElement(URI var1);

    public static List<Model> sortModels(List<Model> models, boolean byDependencies) {
        if (byDependencies) {
            models = Graph.topologicalSort(models, Model::getDependencies);
        } else {
            models.sort(ALPHABETICAL_COMPARATOR);
        }
        return models;
    }
}

