/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.properties;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.ui.views.AssembliesView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ModulePropertyPage
extends PropertyPage {
    private IAssemblyDescriptor assemblyDescriptor;
    private ContainerItemProvider<IContainer<Object>> itemProvider;
    private TreeViewer viewer;
    private Font bold;
    private Button installUpdatesButton;

    public ModulePropertyPage() {
        this.noDefaultAndApplyButton();
    }

    public void dispose() {
        UIUtil.dispose((Font)this.bold);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        this.bold = UIUtil.getBoldFont((Control)parent);
        final Display display = parent.getDisplay();
        Composite container = new Composite(parent, 0);
        GridLayout containerGridLayout = new GridLayout();
        container.setLayout((Layout)containerGridLayout);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout());
        this.assemblyDescriptor = IAssemblyManager.INSTANCE.getDescriptor((CDOCheckout)this.getElement());
        IElementFilter rootElementFilter = element -> element == this.assemblyDescriptor;
        this.itemProvider = new ContainerItemProvider<IContainer<Object>>(rootElementFilter){

            protected void handleElementEvent(IEvent event) {
                if (event instanceof IAssemblyDescriptor.UpdateStateChangedEvent) {
                    UIUtil.asyncExec(() -> ModulePropertyPage.this.updateStateChanged());
                } else if (event instanceof IAssemblyDescriptor.AvailableUpdatesChangedEvent) {
                    UIUtil.asyncExec(() -> ModulePropertyPage.this.availableUpdatesChanged());
                }
            }

            protected Object[] getContainerChildren(ContainerItemProvider.AbstractContainerNode containerNode, IContainer<?> container) {
                Object[] children = super.getContainerChildren(containerNode, container);
                children = AssembliesView.addNewModules(container, children);
                return children;
            }

            protected ContainerItemProvider.Node createNode(ContainerItemProvider.Node parent, Object element) {
                IAssemblyDescriptor descriptor;
                List errors;
                if (element instanceof IAssemblyDescriptor && !ObjectUtil.isEmpty((Collection)(errors = (descriptor = (IAssemblyDescriptor)element).getResolutionErrors()))) {
                    return new ContainerItemProvider.FixedChildrenNode((ContainerItemProvider)this, parent, element, (Iterable)errors);
                }
                if (element instanceof AssemblyModule) {
                    EList<DependencyDefinition> dependencies = AssembliesView.getDependencies(parent, (AssemblyModule)element);
                    return new ContainerItemProvider.FixedChildrenNode((ContainerItemProvider)this, parent, element, dependencies);
                }
                return super.createNode(parent, element);
            }

            public String getText(Object element) {
                String text = AssembliesView.getText(element);
                if (text != null) {
                    return text;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                Image image = AssembliesView.getImage(element);
                if (image != null) {
                    return image;
                }
                return super.getImage(element);
            }

            public Font getFont(Object element) {
                Font font = AssembliesView.getFont(element, ModulePropertyPage.this.bold, this);
                if (font != null) {
                    return font;
                }
                return super.getFont(element);
            }

            public Color getForeground(Object element) {
                Color foreground = AssembliesView.getForeground(element, display);
                if (foreground != null) {
                    return foreground;
                }
                return super.getForeground(element);
            }
        };
        this.viewer = new TreeViewer(composite, 2816);
        this.viewer.setContentProvider(this.itemProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider(this.itemProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.viewer.setInput((Object)IAssemblyManager.INSTANCE);
        UIUtil.asyncExec((Display)display, () -> this.viewer.expandAll());
        this.installUpdatesButton = new Button(container, 8);
        this.installUpdatesButton.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.installUpdatesButton.setText("Install Updates...");
        this.installUpdatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePropertyPage.this.installUpdates();
            }
        });
        this.updateStateChanged();
        return container;
    }

    private void updateStateChanged() {
        this.installUpdatesButton.setEnabled(this.assemblyDescriptor.hasUpdatesAvailable());
    }

    private void availableUpdatesChanged() {
        this.itemProvider.clearNodesCache();
        UIUtil.refreshViewer((Viewer)this.viewer);
    }

    private void installUpdates() {
        if (this.installUpdatesButton.isEnabled()) {
            new Job(this.installUpdatesButton.getText()){

                protected IStatus run(IProgressMonitor progressMonitor) {
                    try {
                        ModulePropertyPage.this.assemblyDescriptor.update();
                        return Status.OK_STATUS;
                    }
                    catch (Exception ex) {
                        return new Status(4, "org.eclipse.emf.cdo.lm.ui", ex.getMessage(), (Throwable)ex);
                    }
                }
            }.schedule();
        }
    }
}

