/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.ReviewsFactory;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.cdo.lm.reviews.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewCommentAction
extends LMAction.NewElement<TopicContainer> {
    private String text;

    public NewCommentAction(IWorkbenchPage page, StructuredViewer viewer, TopicContainer container) {
        super(page, viewer, "New Comment" + INTERACTIVE, "Add a new comment", ExtendedImageRegistry.INSTANCE.getImageDescriptor(ReviewsEditPlugin.INSTANCE.getImage("full/obj16/Comment")), "Add a new comment.", "icons/wizban/NewComment.png", (CDOObject)container);
    }

    protected ImageDescriptor getImageDescriptor(String imagePath) {
        return OM.getImageDescriptor(imagePath);
    }

    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 1).create());
        label.setText("Text:");
        Text textArea = new Text(parent, 2050);
        textArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(4, 4).create());
        textArea.addModifyListener(event -> {
            this.text = textArea.getText();
            this.validateDialog();
        });
    }

    protected String doValidate(LMAction.LMDialog dialog) {
        if (StringUtil.isEmpty((String)this.text)) {
            return "A text must be entered.";
        }
        return super.doValidate(dialog);
    }

    protected CDOObject newElement(TopicContainer container, IProgressMonitor monitor) throws Exception {
        Comment comment = ReviewsFactory.eINSTANCE.createComment();
        comment.setText(this.text);
        ISystemDescriptor systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)container);
        return (CDOObject)systemDescriptor.modify((ModelElement)container, tc -> {
            tc.getComments().add((Object)comment);
            return comment;
        }, monitor);
    }
}

