/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterPackagesAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class RegisterSinglePackageAction
extends RegisterPackagesAction {
    private String packageURI;
    private EPackage.Registry registry = EPackage.Registry.INSTANCE;

    public RegisterSinglePackageAction(IWorkbenchPage page, CDOSession session, String packageURI) {
        super(page, packageURI, Messages.getString("RegisterSinglePackageAction.0") + packageURI, RegisterSinglePackageAction.getDescriptor(packageURI), session);
        this.packageURI = packageURI;
    }

    @Override
    protected List<EPackage> getEPackages(IWorkbenchPage page, CDOSession session) {
        EPackage ePackage = this.registry.getEPackage(this.packageURI);
        if (ePackage != null) {
            return Collections.singletonList(ePackage);
        }
        return Collections.emptyList();
    }

    private static ImageDescriptor getDescriptor(String nsURI) {
        CDOPackageUnit.Type type = CDOPackageTypeRegistry.INSTANCE.lookup(nsURI);
        switch (type) {
            case LEGACY: {
                return SharedIcons.getDescriptor((String)"obj16/EPackageLegacy.gif");
            }
            case NATIVE: {
                return SharedIcons.getDescriptor((String)"obj16/EPackageNative.gif");
            }
            case DYNAMIC: {
                return SharedIcons.getDescriptor((String)"obj16/EPackageDynamic.gif");
            }
            case UNKNOWN: {
                return SharedIcons.getDescriptor((String)"obj16/EPackageUnknown.gif");
            }
        }
        return null;
    }
}

