/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lm;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamMode;
import org.eclipse.emf.cdo.lm.StreamSpec;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.lm.server.AbstractLifecycleManager;
import org.eclipse.emf.cdo.lm.util.LMMerger;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.tests.lm.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public abstract class AbstractLMTest
extends TestCase {
    public static final String SYSTEM_NAME = "System2022";
    public static final String MODULE_DEFINITION_PATH = "module.md";
    public static final IPluginContainer CONTAINER;
    private static final String BROWSER_PORT = "org.eclipse.emf.cdo.server.browser.port";
    private static final File TEST_FOLDER;
    private static final String ACCEPTOR_NAME = "lm-test";
    private InternalRepository systemRepository;
    private AbstractLifecycleManager lifecycleManager;
    private IAcceptor acceptor;

    static {
        String port;
        CONTAINER = IPluginContainer.INSTANCE;
        TEST_FOLDER = new File(OM.BUNDLE.getStateLocation());
        AbstractLMTest.msg("Test Folder: " + String.valueOf(TEST_FOLDER));
        if (!OMPlatform.INSTANCE.isOSGiRunning()) {
            AbstractLMTest.fail((String)"The test must be run iside OSGi, i.e., as 'JUnit Plug-in Test', to make p2 happy!");
        }
        if ((port = OMPlatform.INSTANCE.getProperty(BROWSER_PORT)) != null) {
            AbstractLMTest.msg("DB Browser:  http://localhost:" + port);
            CONTAINER.getElement("org.eclipse.emf.cdo.server.browsers", "default", port);
        }
        AbstractLMTest.msg(new String[0]);
    }

    private static InternalRepository createRepository(String name, File dbFolder) {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + String.valueOf(dbFolder) + "/" + name);
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true);
        H2Adapter dbAdapter = new H2Adapter();
        IDBConnectionProvider dbConnectionProvider = dbAdapter.createConnectionProvider((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", "true");
        props.put("supportingBranches", "true");
        InternalRepository repository = (InternalRepository)CDOServerUtil.createRepository((String)name, (IStore)store, props);
        CDOServerUtil.addRepository((IManagedContainer)CONTAINER, (IRepository)repository);
        return repository;
    }

    protected void setUp() throws Exception {
        String testName = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName();
        AbstractLMTest.msg("+++++++++++++++++++++++ " + testName + "() +++++++++++++++++++++++");
        final File dbFolder = this.getTestFolder("db");
        dbFolder.mkdirs();
        AbstractLMTest.msg("Test folder: " + String.valueOf(dbFolder.getParentFile()));
        this.systemRepository = AbstractLMTest.createRepository(SYSTEM_NAME, dbFolder);
        this.lifecycleManager = new AbstractLifecycleManager(){

            protected InternalRepository createModuleRepository(String moduleName) throws CoreException {
                return AbstractLMTest.createRepository(moduleName, dbFolder);
            }
        };
        this.lifecycleManager.setProcessInitializer(process -> {
            process.getDropTypes().add((Object)LMFactory.eINSTANCE.createDropType("Tag", false));
            process.getDropTypes().add((Object)LMFactory.eINSTANCE.createDropType("Milestone", false));
            process.getDropTypes().add((Object)LMFactory.eINSTANCE.createDropType("Release", true));
        });
        this.lifecycleManager.setSystemRepository(this.systemRepository);
        this.lifecycleManager.setSystemName(SYSTEM_NAME);
        this.lifecycleManager.setModuleDefinitionPath(MODULE_DEFINITION_PATH);
        this.lifecycleManager.activate();
        this.acceptor = JVMUtil.getAcceptor((IManagedContainer)CONTAINER, (String)ACCEPTOR_NAME);
    }

    protected void tearDown() throws Exception {
        CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckout checkout = cDOCheckoutArray[n2];
            checkout.delete(true);
            ++n2;
        }
        cDOCheckoutArray = CDOExplorerUtil.getRepositoryManager().getRepositories();
        n = cDOCheckoutArray.length;
        n2 = 0;
        while (n2 < n) {
            CDOCheckout repository = cDOCheckoutArray[n2];
            repository.delete(true);
            ++n2;
        }
        LifecycleUtil.deactivate((Object)this.acceptor);
        LifecycleUtil.deactivate((Object)this.lifecycleManager);
        LifecycleUtil.deactivate((Object)this.systemRepository);
        AbstractLMTest.msg("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    protected File getTestFolder(String name) {
        String testName = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName();
        File testFolder = new File(TEST_FOLDER, testName);
        File result = new File(testFolder, name);
        result.mkdirs();
        return result;
    }

    protected Stream createStream(ISystemDescriptor systemDescriptor, Module module, Drop base, int major, int minor, String streamCodeName) throws Exception {
        Stream stream = systemDescriptor.createStream(module, base, new StreamSpec(major, minor, streamCodeName), AbstractLMTest.monitor());
        MatcherAssert.assertThat((Object)stream.getModule(), (Matcher)CoreMatchers.is((Object)module));
        MatcherAssert.assertThat((Object)stream.getSystem(), (Matcher)CoreMatchers.is((Object)systemDescriptor.getSystem()));
        MatcherAssert.assertThat((Object)stream.getMajorVersion(), (Matcher)CoreMatchers.is((Object)major));
        MatcherAssert.assertThat((Object)stream.getMinorVersion(), (Matcher)CoreMatchers.is((Object)minor));
        MatcherAssert.assertThat((Object)stream.getCodeName(), (Matcher)CoreMatchers.is((Object)streamCodeName));
        MatcherAssert.assertThat((Object)stream.getMode(), (Matcher)CoreMatchers.is((Object)StreamMode.DEVELOPMENT));
        MatcherAssert.assertThat((Object)stream.getBranchPoint(), (Matcher)CoreMatchers.is((Object)CDOBranchPointRef.MAIN_HEAD));
        MatcherAssert.assertThat((Object)stream, (Matcher)CoreMatchers.is((Object)module.getStream(streamCodeName)));
        return stream;
    }

    protected ModuleCreationResult createModule(ISystemDescriptor systemDescriptor, org.eclipse.emf.cdo.lm.System system, String moduleName, String streamCodeName, int major, int minor) throws Exception {
        Module module = systemDescriptor.createModule(moduleName, new StreamSpec(major, minor, streamCodeName), AbstractLMTest.monitor());
        Stream stream = module.getStream(0, 1);
        String label = moduleName + "- Stream " + major + "." + minor;
        IAssemblyDescriptor assemblyDescriptor = IAssemblyManager.INSTANCE.createDescriptor(label, (Baseline)stream, AbstractLMTest.monitor());
        MatcherAssert.assertThat((Object)stream.getModule(), (Matcher)CoreMatchers.is((Object)module));
        MatcherAssert.assertThat((Object)stream.getSystem(), (Matcher)CoreMatchers.is((Object)system));
        MatcherAssert.assertThat((Object)stream.getMajorVersion(), (Matcher)CoreMatchers.is((Object)major));
        MatcherAssert.assertThat((Object)stream.getMinorVersion(), (Matcher)CoreMatchers.is((Object)minor));
        MatcherAssert.assertThat((Object)stream.getCodeName(), (Matcher)CoreMatchers.is((Object)streamCodeName));
        MatcherAssert.assertThat((Object)stream.getMode(), (Matcher)CoreMatchers.is((Object)StreamMode.DEVELOPMENT));
        MatcherAssert.assertThat((Object)stream.getBase(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)stream.getBranchPoint(), (Matcher)CoreMatchers.is((Object)CDOBranchPointRef.MAIN_HEAD));
        MatcherAssert.assertThat((Object)stream, (Matcher)CoreMatchers.is((Object)module.getStream(streamCodeName)));
        MatcherAssert.assertThat((Object)assemblyDescriptor.getSystemDescriptor(), (Matcher)CoreMatchers.is((Object)systemDescriptor));
        MatcherAssert.assertThat((Object)assemblyDescriptor.getName(), (Matcher)CoreMatchers.is((Object)label));
        MatcherAssert.assertThat((Object)assemblyDescriptor.getBaseline(), (Matcher)CoreMatchers.is((Object)stream));
        CDOCheckout checkout = assemblyDescriptor.getCheckout();
        MatcherAssert.assertThat((Object)checkout.isOnline(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)checkout.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)checkout.getLabel(), (Matcher)CoreMatchers.is((Object)label));
        MatcherAssert.assertThat((Object)checkout.getBranchPath(), (Matcher)CoreMatchers.is((Object)"MAIN"));
        MatcherAssert.assertThat((Object)checkout.getTimeStamp(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)checkout.getRepository(), (Matcher)CoreMatchers.is((Object)systemDescriptor.getModuleRepository(moduleName)));
        MatcherAssert.assertThat((Object)checkout.getView().getViewSet().getViews().length, (Matcher)CoreMatchers.is((Object)1));
        Assembly assembly = assemblyDescriptor.getAssembly();
        MatcherAssert.assertThat((Object)assembly.getSystemName(), (Matcher)CoreMatchers.is((Object)SYSTEM_NAME));
        MatcherAssert.assertThat((Object)assembly.getModules().size(), (Matcher)CoreMatchers.is((Object)1));
        AssemblyModule assemblyModule = (AssemblyModule)assembly.getModules().get(0);
        MatcherAssert.assertThat((Object)assemblyModule.getName(), (Matcher)CoreMatchers.is((Object)moduleName));
        MatcherAssert.assertThat((Object)assemblyModule.getBranchPoint(), (Matcher)CoreMatchers.is((Object)CDOBranchPointRef.MAIN_HEAD));
        systemDescriptor.withModuleSession(moduleName, session -> {
            CDOView view = session.openView();
            CDOResource resource = view.getResource(MODULE_DEFINITION_PATH);
            ModuleDefinition moduleDefinition = (ModuleDefinition)resource.getContents().get(0);
            MatcherAssert.assertThat((Object)moduleDefinition.getName(), (Matcher)CoreMatchers.is((Object)moduleName));
            MatcherAssert.assertThat((Object)moduleDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)Version.createOSGi((int)major, (int)minor, (int)0)));
            MatcherAssert.assertThat((Object)moduleDefinition.getDependencies().size(), (Matcher)CoreMatchers.is((Object)0));
        });
        return new ModuleCreationResult(module, stream, assemblyDescriptor);
    }

    protected void setModuleVersion(Stream stream1_0, String moduleName, int major, int minor, int micro) throws Exception {
        IAssemblyDescriptor stream1_0Descriptor = IAssemblyManager.INSTANCE.createDescriptor("Checkout - Stream 1.0", (Baseline)stream1_0, AbstractLMTest.monitor());
        this.editStream(stream1_0Descriptor, transaction -> {
            CDOResource moduleDefinitionResource = transaction.getResource(MODULE_DEFINITION_PATH);
            EObject rootObject = (EObject)moduleDefinitionResource.getContents().get(0);
            MatcherAssert.assertThat((Object)rootObject, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)rootObject, (Matcher)CoreMatchers.instanceOf(ModuleDefinition.class));
            if (rootObject instanceof ModuleDefinition) {
                ModuleDefinition moduleDefinition = (ModuleDefinition)rootObject;
                MatcherAssert.assertThat((Object)moduleDefinition.getName(), (Matcher)CoreMatchers.is((Object)moduleName));
                moduleDefinition.setVersion(Version.createOSGi((int)major, (int)minor, (int)micro));
            }
        });
    }

    protected Change createChange(ISystemDescriptor systemDescriptor, Stream stream, String changeLabel, String changeDescriptorLabel, Consumer<CDOTransaction> editFunction) throws Exception {
        Change change = systemDescriptor.createChange(stream, null, changeLabel, AbstractLMTest.monitor());
        IAssemblyDescriptor change1Descriptor = IAssemblyManager.INSTANCE.createDescriptor(changeDescriptorLabel, (Baseline)change, AbstractLMTest.monitor());
        CDOCheckout checkout = change1Descriptor.getCheckout();
        MatcherAssert.assertThat((Object)checkout.getView().getViewSet().getViews().length, (Matcher)CoreMatchers.is((Object)1));
        CDOTransaction transaction = checkout.openTransaction();
        editFunction.accept(transaction);
        transaction.commit();
        transaction.close();
        checkout.delete(true);
        return change;
    }

    protected void editStream(IAssemblyDescriptor streamDescriptor, Consumer<CDOTransaction> editFunction) throws Exception {
        CDOTransaction transaction = streamDescriptor.getCheckout().openTransaction();
        editFunction.accept(transaction);
        transaction.commit();
        transaction.close();
    }

    protected Delivery deliverChange(ISystemDescriptor systemDescriptor, Stream stream, Change change) throws Exception {
        return systemDescriptor.createDelivery(stream, change, LMMerger.CORE, AbstractLMTest.monitor());
    }

    protected void removeDependencies(IAssemblyDescriptor clientStreamDescriptor) throws Exception {
        CDOCheckout checkout = clientStreamDescriptor.getCheckout();
        CDOTransaction transaction = checkout.openTransaction();
        CDOResource resource = transaction.getResource(MODULE_DEFINITION_PATH);
        ModuleDefinition moduleDefinition = (ModuleDefinition)resource.getContents().get(0);
        moduleDefinition.getDependencies().clear();
        transaction.commit();
        IAssemblyDescriptor.Updates updates = AbstractLMTest.waitForUpdates(clientStreamDescriptor);
        MatcherAssert.assertThat((Object)updates.getAdditions().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)updates.getModifications().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)updates.getRemovals().size(), (Matcher)CoreMatchers.is((Object)1));
        CDOView[] views = transaction.getViewSet().getViews();
        MatcherAssert.assertThat((Object)views.length, (Matcher)CoreMatchers.is((Object)2));
        clientStreamDescriptor.update();
        views = transaction.getViewSet().getViews();
        MatcherAssert.assertThat((Object)views.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)views[0], (Matcher)CoreMatchers.is((Object)transaction));
        transaction.close();
    }

    protected long publishDrop(ISystemDescriptor systemDescriptor, org.eclipse.emf.cdo.lm.System system, Stream stream, String name, String type) throws Exception {
        long timeStamp = System.currentTimeMillis();
        DropType dropType = system.getProcess().getDropType(type);
        Drop drop = systemDescriptor.createDrop(stream, dropType, timeStamp, name, AbstractLMTest.monitor());
        MatcherAssert.assertThat((Object)drop.getBranchPoint().getTimeStamp(), (Matcher)CoreMatchers.is((Object)timeStamp));
        return timeStamp;
    }

    protected long publishRelease(ISystemDescriptor systemDescriptor, org.eclipse.emf.cdo.lm.System system, Stream stream, String releaseName) throws Exception {
        return this.publishDrop(systemDescriptor, system, stream, releaseName, "Release");
    }

    protected long publishTag(ISystemDescriptor systemDescriptor, org.eclipse.emf.cdo.lm.System system, Stream stream, String tagName) throws Exception {
        return this.publishDrop(systemDescriptor, system, stream, tagName, "Tag");
    }

    protected void publishTagUpdateClientAndCheckUri(ISystemDescriptor systemDescriptor, org.eclipse.emf.cdo.lm.System system, Stream supplierStream, IAssemblyDescriptor clientStreamDescriptor, URI uri) throws Exception {
        MatcherAssert.assertThat((Object)clientStreamDescriptor.hasUpdatesAvailable(), (Matcher)CoreMatchers.is((Object)false));
        CDOCheckout checkout = clientStreamDescriptor.getCheckout();
        CDOView view = checkout.openView();
        ResourceSet resourceSet = view.getResourceSet();
        try {
            resourceSet.getResource(uri, true);
            AbstractLMTest.fail((String)"InvalidURIException expected");
        }
        catch (InvalidURIException invalidURIException) {
            // empty catch block
        }
        long timeStamp = this.publishTag(systemDescriptor, system, supplierStream, "TagName");
        IAssemblyDescriptor.Updates updates = AbstractLMTest.waitForUpdates(clientStreamDescriptor);
        MatcherAssert.assertThat((Object)updates.getAdditions().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)updates.getModifications().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)updates.getRemovals().size(), (Matcher)CoreMatchers.is((Object)0));
        clientStreamDescriptor.update();
        CDOResource resource = (CDOResource)resourceSet.getResource(uri, true);
        MatcherAssert.assertThat((Object)resource, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)resource.cdoView().getTimeStamp(), (Matcher)CoreMatchers.is((Object)timeStamp));
        view.close();
    }

    protected void updateAssemblyDescriptor(IAssemblyDescriptor assemblyDescriptor) throws Exception {
        AbstractLMTest.waitForUpdates(assemblyDescriptor);
        assemblyDescriptor.update();
    }

    protected void updateDependency(IAssemblyDescriptor clientStreamDescriptor, String supplierName, VersionRange newVersionRange) throws Exception {
        CDOCheckout checkout = clientStreamDescriptor.getCheckout();
        CDOTransaction transaction = checkout.openTransaction();
        CDOResource resource = transaction.getResource(MODULE_DEFINITION_PATH);
        ModuleDefinition moduleDefinition = (ModuleDefinition)resource.getContents().get(0);
        List dependencies = moduleDefinition.getDependencies().stream().filter(dependencyDefinition -> dependencyDefinition.getTargetName().equals(supplierName)).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)dependencies.size(), (Matcher)CoreMatchers.is((Object)1));
        ((DependencyDefinition)dependencies.get(0)).setVersionRange(newVersionRange);
        transaction.commit();
    }

    protected void createDependency(IAssemblyDescriptor clientStreamDescriptor, String supplierName, VersionRange versionRange) throws Exception {
        CDOCheckout checkout = clientStreamDescriptor.getCheckout();
        CDOTransaction transaction = checkout.openTransaction();
        CDOResource resource = transaction.getResource(MODULE_DEFINITION_PATH);
        ModuleDefinition moduleDefinition = (ModuleDefinition)resource.getContents().get(0);
        moduleDefinition.getDependencies().add((Object)ModulesFactory.eINSTANCE.createDependencyDefinition(supplierName, versionRange));
        transaction.commit();
        transaction.close();
    }

    protected void createDependencyAndUpdate(IAssemblyDescriptor clientStreamDescriptor, String supplierName, VersionRange versionRange) throws Exception {
        CDOCheckout checkout = clientStreamDescriptor.getCheckout();
        this.createDependency(clientStreamDescriptor, supplierName, versionRange);
        CDOTransaction transaction = checkout.openTransaction();
        IAssemblyDescriptor.Updates updates = AbstractLMTest.waitForUpdates(clientStreamDescriptor);
        MatcherAssert.assertThat((Object)((AssemblyModule)updates.getAdditions().get(supplierName)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)updates.getModifications().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)updates.getRemovals().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)checkout.getView().getViewSet().getViews().length, (Matcher)CoreMatchers.is((Object)1));
        CDOView[] views = transaction.getViewSet().getViews();
        MatcherAssert.assertThat((Object)views.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)views[0], (Matcher)CoreMatchers.is((Object)transaction));
        clientStreamDescriptor.update();
        views = transaction.getViewSet().getViews();
        MatcherAssert.assertThat((Object)views.length, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)views[0], (Matcher)CoreMatchers.is((Object)transaction));
        MatcherAssert.assertThat((Object)views[1].isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)checkout.getView().getViewSet().getViews().length, (Matcher)CoreMatchers.is((Object)2));
        transaction.close();
    }

    protected void createDependencyAndUpdate(IAssemblyDescriptor clientStreamDescriptor, String supplierName) throws Exception {
        this.createDependencyAndUpdate(clientStreamDescriptor, supplierName, null);
    }

    protected static URI createModuleResourceURI(String moduleName, String resourcePath) {
        return URI.createURI((String)("cdo.lm://System2022:" + moduleName + "/" + resourcePath));
    }

    protected static ISystemDescriptor createSystemRepository() {
        Properties props = new Properties();
        props.put("type", "remote");
        props.put("name", SYSTEM_NAME);
        props.put("label", SYSTEM_NAME);
        props.put("connectorType", "jvm");
        props.put("connectorDescription", ACCEPTOR_NAME);
        CDORepositoryManager repositoryManager = CDOExplorerUtil.getRepositoryManager();
        CDORepository repository = repositoryManager.addRepository(props);
        repository.connect();
        ISystemDescriptor systemDescriptor = ISystemManager.INSTANCE.getDescriptor(SYSTEM_NAME, 5000L);
        systemDescriptor.open();
        return systemDescriptor;
    }

    protected static IAssemblyDescriptor.Updates waitForUpdates(IAssemblyDescriptor assemblyDescriptor) throws InterruptedException {
        long end = AbstractLMTest.millis() + 10000L;
        while (!assemblyDescriptor.hasUpdatesAvailable()) {
            if (AbstractLMTest.millis() > end) {
                throw new InterruptedException();
            }
            Thread.sleep(10L);
        }
        return assemblyDescriptor.getAvailableUpdates();
    }

    public static IProgressMonitor monitor() {
        return new NullProgressMonitor();
    }

    public static void msg(String ... messages) {
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            System.out.println(message);
            ++n2;
        }
    }

    public static long millis() {
        return System.currentTimeMillis();
    }

    public static final class ModuleCreationResult {
        public final Module module;
        public final Stream stream;
        public final IAssemblyDescriptor assemblyDescriptor;

        public ModuleCreationResult(Module module, Stream stream, IAssemblyDescriptor assemblyDescriptor) {
            this.module = module;
            this.stream = stream;
            this.assemblyDescriptor = assemblyDescriptor;
        }
    }
}

