/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.embedded;

import java.io.File;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.embedded.CDOEmbeddedRepositoryConfig;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.h2.jdbcx.JdbcDataSource;

public class EmbeddedH2Repository
extends CDOEmbeddedRepositoryConfig {
    private final boolean auditing;
    private final boolean branching;
    private final File dbFolder;

    public EmbeddedH2Repository(String repositoryName, boolean auditing, boolean branching, File dbFolder) {
        super(repositoryName);
        this.auditing = auditing;
        this.branching = branching;
        this.dbFolder = dbFolder;
    }

    public boolean isAuditing() {
        return this.auditing;
    }

    public boolean isBranching() {
        return this.branching;
    }

    public File getDBFolder() {
        return this.dbFolder;
    }

    public Connection getJDBCConnection() {
        IDBStore store = (IDBStore)this.getRepository().getStore();
        return store.getConnection();
    }

    public IStore createStore(IManagedContainer container) {
        this.dbFolder.mkdirs();
        IMappingStrategy mappingStrategy = this.createMappingStrategy();
        H2Adapter dbAdapter = this.createDBAdapter();
        JdbcDataSource dataSource = this.createDataSource();
        IDBConnectionProvider dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    protected IMappingStrategy createMappingStrategy() {
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)this.auditing, (boolean)this.branching);
        mappingStrategy.getProperties().put("forceNamesWithID", "true");
        return mappingStrategy;
    }

    protected H2Adapter createDBAdapter() {
        return new H2Adapter();
    }

    protected JdbcDataSource createDataSource() {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + this.dbFolder + "/" + this.getRepositoryName() + ";MVCC=FALSE");
        return dataSource;
    }

    public void initProperties(IManagedContainer container, Map<String, String> properties) {
        properties.put("supportingAudits", Boolean.toString(this.auditing));
        properties.put("supportingBranches", Boolean.toString(this.branching));
    }
}

