/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.depend;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.depend.BasicDependency;
import org.apache.derby.impl.sql.depend.BasicProviderInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BasicDependencyManager
implements DependencyManager {
    private final DataDictionary dd;
    private final Map<UUID, List<Dependency>> dependents = new HashMap<UUID, List<Dependency>>();
    private final Map<UUID, List<Dependency>> providers = new HashMap<UUID, List<Dependency>>();
    private static final ProviderInfo[] EMPTY_PROVIDER_INFO = new ProviderInfo[0];

    @Override
    public void addDependency(Dependent d, Provider p, ContextManager cm) throws StandardException {
        this.addDependency(d, p, cm, null);
    }

    private void addDependency(Dependent d, Provider p, ContextManager cm, TransactionController tc) throws StandardException {
        if (!d.isPersistent() || !p.isPersistent()) {
            this.addInMemoryDependency(d, p, cm);
        } else {
            this.addStoredDependency(d, p, cm, tc);
        }
    }

    private synchronized void addInMemoryDependency(Dependent d, Provider p, ContextManager cm) throws StandardException {
        boolean addedToDeps;
        BasicDependency dy = new BasicDependency(d, p);
        boolean addedToProvs = false;
        addedToProvs = (addedToDeps = this.addDependencyToTable(this.dependents, d.getObjectID(), dy)) ? this.addDependencyToTable(this.providers, p.getObjectID(), dy) : this.addDependencyToTable(this.providers, p.getObjectID(), dy);
        if (addedToDeps != addedToProvs) {
            SanityManager.THROWASSERT("addedToDeps (" + addedToDeps + ") and addedToProvs (" + addedToProvs + ") are expected to agree");
        }
        StatementContext sc = (StatementContext)cm.getContext("StatementContext");
        sc.addDependency(dy);
    }

    private void addStoredDependency(Dependent d, Provider p, ContextManager cm, TransactionController tc) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext(cm);
        TransactionController tcToUse = tc == null ? lcc.getTransactionExecute() : tc;
        this.dd.addDescriptor(new DependencyDescriptor(d, p), null, 6, true, tcToUse);
    }

    private void dropDependency(LanguageConnectionContext lcc, Dependent d, Provider p) throws StandardException {
        if (!d.isPersistent() || !p.isPersistent()) {
            SanityManager.NOTREACHED();
        }
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(d, p);
        this.dd.dropStoredDependency(dependencyDescriptor, lcc.getTransactionExecute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateFor(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        if (p.isPersistent()) {
            this.coreInvalidateFor(p, action, lcc);
        } else {
            BasicDependencyManager basicDependencyManager = this;
            synchronized (basicDependencyManager) {
                this.coreInvalidateFor(p, action, lcc);
            }
        }
    }

    private void coreInvalidateFor(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        List<Dependency> list = this.getDependents(p);
        if (list.isEmpty()) {
            return;
        }
        FormatableBitSet affectedCols = null;
        FormatableBitSet subsetCols = null;
        if (p instanceof TableDescriptor && (affectedCols = ((TableDescriptor)p).getReferencedColumnMap()) != null) {
            subsetCols = new FormatableBitSet(affectedCols.getLength());
        }
        StandardException noInvalidate = null;
        for (int ei = list.size() - 1; ei >= 0; --ei) {
            if (ei >= list.size()) continue;
            Dependency dependency = list.get(ei);
            Dependent dep = dependency.getDependent();
            if (affectedCols != null) {
                TableDescriptor td = (TableDescriptor)dependency.getProvider();
                FormatableBitSet providingCols = td.getReferencedColumnMap();
                if (providingCols == null) {
                    if (dep instanceof ViewDescriptor) {
                        SanityManager.THROWASSERT("Expected view to have referenced column bitmap");
                    } else {
                        ((TableDescriptor)p).setReferencedColumnMap(null);
                    }
                } else {
                    subsetCols.copyFrom(affectedCols);
                    subsetCols.and(providingCols);
                    if (subsetCols.anySetBit() == -1) continue;
                    ((TableDescriptor)p).setReferencedColumnMap(subsetCols);
                }
            }
            try {
                dep.prepareToInvalidate(p, action, lcc);
            }
            catch (StandardException sqle) {
                if (noInvalidate == null) {
                    noInvalidate = sqle;
                }
                try {
                    sqle.initCause(noInvalidate);
                    noInvalidate = sqle;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (noInvalidate != null) continue;
            if (affectedCols != null) {
                ((TableDescriptor)p).setReferencedColumnMap(affectedCols);
            }
            dep.makeInvalid(action, lcc);
        }
        if (noInvalidate != null) {
            throw noInvalidate;
        }
    }

    @Override
    public void clearDependencies(LanguageConnectionContext lcc, Dependent d) throws StandardException {
        this.clearDependencies(lcc, d, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDependencies(LanguageConnectionContext lcc, Dependent d, TransactionController tc) throws StandardException {
        UUID id = d.getObjectID();
        if (d.isPersistent()) {
            boolean wait = tc == null;
            this.dd.dropDependentsStoredDependencies(id, wait ? lcc.getTransactionExecute() : tc, wait);
        }
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List<Dependency> deps = this.dependents.get(id);
            if (deps != null) {
                for (Dependency dy : deps) {
                    this.clearProviderDependency(dy.getProviderKey(), dy);
                }
                this.dependents.remove(id);
            }
        }
    }

    @Override
    public synchronized void clearInMemoryDependency(Dependency dy) {
        UUID deptId = dy.getDependent().getObjectID();
        UUID provId = dy.getProviderKey();
        List<Dependency> deps = this.dependents.get(deptId);
        List<Dependency> provs = this.providers.get(provId);
        if (deps != null || provs != null) {
            int depCount = 0;
            if (deps != null) {
                for (int ci = 0; ci < deps.size(); ++ci) {
                    if (!dy.equals(deps.get(ci))) continue;
                    ++depCount;
                }
            }
            int provCount = 0;
            if (provs != null) {
                for (int ci = 0; ci < provs.size(); ++ci) {
                    if (!dy.equals(provs.get(ci))) continue;
                    ++provCount;
                }
            }
            SanityManager.ASSERT(depCount == provCount, "Dependency count mismatch count in deps: " + depCount + ", count in provs " + provCount + ", dy.getDependent().getObjectID() = " + deptId + ", dy.getProvider().getObjectID() = " + provId);
        }
        if (deps == null) {
            return;
        }
        if (provs == null) {
            return;
        }
        deps.remove(dy);
        if (deps.isEmpty()) {
            this.dependents.remove(deptId);
        }
        provs.remove(dy);
        if (provs.isEmpty()) {
            this.providers.remove(provId);
        }
    }

    @Override
    public ProviderInfo[] getPersistentProviderInfos(Dependent dependent) throws StandardException {
        List<Provider> provs = this.getProviders(dependent);
        if (provs.isEmpty()) {
            return EMPTY_PROVIDER_INFO;
        }
        ArrayList<BasicProviderInfo> pih = new ArrayList<BasicProviderInfo>();
        for (Provider p : provs) {
            if (!p.isPersistent()) continue;
            pih.add(new BasicProviderInfo(p.getObjectID(), p.getDependableFinder(), p.getObjectName()));
        }
        return pih.toArray(EMPTY_PROVIDER_INFO);
    }

    @Override
    public ProviderInfo[] getPersistentProviderInfos(ProviderList pl) throws StandardException {
        Enumeration e = pl.elements();
        int numProviders = 0;
        while (e != null && e.hasMoreElements()) {
            Provider prov = (Provider)e.nextElement();
            if (!prov.isPersistent()) continue;
            ++numProviders;
        }
        e = pl.elements();
        ProviderInfo[] retval = new ProviderInfo[numProviders];
        int piCtr = 0;
        while (e != null && e.hasMoreElements()) {
            Provider prov = (Provider)e.nextElement();
            if (!prov.isPersistent()) continue;
            retval[piCtr++] = new BasicProviderInfo(prov.getObjectID(), prov.getDependableFinder(), prov.getObjectName());
        }
        return retval;
    }

    @Override
    public void clearColumnInfoInProviders(ProviderList pl) throws StandardException {
        Enumeration e = pl.elements();
        while (e.hasMoreElements()) {
            Provider pro = (Provider)e.nextElement();
            if (!(pro instanceof TableDescriptor)) continue;
            ((TableDescriptor)pro).setReferencedColumnMap(null);
        }
    }

    @Override
    public void copyDependencies(Dependent copy_From, Dependent copyTo, boolean persistentOnly, ContextManager cm) throws StandardException {
        this.copyDependencies(copy_From, copyTo, persistentOnly, cm, null);
    }

    @Override
    public void copyDependencies(Dependent copy_From, Dependent copyTo, boolean persistentOnly, ContextManager cm, TransactionController tc) throws StandardException {
        List<Provider> list = this.getProviders(copy_From);
        for (Provider provider : list) {
            if (persistentOnly && !provider.isPersistent()) continue;
            this.addDependency(copyTo, provider, cm, tc);
        }
    }

    @Override
    public String getActionString(int action) {
        switch (action) {
            case 12: {
                return "ALTER TABLE";
            }
            case 34: {
                return "RENAME";
            }
            case 41: {
                return "RENAME INDEX";
            }
            case 0: {
                return "COMPILE FAILED";
            }
            case 1: {
                return "DROP TABLE";
            }
            case 2: {
                return "DROP INDEX";
            }
            case 9: {
                return "DROP VIEW";
            }
            case 3: {
                return "CREATE INDEX";
            }
            case 4: {
                return "ROLLBACK";
            }
            case 5: {
                return "CHANGED CURSOR";
            }
            case 22: {
                return "CREATE CONSTRAINT";
            }
            case 19: {
                return "DROP CONSTRAINT";
            }
            case 6: {
                return "DROP ROUTINE";
            }
            case 11: {
                return "PREPARED STATEMENT RELEASE";
            }
            case 13: {
                return "DROP STORED PREPARED STATEMENT";
            }
            case 14: {
                return "USER REQUESTED INVALIDATION";
            }
            case 15: {
                return "BULK INSERT";
            }
            case 10: {
                return "CREATE_VIEW";
            }
            case 17: {
                return "DROP_JAR";
            }
            case 18: {
                return "REPLACE_JAR";
            }
            case 20: {
                return "SET_CONSTRAINTS_ENABLE";
            }
            case 21: {
                return "SET_CONSTRAINTS_DISABLE";
            }
            case 23: {
                return "INTERNAL RECOMPILE REQUEST";
            }
            case 28: {
                return "CREATE TRIGGER";
            }
            case 27: {
                return "DROP TRIGGER";
            }
            case 29: {
                return "SET TRIGGERS ENABLED";
            }
            case 30: {
                return "SET TRIGGERS DISABLED";
            }
            case 31: {
                return "MODIFY COLUMN DEFAULT";
            }
            case 33: {
                return "COMPRESS TABLE";
            }
            case 37: {
                return "DROP COLUMN";
            }
            case 46: {
                return "DROP COLUMN RESTRICT";
            }
            case 39: {
                return "DROP STATISTICS";
            }
            case 40: {
                return "UPDATE STATISTICS";
            }
            case 42: {
                return "TRUNCATE TABLE";
            }
            case 43: {
                return "DROP SYNONYM";
            }
            case 44: {
                return "REVOKE PRIVILEGE";
            }
            case 45: {
                return "REVOKE PRIVILEGE RESTRICT";
            }
            case 47: {
                return "REVOKE ROLE";
            }
            case 48: {
                return "RECHECK PRIVILEGES";
            }
            case 49: {
                return "DROP SEQUENCE";
            }
            case 50: {
                return "DROP TYPE";
            }
            case 51: {
                return "DROP DERBY AGGREGATE";
            }
        }
        SanityManager.THROWASSERT("getActionString() passed an invalid value (" + action + ")");
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countDependencies() throws StandardException {
        List<TupleDescriptor> storedDeps = this.dd.getAllDependencyDescriptorsList();
        int numDependencies = storedDeps.size();
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            Iterator<List<Dependency>> deps = this.dependents.values().iterator();
            Iterator<List<Dependency>> provs = this.providers.values().iterator();
            while (deps.hasNext()) {
                numDependencies += deps.next().size();
            }
            while (provs.hasNext()) {
                numDependencies += provs.next().size();
            }
        }
        return numDependencies;
    }

    public BasicDependencyManager(DataDictionary dd) {
        this.dd = dd;
    }

    private boolean addDependencyToTable(Map<UUID, List<Dependency>> table, UUID key, Dependency dy) {
        List<Dependency> deps = table.get(key);
        if (deps == null) {
            deps = new ArrayList<Dependency>();
            deps.add(dy);
            table.put(key, deps);
        } else {
            UUID provKey = dy.getProvider().getObjectID();
            UUID depKey = dy.getDependent().getObjectID();
            ListIterator<Dependency> depsIT = deps.listIterator();
            while (depsIT.hasNext()) {
                Dependency curDY = depsIT.next();
                if (curDY.getProvider().getObjectID() == null || !curDY.getProvider().getObjectID().equals(provKey) || !curDY.getDependent().getObjectID().equals(depKey)) continue;
                return false;
            }
            deps.add(dy);
        }
        if (SanityManager.DEBUG_ON("memoryLeakTrace")) {
            if (table.size() > 100) {
                System.out.println("memoryLeakTrace:BasicDependencyManager:table " + table.size());
            }
            if (deps.size() > 50) {
                System.out.println("memoryLeakTrace:BasicDependencyManager:deps " + deps.size());
            }
        }
        return true;
    }

    private void clearProviderDependency(UUID p, Dependency d) {
        List<Dependency> deps = this.providers.get(p);
        if (deps == null) {
            return;
        }
        deps.remove(d);
        if (deps.isEmpty()) {
            this.providers.remove(p);
        }
    }

    private List<Dependency> getDependencyDescriptorList(List<DependencyDescriptor> storedList, Provider providerForList) throws StandardException {
        ArrayList<Dependency> retval = new ArrayList<Dependency>();
        if (!storedList.isEmpty()) {
            for (DependencyDescriptor depDesc : storedList) {
                Provider tempP;
                DependableFinder finder = depDesc.getDependentFinder();
                Dependent tempD = (Dependent)finder.getDependable(this.dd, depDesc.getUUID());
                if (providerForList != null) {
                    tempP = providerForList;
                    if (!tempP.getObjectID().equals(depDesc.getProviderID())) {
                        SanityManager.THROWASSERT("mismatch providers");
                    }
                } else {
                    finder = depDesc.getProviderFinder();
                    tempP = (Provider)finder.getDependable(this.dd, depDesc.getProviderID());
                }
                retval.add(new BasicDependency(tempD, tempP));
            }
        }
        return retval;
    }

    private LanguageConnectionContext getLanguageConnectionContext(ContextManager cm) {
        return (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Provider> getProviders(Dependent d) throws StandardException {
        ArrayList<Provider> provs = new ArrayList<Provider>();
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List<Dependency> deps = this.dependents.get(d.getObjectID());
            if (deps != null) {
                Iterator<Dependency> depsIter = deps.iterator();
                while (depsIter.hasNext()) {
                    provs.add(depsIter.next().getProvider());
                }
            }
        }
        if (d.isPersistent()) {
            List<Dependency> storedList = this.getDependencyDescriptorList(this.dd.getDependentsDescriptorList(d.getObjectID().toString()), null);
            Iterator<Dependency> depIter = storedList.iterator();
            while (depIter.hasNext()) {
                provs.add(depIter.next().getProvider());
            }
        }
        return provs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getDependents(Provider p) throws StandardException {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List<Dependency> memDeps = this.providers.get(p.getObjectID());
            if (memDeps != null) {
                deps.addAll(memDeps);
            }
        }
        if (p.isPersistent()) {
            List<Dependency> storedList = this.getDependencyDescriptorList(this.dd.getProvidersDescriptorList(p.getObjectID().toString()), p);
            deps.addAll(storedList);
        }
        return deps;
    }
}

