/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.server.bundle.CDOServerApplication;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.CDOServerImporter;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

public class CDOCommandProvider
implements CommandProvider {
    private static final String NEW_LINE = "\r\n";
    private static final CDOCommand list = new CDOCommand("list", "list all active repositories"){

        @Override
        public void execute(String[] args) throws Exception {
            IManagedContainer container = CDOServerApplication.getContainer();
            Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof InternalRepository) {
                    InternalRepository repository = (InternalRepository)element;
                    this.println(repository.getName());
                }
                ++n2;
            }
        }
    };
    private static final CDOCommand start = new CDOCommand("start", "start repositories from a config file", new CDOCommand.CommandParameter[]{CDOCommand.parameter("config-file")}){

        @Override
        public void execute(String[] args) throws Exception {
            String configFile = args[0];
            IManagedContainer container = CDOServerApplication.getContainer();
            RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator(container);
            IRepository[] repositories = repositoryConfigurator.configure(new File(configFile));
            this.println("Repositories started:");
            if (repositories != null) {
                IRepository[] iRepositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    IRepository repository = iRepositoryArray[n2];
                    this.println(repository.getName());
                    ++n2;
                }
            }
        }
    };
    private static final CDOCommand stop = new CDOCommand.WithRepository("stop", "stop a repository"){

        @Override
        public void execute(InternalRepository repository, String[] args) throws Exception {
            LifecycleUtil.deactivate((Object)repository);
            this.println("Repository stopped");
        }
    };
    private static final CDOCommand exportFile = new CDOCommand.WithRepository("export", "export the contents of a repository to a file", new CDOCommand.CommandParameter[]{CDOCommand.parameter("export-file"), CDOCommand.optional("xml|bin").literal(), CDOCommand.optional("/<branch-path>").literal(), CDOCommand.optional("time-stamp"), CDOCommand.optional("withSystemPackages").literal()}){

        @Override
        public void execute(InternalRepository repository, String[] args) throws Exception {
            String exportFile = args[0];
            boolean binary = false;
            boolean withSystemPackages = false;
            String branchPath = null;
            Long timeStamp = null;
            int i = 1;
            while (i < args.length) {
                String arg = args[i];
                if (arg != null) {
                    if (arg.equalsIgnoreCase("bin")) {
                        binary = true;
                    } else if (arg.equalsIgnoreCase("withSystemPackages")) {
                        withSystemPackages = true;
                    } else if (arg.startsWith("/")) {
                        branchPath = arg;
                    } else {
                        try {
                            timeStamp = Long.valueOf(arg);
                        }
                        catch (NumberFormatException ex) {
                            timeStamp = null;
                        }
                    }
                }
                ++i;
            }
            FileOutputStream out = null;
            try {
                CDOServerExporter exporter;
                out = new FileOutputStream(exportFile);
                CDOServerExporter cDOServerExporter = exporter = binary ? new CDOServerExporter.Binary(repository) : new CDOServerExporter.XML(repository);
                if (branchPath != null) {
                    exporter.setBranchPath(branchPath);
                }
                if (timeStamp != null) {
                    exporter.setTimeStamp(timeStamp);
                }
                if (withSystemPackages) {
                    exporter.setExportSystemPackages(true);
                }
                exporter.exportRepository(out);
                this.println("Repository exported.");
                exporter.getStatistics().dumpStrings(line -> this.println(line));
                this.println("Took " + this.duration());
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
            IOUtil.close((Closeable)out);
        }
    };
    private static final CDOCommand importFile = new CDOCommand.WithRepository("import", "import the contents of a repository from a file", new CDOCommand.CommandParameter[]{CDOCommand.parameter("import-file"), CDOCommand.optional("xml|bin").literal()}){

        @Override
        public void execute(InternalRepository repository, String[] args) throws Exception {
            String importFile = args[0];
            boolean binary = "bin".equalsIgnoreCase(args[1]);
            FileInputStream in = null;
            try {
                in = new FileInputStream(importFile);
                LifecycleUtil.deactivate((Object)repository);
                CDOServerImporter importer = binary ? new CDOServerImporter.Binary(repository) : new CDOServerImporter.XML(repository);
                importer.importRepository(in);
                IManagedContainer container = CDOServerApplication.getContainer();
                CDOServerUtil.addRepository(container, repository);
                this.println("Repository imported.");
                importer.getStatistics().dumpStrings(line -> this.println(line));
                this.println("Took " + this.duration());
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close((Closeable)in);
        }
    };
    private static final CDOCommand branches = new CDOCommand.WithRepository("branches", "list the branches of a repository"){

        @Override
        public void execute(InternalRepository repository, String[] args) throws Exception {
            this.branches(repository.getBranchManager().getMainBranch(), "");
        }

        private void branches(InternalCDOBranch branch, String prefix) {
            this.println(String.valueOf(prefix) + branch);
            prefix = String.valueOf(prefix) + "   ";
            InternalCDOBranch[] internalCDOBranchArray = branch.getBranches();
            int n = internalCDOBranchArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOBranch child = internalCDOBranchArray[n2];
                this.branches(child, prefix);
                ++n2;
            }
        }
    };
    private static final CDOCommand packages = new CDOCommand.WithRepository("packages", "list the packages of a repository"){

        @Override
        public void execute(InternalRepository repository, String[] args) throws Exception {
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageRegistry.getPackageUnits();
            int n = internalCDOPackageUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.println(packageUnit);
                InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
                int n3 = internalCDOPackageInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                    this.println("   " + packageInfo);
                    ++n4;
                }
                ++n2;
            }
        }
    };
    private static final CDOCommand sessions = new CDOCommand.WithRepository("sessions", "list the sessions of a repository"){

        @Override
        public void execute(InternalRepository repository, String[] args) throws Exception {
            InternalSessionManager sessionManager = repository.getSessionManager();
            InternalSession[] internalSessionArray = sessionManager.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                this.println(session);
                InternalView[] internalViewArray = session.getViews();
                int n3 = internalViewArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalView view = internalViewArray[n4];
                    this.println("   " + view);
                    ++n4;
                }
                ++n2;
            }
        }
    };
    private static final CDOCommand locks = new CDOCommand.WithAccessor("locks", "list the locks of a repository", new CDOCommand.CommandParameter[]{CDOCommand.optional("username-prefix")}){

        @Override
        public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
            String usernamePrefix = args[0];
            repository.getLockingManager().getLockAreas(usernamePrefix, new IDurableLockingManager.LockArea.Handler(){

                public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                    this.println(area.getDurableLockingID());
                    this.println("   userID = " + area.getUserID());
                    this.println("   branch = " + area.getBranch());
                    this.println("   timeStamp = " + CDOCommonUtil.formatTimeStamp((long)area.getTimeStamp()));
                    this.println("   readOnly = " + area.isReadOnly());
                    this.println("   locks = " + area.getLocks());
                    return true;
                }
            });
        }
    };
    private static final CDOCommand deletelocks = new CDOCommand.WithAccessor("deletelocks", "delete a durable locking area of a repository", new CDOCommand.CommandParameter[]{CDOCommand.parameter("area-id")}){

        @Override
        public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
            String areaID = args[0];
            repository.getLockingManager().deleteLockArea(areaID);
        }
    };

    public CDOCommandProvider(BundleContext bundleContext) {
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _cdo(CommandInterpreter interpreter) {
        try {
            Map<String, CDOCommand> commands = this.getCommands();
            String cmd = interpreter.nextArgument();
            CDOCommand command = commands.get(cmd);
            if (command == null) {
                interpreter.println((Object)this.getHelp());
                return null;
            }
            try {
                command.setInterpreter(interpreter);
                command.execute();
                return null;
            }
            finally {
                command.setInterpreter(null);
            }
        }
        catch (CDOCommand.CommandException ex) {
            interpreter.println((Object)ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("---CDO commands---\r\n");
            ArrayList<CDOCommand> commands = new ArrayList<CDOCommand>(this.getCommands().values());
            Collections.sort(commands, new Comparator<CDOCommand>(){

                @Override
                public int compare(CDOCommand o1, CDOCommand o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (CDOCommand command : commands) {
                try {
                    builder.append("   ");
                    builder.append(command.getSyntax());
                    builder.append(" - ");
                    builder.append(command.getDescription());
                    builder.append(NEW_LINE);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return builder.toString();
    }

    public synchronized Map<String, CDOCommand> getCommands() {
        HashMap<String, CDOCommand> commands = new HashMap<String, CDOCommand>();
        this.addCommand(commands, list);
        this.addCommand(commands, start);
        this.addCommand(commands, stop);
        this.addCommand(commands, exportFile);
        this.addCommand(commands, importFile);
        this.addCommand(commands, branches);
        this.addCommand(commands, deletelocks);
        this.addCommand(commands, locks);
        this.addCommand(commands, packages);
        this.addCommand(commands, sessions);
        try {
            for (String name : IPluginContainer.INSTANCE.getFactoryTypes("org.eclipse.emf.cdo.server.commands")) {
                try {
                    CDOCommand command = this.createCommand(name);
                    this.addCommand(commands, command);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return commands;
    }

    protected CDOCommand createCommand(String name) {
        return (CDOCommand)((Object)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.server.commands", name, null));
    }

    private void addCommand(Map<String, CDOCommand> commands, CDOCommand command) {
        commands.put(command.getName(), command);
    }
}

