/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.ProbingSubMonitor;

public class SubMonitor
implements IProgressMonitorWithBlocking {
    private static final int MINIMUM_RESOLUTION = 1000;
    private int totalParent;
    private int usedForParent = 0;
    private double usedForChildren = 0.0;
    private int totalForChildren;
    private IProgressMonitor lastSubMonitor = null;
    final RootInfo root;
    int flags;
    public static final int DEFAULT_WORK = 1;
    public static final int SUPPRESS_SUBTASK = 1;
    public static final int SUPPRESS_BEGINTASK = 2;
    public static final int SUPPRESS_SETTASKNAME = 4;
    public static final int SUPPRESS_ALL_LABELS = 7;
    public static final int SUPPRESS_NONE = 0;
    private static final int DETECT_CANCELATION = 8;

    SubMonitor(RootInfo rootInfo, int totalWork, int availableToChildren, int flags) {
        this.root = rootInfo;
        this.totalParent = totalWork > 0 ? totalWork : 0;
        this.totalForChildren = availableToChildren;
        this.flags = flags;
    }

    SubMonitor createSubMonitor(RootInfo rootInfo, int totalWork, int availableToChildren, int flags) {
        return new SubMonitor(rootInfo, totalWork, availableToChildren, flags);
    }

    void adjustLocation() {
    }

    public static SubMonitor convert(IProgressMonitor monitor) {
        return SubMonitor.convert(monitor, "", 0, ProbingMode.DEFAULT);
    }

    public static SubMonitor convert(IProgressMonitor monitor, int work) {
        return SubMonitor.convert(monitor, "", work, ProbingMode.DEFAULT);
    }

    public static SubMonitor convert(IProgressMonitor monitor, String taskName, int work) {
        return SubMonitor.convert(monitor, taskName, work, ProbingMode.DEFAULT);
    }

    public static SubMonitor convert(IProgressMonitor monitor, ProbingMode probingMode) {
        return SubMonitor.convert(monitor, "", 0, probingMode);
    }

    public static SubMonitor convert(IProgressMonitor monitor, int work, ProbingMode probingMode) {
        return SubMonitor.convert(monitor, "", work, probingMode);
    }

    public static SubMonitor convert(IProgressMonitor monitor, String taskName, int work, ProbingMode probingMode) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor instanceof SubMonitor) {
            SubMonitor subMonitor = (SubMonitor)monitor;
            subMonitor.beginTask(taskName, work);
            subMonitor.adjustLocation();
            return subMonitor;
        }
        monitor.beginTask(taskName, 1000);
        if (probingMode == ProbingMode.OFF) {
            return new SubMonitor(new RootInfo(monitor), 1000, work, 0);
        }
        return SubMonitor.createProbingSubMonitor(monitor, work, probingMode == ProbingMode.FULL);
    }

    private static SubMonitor createProbingSubMonitor(IProgressMonitor monitor, int availableToChildren, boolean full) {
        ProbingSubMonitor parent = monitor instanceof ProbingSubMonitor ? (ProbingSubMonitor)monitor : null;
        return new ProbingSubMonitor(parent, new RootInfo(monitor), 1000, availableToChildren, 0, full);
    }

    public final SubMonitor detectCancelation() {
        return this.detectCancelation(true);
    }

    public final SubMonitor detectCancelation(boolean on) {
        this.flags = on ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        return this;
    }

    private void checkCancelation() {
        if ((this.flags & 8) != 0 && this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public final SubMonitor setWorkRemaining(int workRemaining) {
        this.checkCancelation();
        workRemaining = Math.max(0, workRemaining);
        if (this.totalForChildren > 0 && this.totalParent > this.usedForParent) {
            double remainForParent = (double)this.totalParent * (1.0 - this.usedForChildren / (double)this.totalForChildren);
            this.usedForChildren = (double)workRemaining * (1.0 - remainForParent / (double)(this.totalParent - this.usedForParent));
        } else {
            this.usedForChildren = 0.0;
        }
        this.totalParent -= this.usedForParent;
        this.usedForParent = 0;
        this.totalForChildren = workRemaining;
        return this;
    }

    private int consume(double ticks) {
        if (this.totalParent == 0 || this.totalForChildren == 0) {
            return 0;
        }
        this.usedForChildren += ticks;
        if (this.usedForChildren > (double)this.totalForChildren) {
            this.usedForChildren = this.totalForChildren;
        } else if (this.usedForChildren < 0.0) {
            this.usedForChildren = 0.0;
        }
        int parentPosition = (int)((double)this.totalParent * this.usedForChildren / (double)this.totalForChildren);
        int delta = parentPosition - this.usedForParent;
        this.usedForParent = parentPosition;
        return delta;
    }

    public final boolean isCanceled() {
        return this.root.isCanceled();
    }

    public final void setTaskName(String name) {
        this.checkCancelation();
        if ((this.flags & 4) == 0) {
            this.root.setTaskName(name);
        }
    }

    public final void beginTask(String name, int totalWork) {
        if ((this.flags & 2) == 0 && name != null) {
            this.root.setTaskName(name);
        }
        this.setWorkRemaining(totalWork);
    }

    public void done() {
        this.cleanupActiveChild();
        int delta = this.totalParent - this.usedForParent;
        if (delta > 0) {
            this.root.worked(delta);
        }
        this.totalParent = 0;
        this.usedForParent = 0;
        this.totalForChildren = 0;
        this.usedForChildren = 0.0;
    }

    public final void internalWorked(double work) {
        this.checkCancelation();
        this.cleanupActiveChild();
        int delta = this.consume(work > 0.0 ? work : 0.0);
        if (delta != 0) {
            this.root.worked(delta);
        }
    }

    public final void subTask(String name) {
        this.checkCancelation();
        if ((this.flags & 1) == 0) {
            this.root.subTask(name);
        }
    }

    public final void worked() {
        this.worked(1);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public final void skipped(int ticks) {
        this.checkCancelation();
        this.setWorkRemaining(this.totalParent - this.usedForParent);
    }

    public final void skipped() {
        this.skipped(1);
    }

    public final void setCanceled(boolean b) {
        this.root.setCanceled(b);
    }

    public final SubMonitor newChild() {
        return this.newChild(1, 2);
    }

    public final SubMonitor newChild(int totalWork) {
        return this.newChild(totalWork, 2);
    }

    public final SubMonitor newChild(int totalWork, int suppressFlags) {
        this.checkCancelation();
        double totalWorkDouble = totalWork > 0 ? (double)totalWork : 0.0;
        totalWorkDouble = Math.min(totalWorkDouble, (double)this.totalForChildren - this.usedForChildren);
        this.cleanupActiveChild();
        int childFlags = 0;
        if ((this.flags & 4) != 0) {
            childFlags |= 6;
        }
        if ((this.flags & 1) != 0) {
            childFlags |= 1;
        }
        SubMonitor result = this.createSubMonitor(this.root, this.consume(totalWorkDouble), (int)totalWorkDouble, childFlags |= suppressFlags);
        this.lastSubMonitor = result;
        return result;
    }

    public void childDone() {
    }

    private void cleanupActiveChild() {
        if (this.lastSubMonitor == null) {
            return;
        }
        IProgressMonitor child = this.lastSubMonitor;
        this.lastSubMonitor = null;
        child.done();
    }

    public final void clearBlocked() {
        this.checkCancelation();
        this.root.clearBlocked();
    }

    public final void setBlocked(IStatus reason) {
        this.checkCancelation();
        this.root.setBlocked(reason);
    }

    protected static boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static enum ProbingMode {
        OFF,
        STANDARD,
        FULL;

        public static final ProbingMode DEFAULT;

        static {
            DEFAULT = ProbingMode.getDefault();
        }

        private static ProbingMode getDefault() {
            String mode = OMPlatform.INSTANCE.getProperty("submonitor.probing");
            if (FULL.toString().equalsIgnoreCase(mode)) {
                return FULL;
            }
            if (STANDARD.toString().equalsIgnoreCase(mode) || StringUtil.isTrue(mode)) {
                return STANDARD;
            }
            return OFF;
        }
    }

    static final class RootInfo {
        private final IProgressMonitor root;
        private String taskName = null;
        private String subTask = null;

        public RootInfo(IProgressMonitor root) {
            this.root = root;
        }

        public IProgressMonitor getRoot() {
            return this.root;
        }

        public boolean isCanceled() {
            return this.root.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.root.setCanceled(value);
        }

        public void setTaskName(String taskName) {
            if (SubMonitor.eq(taskName, this.taskName)) {
                return;
            }
            this.taskName = taskName;
            this.root.setTaskName(taskName);
        }

        public void subTask(String name) {
            if (SubMonitor.eq(this.subTask, name)) {
                return;
            }
            this.subTask = name;
            this.root.subTask(name);
        }

        public void worked(int i) {
            this.root.worked(i);
        }

        public void clearBlocked() {
            if (this.root instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.root).clearBlocked();
            }
        }

        public void setBlocked(IStatus reason) {
            if (this.root instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.root).setBlocked(reason);
            }
        }
    }
}

