/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

public class ChangeTagRequest
extends CDOClientRequest<CDOBranchPoint> {
    private AtomicInteger modCount;
    private String oldName;
    private String newName;
    private CDOBranchPoint branchPoint;

    public ChangeTagRequest(CDOClientProtocol protocol, AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        super(protocol, (short)64);
        this.modCount = modCount;
        this.oldName = oldName;
        this.newName = newName;
        this.branchPoint = branchPoint;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.modCount.get());
        out.writeString(this.oldName);
        out.writeString(this.newName);
        if (this.branchPoint != null) {
            out.writeBoolean(true);
            out.writeCDOBranchPoint(this.branchPoint);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected CDOBranchPoint confirming(CDODataInput in) throws IOException {
        int tagModCount = in.readXInt();
        if (tagModCount != -1) {
            this.modCount.set(tagModCount);
            return in.readCDOBranchPoint();
        }
        return null;
    }
}

