/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.internal.ui.views;

import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.views.IntrospectionProvider;
import org.eclipse.swt.widgets.Event;

public final class MapIntrospectionProvider
extends IntrospectionProvider {
    public MapIntrospectionProvider() {
        super("java.util.Map", "Map");
    }

    @Override
    public void open(Event selectionEvent, Object parent, Object element, Consumer<Object> introspector) {
        if ((selectionEvent.stateMask & 0x40000) != 0) {
            Map map = (Map)parent;
            IntrospectionProvider.NameAndValue nameAndValue = (IntrospectionProvider.NameAndValue)element;
            for (Map.Entry entry : map.entrySet()) {
                if (!new IntrospectionProvider.NameAndValue(entry).equals(nameAndValue)) continue;
                super.open(selectionEvent, parent, new IntrospectionProvider.NameAndValue(nameAndValue.getName(), entry.getKey()), introspector);
                return;
            }
        }
        super.open(selectionEvent, parent, element, introspector);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof Map;
    }

    @Override
    public void createColumns(TableViewer viewer) {
        MapIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_8"), 200);
        MapIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_9"), 400);
        MapIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_10"), 300);
    }

    @Override
    public Object[] getElements(Object parent) throws Exception {
        Map map = (Map)parent;
        Object[] result = new IntrospectionProvider.NameAndValue[map.size()];
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            result[index++] = new IntrospectionProvider.NameAndValue(entry);
        }
        return result;
    }

    @Override
    public Object getElementByName(Object parent, String name) throws Exception {
        Object value = ((Map)parent).get(name);
        if (value != null) {
            return new IntrospectionProvider.NameAndValue(name, value);
        }
        return null;
    }

    @Override
    public IntrospectionProvider.NameAndValue getNameAndValue(Object element) throws Exception {
        return (IntrospectionProvider.NameAndValue)element;
    }

    @Override
    public String getColumnText(Object element, int index) throws Exception {
        IntrospectionProvider.NameAndValue nameAndValue = (IntrospectionProvider.NameAndValue)element;
        switch (index) {
            case 0: {
                return nameAndValue.getName();
            }
            case 1: {
                return MapIntrospectionProvider.formatValue(nameAndValue.getValue());
            }
            case 2: {
                return MapIntrospectionProvider.getClassName(nameAndValue.getValue());
            }
        }
        return null;
    }

    @Override
    public ViewerComparator getComparator() {
        return new ViewerComparator();
    }
}

