/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportBlob;
import org.apache.derby.impl.load.ImportClob;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

final class ImportReadData
implements PrivilegedExceptionAction<Object> {
    private String inputFileName;
    private int[] columnWidths;
    private int rowWidth;
    private char[] tempString;
    private int numberOfCharsReadSoFar;
    private BufferedReader bufferedReader;
    private static final int START_SIZE = 10240;
    private char[] currentToken = new char[10240];
    private int currentTokenMaxSize = 10240;
    boolean foundStartDelimiter;
    int totalCharsSoFar;
    int positionOfNonWhiteSpaceCharInFront;
    int positionOfNonWhiteSpaceCharInBack;
    int lineNumber;
    int fieldStartDelimiterIndex;
    int fieldStopDelimiterIndex;
    int stopDelimiterPosition;
    boolean foundStartAndStopDelimiters;
    boolean streamOpenForReading;
    static final int DEFAULT_FORMAT_CODE = 0;
    static final int ASCII_FIXED_FORMAT_CODE = 1;
    private int formatCode = 0;
    private boolean hasColumnDefinition;
    private char recordSeparatorChar0;
    private char fieldSeparatorChar0;
    private boolean recordSepStartNotWhite = true;
    private boolean fieldSepStartNotWhite = true;
    protected ControlInfo controlFileReader;
    protected int numberOfColumns;
    protected String[] columnTypes;
    protected char[] fieldSeparator;
    protected int fieldSeparatorLength;
    protected char[] recordSeparator;
    protected int recordSeparatorLength;
    protected String nullString;
    protected String columnDefinition;
    protected String format;
    protected String dataCodeset;
    protected char[] fieldStartDelimiter;
    protected int fieldStartDelimiterLength;
    protected char[] fieldStopDelimiter;
    protected int fieldStopDelimiterLength;
    protected boolean hasDelimiterAtEnd;
    private ImportLobFile[] lobFileHandles;
    private String lobFileName;
    private int lobOffset;
    private int lobLength;
    private boolean haveSep = true;

    private void loadPropertiesInfo() throws Exception {
        this.fieldSeparator = this.controlFileReader.getFieldSeparator().toCharArray();
        this.fieldSeparatorLength = this.fieldSeparator.length;
        this.recordSeparator = this.controlFileReader.getRecordSeparator().toCharArray();
        this.recordSeparatorLength = this.recordSeparator.length;
        this.nullString = this.controlFileReader.getNullString();
        this.columnDefinition = this.controlFileReader.getColumnDefinition();
        this.format = this.controlFileReader.getFormat();
        this.dataCodeset = this.controlFileReader.getDataCodeset();
        this.fieldStartDelimiter = this.controlFileReader.getFieldStartDelimiter().toCharArray();
        this.fieldStartDelimiterLength = this.fieldStartDelimiter.length;
        this.fieldStopDelimiter = this.controlFileReader.getFieldEndDelimiter().toCharArray();
        this.fieldStopDelimiterLength = this.fieldStopDelimiter.length;
        this.hasDelimiterAtEnd = this.controlFileReader.getHasDelimiterAtEnd();
        if (this.recordSeparatorLength > 0) {
            this.recordSeparatorChar0 = this.recordSeparator[0];
            boolean bl = this.recordSepStartNotWhite = !Character.isWhitespace(this.recordSeparatorChar0);
        }
        if (this.fieldSeparatorLength > 0) {
            this.fieldSeparatorChar0 = this.fieldSeparator[0];
            this.fieldSepStartNotWhite = !Character.isWhitespace(this.fieldSeparatorChar0);
        }
    }

    ImportReadData(String string, ControlInfo controlInfo) throws Exception {
        this.inputFileName = string;
        this.controlFileReader = controlInfo;
        this.loadPropertiesInfo();
        this.loadMetaData();
        this.lobFileHandles = new ImportLobFile[this.numberOfColumns];
    }

    int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    protected void ignoreFirstRow() throws Exception {
        this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true);
    }

    protected void loadColumnTypes() throws Exception {
        this.findNumberOfColumnsInARow();
        this.closeStream();
        this.openFile();
        String[] stringArray = new String[this.numberOfColumns];
        this.readNextDelimitedRow(stringArray);
        this.columnTypes = new String[this.numberOfColumns / 2];
        for (int i = 0; i < this.numberOfColumns; i += 2) {
            this.columnTypes[i / 2] = stringArray[i + 1];
        }
        this.closeStream();
        this.openFile();
        this.numberOfColumns = 0;
    }

    private void openFile() throws Exception {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    @Override
    public final Object run() throws Exception {
        this.realOpenFile();
        return null;
    }

    private void realOpenFile() throws Exception {
        InputStream inputStream;
        Object object;
        try {
            try {
                object = new URL(this.inputFileName);
                if (((URL)object).getProtocol().equals("file")) {
                    this.inputFileName = ((URL)object).getFile();
                    throw new MalformedURLException();
                }
                inputStream = ((URL)object).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(this.inputFileName);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw LoadError.dataFileNotFound(this.inputFileName, fileNotFoundException);
        }
        catch (SecurityException securityException) {
            throw LoadError.dataFileNotFound(this.inputFileName, securityException);
        }
        object = this.dataCodeset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.dataCodeset);
        this.bufferedReader = new BufferedReader((Reader)object, 32768);
        this.streamOpenForReading = true;
    }

    private void loadMetaData() throws Exception {
        this.openFile();
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH))) {
            this.hasColumnDefinition = true;
            this.ignoreFirstRow();
        }
        if (this.formatCode == 0) {
            this.findNumberOfColumnsInARow();
        }
        this.closeStream();
    }

    void closeStream() throws Exception {
        if (this.streamOpenForReading) {
            this.bufferedReader.close();
            this.streamOpenForReading = false;
        }
        if (this.lobFileHandles != null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (this.lobFileHandles[i] == null) continue;
                this.lobFileHandles[i].close();
            }
        }
    }

    int findNumberOfColumnsInARow() throws Exception {
        this.numberOfColumns = 1;
        while (!this.readTokensUntilEndOfRecord()) {
            ++this.numberOfColumns;
        }
        if (this.hasDelimiterAtEnd) {
            --this.numberOfColumns;
        }
        if (this.numberOfCharsReadSoFar == 0) {
            this.numberOfColumns = 0;
        }
        return this.numberOfColumns;
    }

    private void checkForWhiteSpaceInFront() {
        char c;
        if (!(this.positionOfNonWhiteSpaceCharInFront + 1 != this.totalCharsSoFar || this.foundStartDelimiter || this.foundStartAndStopDelimiters || !Character.isWhitespace(c = this.currentToken[this.positionOfNonWhiteSpaceCharInFront]) || !this.recordSepStartNotWhite && c == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && c == this.fieldSeparatorChar0)) {
            ++this.positionOfNonWhiteSpaceCharInFront;
        }
    }

    private void checkForWhiteSpaceInBack() {
        boolean bl = true;
        this.positionOfNonWhiteSpaceCharInBack = 0;
        for (int i = this.totalCharsSoFar; i > this.stopDelimiterPosition && bl; --i) {
            char c = this.currentToken[i];
            if (Character.isWhitespace(c)) {
                if (!this.recordSepStartNotWhite && c == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && c == this.fieldSeparatorChar0) continue;
                ++this.positionOfNonWhiteSpaceCharInBack;
                continue;
            }
            bl = false;
        }
    }

    boolean readTokensUntilEndOfRecord() throws Exception {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.foundStartDelimiter = false;
        this.foundStartAndStopDelimiters = false;
        this.numberOfCharsReadSoFar = 0;
        do {
            if ((n = this.bufferedReader.read()) == -1) {
                return true;
            }
            ++this.numberOfCharsReadSoFar;
            this.currentToken[this.totalCharsSoFar++] = (char)n;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] cArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, cArray, 0, this.totalCharsSoFar);
                this.currentToken = cArray;
            }
            if ((n2 = this.lookForPassedSeparator(this.fieldSeparator, n2, this.fieldSeparatorLength, n, false)) != -1) continue;
            return false;
        } while (this.foundStartDelimiter || (n3 = this.lookForPassedSeparator(this.recordSeparator, n3, this.recordSeparatorLength, n, true)) != -1);
        return true;
    }

    private int lookForPassedSeparator(char[] cArray, int n, int n2, int n3, boolean bl) throws IOException {
        if (!this.foundStartDelimiter) {
            if (this.fieldStartDelimiterLength != 0 && !this.foundStartAndStopDelimiters && this.totalCharsSoFar != this.positionOfNonWhiteSpaceCharInFront && this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront <= this.fieldStartDelimiterLength) {
                if (n3 == this.fieldStartDelimiter[this.fieldStartDelimiterIndex]) {
                    ++this.fieldStartDelimiterIndex;
                    if (this.fieldStartDelimiterIndex == this.fieldStartDelimiterLength) {
                        this.foundStartDelimiter = true;
                        this.totalCharsSoFar = 0;
                        this.positionOfNonWhiteSpaceCharInFront = 0;
                        return 0;
                    }
                } else if (this.fieldStartDelimiterIndex > 0) {
                    this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStartDelimiterIndex, this.fieldStartDelimiter, this.fieldStartDelimiterLength);
                }
            }
            if (bl) {
                if (n3 == 13 || n3 == 10) {
                    this.recordSeparatorChar0 = (char)n3;
                    if (n3 == 13) {
                        this.omitLineFeed();
                    }
                    --this.totalCharsSoFar;
                    return -1;
                }
                return n;
            }
            if (n3 == cArray[n]) {
                if (++n == n2) {
                    this.totalCharsSoFar -= n2;
                    return -1;
                }
                return n;
            }
            if (n > 0) {
                return this.reCheckRestOfTheCharacters(this.totalCharsSoFar - n, cArray, n2);
            }
        } else {
            if (n3 == this.fieldStopDelimiter[this.fieldStopDelimiterIndex]) {
                ++this.fieldStopDelimiterIndex;
                if (this.fieldStopDelimiterIndex == this.fieldStopDelimiterLength) {
                    boolean bl2 = this.skipDoubleDelimiters(this.fieldStopDelimiter);
                    if (!bl2) {
                        this.foundStartDelimiter = false;
                        this.totalCharsSoFar -= this.fieldStopDelimiterLength;
                        this.stopDelimiterPosition = this.totalCharsSoFar;
                        this.foundStartAndStopDelimiters = true;
                    } else {
                        this.fieldStopDelimiterIndex = 0;
                    }
                    return 0;
                }
                return 0;
            }
            if (this.fieldStopDelimiterIndex > 0) {
                this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStopDelimiterIndex, this.fieldStopDelimiter, this.fieldStopDelimiterLength);
                return 0;
            }
        }
        return 0;
    }

    private int reCheckRestOfTheCharacters(int n, char[] cArray, int n2) {
        int n3 = 0;
        for (int i = n; i < this.totalCharsSoFar; ++i) {
            if (this.currentToken[i] == cArray[n3]) {
                ++n3;
                continue;
            }
            n3 = 0;
        }
        return n3;
    }

    private boolean skipDoubleDelimiters(char[] cArray) throws IOException {
        boolean bl = true;
        int n = cArray.length;
        this.bufferedReader.mark(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.bufferedReader.read();
            if (n2 == cArray[i]) continue;
            this.bufferedReader.reset();
            bl = false;
            break;
        }
        return bl;
    }

    private void omitLineFeed() throws IOException {
        this.bufferedReader.mark(1);
        int n = this.bufferedReader.read();
        if (n != 10) {
            this.bufferedReader.reset();
        }
    }

    int getCurrentRowNumber() {
        return this.lineNumber;
    }

    boolean readNextRow(String[] stringArray) throws Exception {
        if (!this.streamOpenForReading) {
            this.openFile();
            if (this.hasColumnDefinition) {
                this.ignoreFirstRow();
            }
        }
        boolean bl = this.formatCode == 0 ? this.readNextDelimitedRow(stringArray) : this.readNextFixedRow(stringArray);
        return bl;
    }

    private boolean readNextFixedRow(String[] stringArray) throws Exception {
        int n;
        int n2 = 0;
        int n3 = 0;
        while ((n2 += this.bufferedReader.read(this.tempString, n2, this.rowWidth - n2)) < this.rowWidth) {
            if (n2 == n3 - 1) {
                if (n2 == -1) {
                    return false;
                }
                if (n3 != this.rowWidth - this.recordSeparator.length) {
                    throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
                }
                this.haveSep = false;
                break;
            }
            n3 = n2;
        }
        int n4 = 0;
        for (n = 0; n < this.numberOfColumns; ++n) {
            int n5 = this.columnWidths[n];
            if (n5 == 0) {
                stringArray[n] = null;
                continue;
            }
            String string = new String(this.tempString, n4, n5);
            stringArray[n] = string.trim().equals(this.nullString) ? null : string;
            n4 += n5;
        }
        if (this.haveSep) {
            for (n = this.recordSeparatorLength - 1; n >= 0; --n) {
                if (this.tempString[n4 + n] == this.recordSeparator[n]) continue;
                throw LoadError.recordSeparatorMissing(this.lineNumber + 1);
            }
        } else {
            this.haveSep = true;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean readNextDelimitedRow(String[] stringArray) throws Exception {
        int n;
        int n2 = this.numberOfColumns - 1;
        if (n2 < 0) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (!this.readNextToken(this.fieldSeparator, 0, this.fieldSeparatorLength, false)) {
                if (n == 0) {
                    return false;
                }
                throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
            }
            if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
                for (int i = this.stopDelimiterPosition + 1; i < this.totalCharsSoFar; ++i) {
                    if (Character.isWhitespace(this.currentToken[i])) continue;
                    throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, n + 1);
                }
                this.totalCharsSoFar = this.stopDelimiterPosition;
            }
            stringArray[n] = this.totalCharsSoFar != -1 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
        }
        if (!this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true)) {
            if (n2 == 0) {
                return false;
            }
            throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
        }
        if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
            for (n = this.stopDelimiterPosition + 1; n < this.totalCharsSoFar; ++n) {
                if (Character.isWhitespace(this.currentToken[n])) continue;
                throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, this.numberOfColumns);
            }
            this.totalCharsSoFar = this.stopDelimiterPosition;
        }
        if (this.hasDelimiterAtEnd && this.fieldStopDelimiterLength <= 0) {
            --this.totalCharsSoFar;
        }
        if (this.totalCharsSoFar > -1) {
            if (!this.hasDelimiterAtEnd) {
                stringArray[n2] = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
            } else if (this.totalCharsSoFar == this.fieldSeparatorLength && this.isFieldSep(this.currentToken)) {
                String string = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
                stringArray[n2] = this.currentToken[this.totalCharsSoFar + 1] == this.fieldStopDelimiter[0] ? string : null;
            } else {
                stringArray[n2] = this.totalCharsSoFar > 0 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
            }
        } else {
            stringArray[n2] = null;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean isFieldSep(char[] cArray) {
        for (int i = 0; i < cArray.length && i < this.fieldSeparatorLength; ++i) {
            if (cArray[i] == this.fieldSeparator[i]) continue;
            return false;
        }
        return true;
    }

    boolean readNextToken(char[] cArray, int n, int n2, boolean bl) throws Exception {
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.stopDelimiterPosition = 0;
        this.foundStartAndStopDelimiters = false;
        this.foundStartDelimiter = false;
        int n3;
        while ((n3 = this.bufferedReader.read()) != -1) {
            int n4;
            this.currentToken[this.totalCharsSoFar++] = (char)n3;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] cArray2 = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, cArray2, 0, this.totalCharsSoFar);
                this.currentToken = cArray2;
            }
            if ((n4 = this.lookForPassedSeparator(cArray, n, n2, n3, bl)) == -1) {
                if (!this.foundStartAndStopDelimiters) {
                    if (this.totalCharsSoFar == 0) {
                        this.totalCharsSoFar = -1;
                    } else {
                        this.checkForWhiteSpaceInBack();
                        this.totalCharsSoFar = this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront - this.positionOfNonWhiteSpaceCharInBack;
                    }
                }
                return true;
            }
            n = n4;
        }
        return false;
    }

    String getClobColumnFromExtFileAsString(String string, int n) throws SQLException {
        try {
            this.initExternalLobFile(string, n);
            if (this.lobLength == -1) {
                return null;
            }
            return this.lobFileHandles[n - 1].getString(this.lobOffset, this.lobLength);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    Clob getClobColumnFromExtFile(String string, int n) throws SQLException {
        try {
            this.initExternalLobFile(string, n);
            if (this.lobLength == -1) {
                return null;
            }
            return new ImportClob(this.lobFileHandles[n - 1], this.lobOffset, this.lobLength);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    Blob getBlobColumnFromExtFile(String string, int n) throws SQLException {
        this.initExternalLobFile(string, n);
        if (this.lobLength == -1) {
            return null;
        }
        return new ImportBlob(this.lobFileHandles[n - 1], this.lobOffset, this.lobLength);
    }

    private void initExternalLobFile(String string, int n) throws SQLException {
        int n2 = string.lastIndexOf(".");
        int n3 = string.lastIndexOf(".", n2 - 1);
        this.lobLength = Integer.parseInt(string.substring(n2 + 1, string.length() - 1));
        this.lobOffset = Integer.parseInt(string.substring(n3 + 1, n2));
        this.lobFileName = string.substring(0, n3);
        if (this.lobFileHandles[n - 1] == null) {
            try {
                File file = new File(this.lobFileName);
                if (file.getParentFile() == null) {
                    file = new File(new File(this.inputFileName).getParentFile(), this.lobFileName);
                }
                this.lobFileHandles[n - 1] = new ImportLobFile(file, this.controlFileReader.getDataCodeset());
            }
            catch (Exception exception) {
                throw LoadError.unexpectedError(exception);
            }
        }
    }
}

