/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.internal.ui.history.Branch;
import org.eclipse.emf.cdo.internal.ui.history.Commit;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Track;

public final class Segment {
    private final Track track;
    private final Branch branch;
    private final Commit mergeSource;
    private boolean complete;
    private long firstVisualTime;
    private long firstCommitTime;
    private long lastCommitTime;
    private Segment previousInTrack;
    private Segment nextInTrack;
    private Segment previousInBranch;
    private Segment nextInBranch;

    public Segment(Track track, Branch branch, Commit mergeSource) {
        this.track = track;
        this.branch = branch;
        this.mergeSource = mergeSource;
    }

    public Net getNet() {
        return this.track.getNet();
    }

    public Track getTrack() {
        return this.track;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Commit getMergeSource() {
        return this.mergeSource;
    }

    public boolean isMerge() {
        return this.mergeSource != null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public long getFirstVisualTime() {
        return this.firstVisualTime;
    }

    public long getFirstCommitTime() {
        return this.firstCommitTime;
    }

    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public Segment getPreviousInTrack() {
        return this.previousInTrack;
    }

    public Segment getNextInTrack() {
        return this.nextInTrack;
    }

    public Segment getPreviousInBranch() {
        return this.previousInBranch;
    }

    public Segment getNextInBranch() {
        return this.nextInBranch;
    }

    public boolean containsCommitTime(long time) {
        return time >= this.firstCommitTime && time <= this.lastCommitTime;
    }

    public boolean containsVisualTime(long time) {
        return time >= this.getFirstVisualTime() && time <= this.lastCommitTime;
    }

    public String toString() {
        return "Segment[" + this.branch + " --> " + this.track + "]";
    }

    void adjustVisualTime(long time, boolean adjustComplete) {
        if (this.isMerge()) {
            this.firstVisualTime = this.firstCommitTime;
            this.complete = true;
            return;
        }
        if (time < this.firstVisualTime) {
            this.firstVisualTime = time;
        } else if (this.firstVisualTime == 0L) {
            long baseCommitTime;
            Segment previousInBranch = this.getPreviousInBranch();
            if (previousInBranch != null) {
                this.firstVisualTime = previousInBranch.getLastCommitTime();
                this.complete = true;
                return;
            }
            Commit firstCommit = this.getNet().getFirstCommit();
            if (firstCommit != null && (baseCommitTime = this.branch.getBaseCommitTime()) >= firstCommit.getTime()) {
                this.firstVisualTime = baseCommitTime;
                this.complete = true;
                return;
            }
            this.firstVisualTime = time;
        }
        this.complete |= adjustComplete;
    }

    void adjustCommitTimes(long time) {
        this.adjustVisualTime(time, false);
        if (this.firstCommitTime == 0L) {
            this.firstCommitTime = time;
            this.lastCommitTime = time;
        } else if (time < this.firstCommitTime) {
            this.firstCommitTime = time;
        } else if (time > this.lastCommitTime) {
            this.lastCommitTime = time;
        }
    }

    void setPreviousInTrack(Segment previousInTrack) {
        this.previousInTrack = previousInTrack;
    }

    void setNextInTrack(Segment nextInTrack) {
        this.nextInTrack = nextInTrack;
    }

    void setPreviousInBranch(Segment previousInBranch) {
        this.previousInBranch = previousInBranch;
    }

    void setNextInBranch(Segment nextInBranch) {
        this.nextInBranch = nextInBranch;
    }
}

