/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import javax.transaction.xa.Xid;

class DRDAXid
implements Xid {
    private final int format_id;
    private final byte[] global_id;
    private final byte[] branch_id;

    DRDAXid(int n, byte[] byArray, byte[] byArray2) {
        this.format_id = n;
        this.global_id = byArray;
        this.branch_id = byArray2;
    }

    @Override
    public int getFormatId() {
        return this.format_id;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.global_id;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branch_id;
    }

    public String toString() {
        String string = "{DRDAXid: formatId(" + this.format_id + "), " + "globalTransactionId(" + DRDAXid.convertToHexString(this.global_id) + ")" + "branchQualifier(" + DRDAXid.convertToHexString(this.branch_id) + ")";
        return string;
    }

    private static String convertToHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

