/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.tests;

import java.sql.Connection;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBNamedElement;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public abstract class AbstractDBTest
extends AbstractOMTest {
    public static final String SCHEMA_NAME = "TEST";
    private IDBAdapter adapter;
    private IDBConnectionProvider connectionProvider;
    private Connection internalConnection;

    protected void doSetUp() throws Exception {
        this.adapter = this.createAdapter();
        DataSource dataSource = this.createDataSource();
        this.connectionProvider = this.adapter.createConnectionProvider(dataSource);
    }

    protected void doTearDown() throws Exception {
        if (this.internalConnection != null) {
            DBUtil.dropAllTables((Connection)this.internalConnection, null);
            DBUtil.close((Connection)this.internalConnection);
            this.internalConnection = null;
        }
        this.connectionProvider = null;
        this.adapter = null;
    }

    protected abstract IDBAdapter createAdapter();

    protected abstract DataSource createDataSource();

    private Connection getConnection() {
        if (this.internalConnection == null) {
            this.internalConnection = this.connectionProvider.getConnection();
        }
        return this.internalConnection;
    }

    public void _testDBTypes() throws Exception {
        IDBSchema schema = DBUtil.createSchema((String)"testDBTypes");
        DBType[] dbTypes = DBType.values();
        int count = 0;
        int i = 0;
        DBType[] dBTypeArray = dbTypes;
        int n = dbTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBType dbType = dBTypeArray[n2];
            IDBTable table = schema.addTable("table_" + i);
            table.addField("field", dbType);
            ++count;
            if (this.adapter.isTypeIndexable(dbType)) {
                IDBTable idx_table = schema.addTable("idx_table" + i);
                IDBField idx_field = idx_table.addField("field", dbType);
                idx_table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idx_field});
                ++count;
                IDBTable uni_table = schema.addTable("uni_table" + i);
                IDBField uni_field = uni_table.addField("field", dbType);
                uni_table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{uni_field});
                ++count;
                IDBTable pk_table = schema.addTable("pk_table" + i);
                IDBField pk_field = pk_table.addField("field", dbType);
                pk_table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{pk_field});
                ++count;
            }
            ++i;
            ++n2;
        }
        Set tables = schema.create(this.adapter, this.getConnection());
        AbstractDBTest.assertEquals((int)count, (int)tables.size());
    }

    public void testFindElement() throws Exception {
        IDBSchema schema1 = DBUtil.createSchema((String)SCHEMA_NAME);
        IDBTable table1 = schema1.addTable("table");
        IDBField field11 = table1.addField("field1", DBType.INTEGER, true);
        IDBField field12 = table1.addField("field2", DBType.VARCHAR, 64, true);
        IDBField field13 = table1.addField("field3", DBType.BOOLEAN);
        IDBIndex index11 = table1.addIndex("index1", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field11, field12});
        IDBIndex index12 = table1.addIndex("index2", IDBIndex.Type.UNIQUE, new IDBField[]{field11, field12});
        IDBIndex index13 = table1.addIndex("index3", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field12});
        IDBSchema schema2 = DBUtil.createSchema((String)SCHEMA_NAME);
        IDBTable table2 = schema2.addTable("table");
        IDBField field21 = table2.addField("field1", DBType.INTEGER, true);
        IDBField field22 = table2.addField("field2", DBType.VARCHAR, 64, true);
        IDBField field23 = table2.addField("field3", DBType.BOOLEAN);
        IDBIndex index21 = table2.addIndex("index1", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field21, field22});
        IDBIndex index22 = table2.addIndex("index2", IDBIndex.Type.UNIQUE, new IDBField[]{field21, field22});
        IDBIndex index23 = table2.addIndex("index3", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field22});
        AbstractDBTest.assertSame((Object)schema2, (Object)schema2.findElement((IDBSchemaElement)schema1));
        AbstractDBTest.assertSame((Object)table2, (Object)schema2.findElement((IDBSchemaElement)table1));
        AbstractDBTest.assertSame((Object)field21, (Object)schema2.findElement((IDBSchemaElement)field11));
        AbstractDBTest.assertSame((Object)field22, (Object)schema2.findElement((IDBSchemaElement)field12));
        AbstractDBTest.assertSame((Object)field23, (Object)schema2.findElement((IDBSchemaElement)field13));
        AbstractDBTest.assertSame((Object)index21, (Object)schema2.findElement((IDBSchemaElement)index11));
        AbstractDBTest.assertSame((Object)index22, (Object)schema2.findElement((IDBSchemaElement)index12));
        AbstractDBTest.assertSame((Object)index23, (Object)schema2.findElement((IDBSchemaElement)index13));
    }

    public void testReadSchema() throws Exception {
        IDBSchema schema = DBUtil.readSchema((IDBAdapter)this.adapter, (Connection)this.getConnection(), (String)SCHEMA_NAME);
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema.isEmpty());
    }

    public void testCreateSchema() throws Exception {
        IDBDatabase database = DBUtil.openDatabase((IDBAdapter)this.adapter, (IDBConnectionProvider)this.connectionProvider, (String)SCHEMA_NAME);
        IDBSchema schema = database.getSchema();
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema.isLocked());
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema.isEmpty());
        IDBSchemaTransaction schemaTransaction = database.openSchemaTransaction();
        IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
        AbstractDBTest.assertEquals((boolean)false, (boolean)workingCopy.isLocked());
        AbstractDBTest.assertEquals((boolean)true, (boolean)workingCopy.isEmpty());
        AbstractDBTest.assertEquals((Object)schema, (Object)workingCopy);
        IDBTable table1 = workingCopy.addTable("table1");
        IDBField field11 = table1.addField("field11", DBType.INTEGER, true);
        IDBField field12 = table1.addField("field12", DBType.VARCHAR, 64, true);
        IDBField field13 = table1.addField("field13", DBType.BOOLEAN);
        IDBIndex index11 = table1.addIndex("index11", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field11, field12});
        IDBIndex index12 = table1.addIndex("index12", IDBIndex.Type.UNIQUE, new IDBField[]{field11, field12});
        IDBIndex index13 = table1.addIndex("index13", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field12});
        IDBTable table2 = workingCopy.addTable("table2");
        IDBField field21 = table2.addField("field21", DBType.INTEGER, true);
        IDBField field22 = table2.addField("field22", DBType.VARCHAR, 64, true);
        IDBField field23 = table2.addField("field23", DBType.BOOLEAN);
        IDBIndex index21 = table2.addIndex("index21", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field21, field22});
        IDBIndex index22 = table2.addIndex("index22", IDBIndex.Type.UNIQUE, new IDBField[]{field21, field22});
        IDBIndex index23 = table2.addIndex("index23", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field22});
        schemaTransaction.commit();
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema.isLocked());
        AbstractDBTest.assertEquals((boolean)false, (boolean)schema.isEmpty());
        AbstractDBTest.assertEquals((int)2, (int)schema.getTables().length);
        AbstractDBTest.assertEquals((Object)table1, (Object)schema.getTables()[0]);
        AbstractDBTest.assertEquals((int)table1.getFieldCount(), (int)schema.getTables()[0].getFieldCount());
        AbstractDBTest.assertEquals((Object)field11, (Object)schema.getTables()[0].getField(0));
        AbstractDBTest.assertEquals((Object)field12, (Object)schema.getTables()[0].getField(1));
        AbstractDBTest.assertEquals((Object)field13, (Object)schema.getTables()[0].getField(2));
        AbstractDBTest.assertEquals((int)table1.getIndexCount(), (int)schema.getTables()[0].getIndexCount());
        AbstractDBTest.assertEquals((Object)index11, (Object)schema.getTables()[0].getIndex(0));
        AbstractDBTest.assertEquals((Object)index11.getType(), (Object)schema.getTables()[0].getIndex(0).getType());
        AbstractDBTest.assertEquals((Object)index12, (Object)schema.getTables()[0].getIndex(1));
        AbstractDBTest.assertEquals((Object)index12.getType(), (Object)schema.getTables()[0].getIndex(1).getType());
        AbstractDBTest.assertEquals((Object)index13, (Object)schema.getTables()[0].getIndex(2));
        AbstractDBTest.assertEquals((Object)index13.getType(), (Object)schema.getTables()[0].getIndex(2).getType());
        AbstractDBTest.assertEquals((Object)table2, (Object)schema.getTables()[1]);
        AbstractDBTest.assertEquals((int)table2.getFieldCount(), (int)schema.getTables()[1].getFieldCount());
        AbstractDBTest.assertEquals((Object)field21, (Object)schema.getTables()[1].getField(0));
        AbstractDBTest.assertEquals((Object)field22, (Object)schema.getTables()[1].getField(1));
        AbstractDBTest.assertEquals((Object)field23, (Object)schema.getTables()[1].getField(2));
        AbstractDBTest.assertEquals((int)table2.getIndexCount(), (int)schema.getTables()[1].getIndexCount());
        AbstractDBTest.assertEquals((Object)index21, (Object)schema.getTables()[1].getIndex(0));
        AbstractDBTest.assertEquals((Object)index21.getType(), (Object)schema.getTables()[1].getIndex(0).getType());
        AbstractDBTest.assertEquals((Object)index22, (Object)schema.getTables()[1].getIndex(1));
        AbstractDBTest.assertEquals((Object)index22.getType(), (Object)schema.getTables()[1].getIndex(1).getType());
        AbstractDBTest.assertEquals((Object)index23, (Object)schema.getTables()[1].getIndex(2));
        AbstractDBTest.assertEquals((Object)index23.getType(), (Object)schema.getTables()[1].getIndex(2).getType());
    }

    public void testChangeSchema() throws Exception {
        IDBDatabase database = DBUtil.openDatabase((IDBAdapter)this.adapter, (IDBConnectionProvider)this.connectionProvider, (String)SCHEMA_NAME);
        IDBSchema schema = database.getSchema();
        IDBSchemaTransaction schemaTransaction = database.openSchemaTransaction();
        IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
        IDBTable table1 = workingCopy.addTable("table1");
        IDBField field11 = table1.addField("field11", DBType.INTEGER, true);
        IDBField field12 = table1.addField("field12", DBType.VARCHAR, 64, true);
        IDBField field13 = table1.addField("field13", DBType.BOOLEAN);
        IDBIndex index11 = table1.addIndex("index11", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field11, field12});
        IDBIndex index12 = table1.addIndex("index12", IDBIndex.Type.UNIQUE, new IDBField[]{field11, field12});
        IDBIndex index13 = table1.addIndex("index13", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field12});
        schemaTransaction.commit();
        AbstractDBTest.assertEquals((int)1, (int)schema.getTables().length);
        IDBDatabase database2 = DBUtil.openDatabase((IDBAdapter)this.adapter, (IDBConnectionProvider)this.connectionProvider, (String)SCHEMA_NAME);
        IDBSchema schema2 = database2.getSchema();
        DBUtil.dump((IDBNamedElement)schema2);
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema2.isLocked());
        AbstractDBTest.assertEquals((boolean)false, (boolean)schema2.isEmpty());
        AbstractDBTest.assertEquals((int)1, (int)schema2.getTables().length);
        IDBTable table = schema2.getTable("table1");
        field11 = table.getField("field11");
        field12 = table.getField("field12");
        field13 = table.getField("field13");
        index11 = table.getIndex("index11");
        index12 = table.getIndex("index12");
        index13 = table.getIndex("index13");
        AbstractDBTest.assertNotNull((Object)field11);
        AbstractDBTest.assertNotNull((Object)field12);
        AbstractDBTest.assertNotNull((Object)field13);
        AbstractDBTest.assertNotNull((Object)index11);
        AbstractDBTest.assertNotNull((Object)index12);
        AbstractDBTest.assertNotNull((Object)index13);
        schemaTransaction = database2.openSchemaTransaction();
        workingCopy = schemaTransaction.getWorkingCopy();
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema2.isLocked());
        AbstractDBTest.assertEquals((boolean)false, (boolean)schema2.isEmpty());
        AbstractDBTest.assertEquals((int)1, (int)schema2.getTables().length);
        IDBTable table2 = workingCopy.addTable("table2");
        IDBField field21 = table2.addField("field21", DBType.INTEGER, true);
        IDBField field22 = table2.addField("field22", DBType.VARCHAR, 64, true);
        IDBField field23 = table2.addField("field23", DBType.BOOLEAN);
        IDBIndex index21 = table2.addIndex("index21", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field21, field22});
        IDBIndex index22 = table2.addIndex("index22", IDBIndex.Type.UNIQUE, new IDBField[]{field21, field22});
        IDBIndex index23 = table2.addIndex("index23", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field22});
        AbstractDBTest.assertEquals((Object)table1, (Object)schema2.getTables()[0]);
        AbstractDBTest.assertEquals((int)table1.getFieldCount(), (int)schema2.getTables()[0].getFieldCount());
        AbstractDBTest.assertEquals((Object)field11, (Object)schema2.getTables()[0].getField(0));
        AbstractDBTest.assertEquals((Object)field12, (Object)schema2.getTables()[0].getField(1));
        AbstractDBTest.assertEquals((Object)field13, (Object)schema2.getTables()[0].getField(2));
        AbstractDBTest.assertEquals((int)table1.getIndexCount(), (int)schema2.getTables()[0].getIndexCount());
        AbstractDBTest.assertEquals((Object)index11, (Object)schema2.getTables()[0].getIndex(0));
        AbstractDBTest.assertEquals((Object)index11.getType(), (Object)schema2.getTables()[0].getIndex(0).getType());
        AbstractDBTest.assertEquals((Object)index12, (Object)schema2.getTables()[0].getIndex(1));
        AbstractDBTest.assertEquals((Object)index12.getType(), (Object)schema2.getTables()[0].getIndex(1).getType());
        AbstractDBTest.assertEquals((Object)index13, (Object)schema2.getTables()[0].getIndex(2));
        AbstractDBTest.assertEquals((Object)index13.getType(), (Object)schema2.getTables()[0].getIndex(2).getType());
        IDBSchemaDelta delta = schemaTransaction.commit();
        DBUtil.dump((IDBNamedElement)delta);
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema2.isLocked());
        AbstractDBTest.assertEquals((boolean)false, (boolean)schema2.isEmpty());
        AbstractDBTest.assertEquals((int)2, (int)schema2.getTables().length);
        AbstractDBTest.assertEquals((Object)table1, (Object)schema2.getTables()[0]);
        AbstractDBTest.assertEquals((int)table1.getFieldCount(), (int)schema2.getTables()[0].getFieldCount());
        AbstractDBTest.assertEquals((Object)field11, (Object)schema2.getTables()[0].getField(0));
        AbstractDBTest.assertEquals((Object)field12, (Object)schema2.getTables()[0].getField(1));
        AbstractDBTest.assertEquals((Object)field13, (Object)schema2.getTables()[0].getField(2));
        AbstractDBTest.assertEquals((int)table1.getIndexCount(), (int)schema2.getTables()[0].getIndexCount());
        AbstractDBTest.assertEquals((Object)index11, (Object)schema2.getTables()[0].getIndex(0));
        AbstractDBTest.assertEquals((Object)index11.getType(), (Object)schema2.getTables()[0].getIndex(0).getType());
        AbstractDBTest.assertEquals((Object)index12, (Object)schema2.getTables()[0].getIndex(1));
        AbstractDBTest.assertEquals((Object)index12.getType(), (Object)schema2.getTables()[0].getIndex(1).getType());
        AbstractDBTest.assertEquals((Object)index13, (Object)schema2.getTables()[0].getIndex(2));
        AbstractDBTest.assertEquals((Object)index13.getType(), (Object)schema2.getTables()[0].getIndex(2).getType());
        AbstractDBTest.assertEquals((Object)table2, (Object)schema2.getTables()[1]);
        AbstractDBTest.assertEquals((int)table2.getFieldCount(), (int)schema2.getTables()[1].getFieldCount());
        AbstractDBTest.assertEquals((Object)field21, (Object)schema2.getTables()[1].getField(0));
        AbstractDBTest.assertEquals((Object)field22, (Object)schema2.getTables()[1].getField(1));
        AbstractDBTest.assertEquals((Object)field23, (Object)schema2.getTables()[1].getField(2));
        AbstractDBTest.assertEquals((int)table2.getIndexCount(), (int)schema2.getTables()[1].getIndexCount());
        AbstractDBTest.assertEquals((Object)index21, (Object)schema2.getTables()[1].getIndex(0));
        AbstractDBTest.assertEquals((Object)index21.getType(), (Object)schema2.getTables()[1].getIndex(0).getType());
        AbstractDBTest.assertEquals((Object)index22, (Object)schema2.getTables()[1].getIndex(1));
        AbstractDBTest.assertEquals((Object)index22.getType(), (Object)schema2.getTables()[1].getIndex(1).getType());
        AbstractDBTest.assertEquals((Object)index23, (Object)schema2.getTables()[1].getIndex(2));
        AbstractDBTest.assertEquals((Object)index23.getType(), (Object)schema2.getTables()[1].getIndex(2).getType());
    }

    public void testEnsureSchema() throws Exception {
        IDBDatabase database = DBUtil.openDatabase((IDBAdapter)this.adapter, (IDBConnectionProvider)this.connectionProvider, (String)SCHEMA_NAME);
        IDBSchemaTransaction schemaTransaction = database.openSchemaTransaction();
        IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
        IDBTable table1 = workingCopy.addTable("table1");
        table1.addField("field11", DBType.INTEGER, true);
        table1.addField("field12", DBType.VARCHAR, 64, true);
        table1.addField("field13", DBType.BOOLEAN);
        schemaTransaction.commit();
        IDBSchema newSchema = DBUtil.createSchema((String)"DIFFERENT_NAME");
        IDBTable table2 = newSchema.addTable("table2");
        IDBField field21 = table2.addField("field21", DBType.INTEGER, true);
        IDBField field22 = table2.addField("field22", DBType.VARCHAR, 64, true);
        table2.addField("field23", DBType.BOOLEAN);
        table2.addIndex("index21", IDBIndex.Type.PRIMARY_KEY, new IDBField[]{field21, field22});
        table2.addIndex("index22", IDBIndex.Type.UNIQUE, new IDBField[]{field21, field22});
        table2.addIndex("index23", IDBIndex.Type.NON_UNIQUE, new IDBField[]{field22});
        IDBDatabase database2 = DBUtil.openDatabase((IDBAdapter)this.adapter, (IDBConnectionProvider)this.connectionProvider, (String)SCHEMA_NAME);
        IDBSchemaTransaction schemaTransaction2 = database2.openSchemaTransaction();
        schemaTransaction2.ensureSchema(newSchema);
        schemaTransaction2.commit();
        IDBSchema schema = database2.getSchema();
        AbstractDBTest.assertEquals((boolean)true, (boolean)schema.isLocked());
        AbstractDBTest.assertEquals((boolean)false, (boolean)schema.isEmpty());
        AbstractDBTest.assertEquals((String)SCHEMA_NAME, (String)schema.getName());
        AbstractDBTest.assertEquals((int)2, (int)schema.getTables().length);
        DBUtil.dump((IDBNamedElement)schema);
    }
}

