/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.tests.db.AbstractSetupDBConfig;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.mysql.MYSQLAdapter;

public class MysqlConfig
extends AbstractSetupDBConfig {
    public static final String DB_ADAPTER_NAME = "Mysql";
    public static final String HOST = "localhost";
    public static final String USER = "root";
    public static final String PASS = "";
    private static final long serialVersionUID = 1L;

    public MysqlConfig() {
        super(DB_ADAPTER_NAME);
    }

    @Override
    protected String getDBAdapterName() {
        return DB_ADAPTER_NAME;
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new MYSQLAdapter();
    }

    @Override
    protected DataSource createDataSourceForDB(String dbName) throws SQLException {
        String url = "jdbc:mysql://localhost";
        if (dbName != null) {
            url = String.valueOf(url) + "/" + dbName;
        }
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setUrl(url);
        dataSource.setUser(USER);
        if (PASS != null && !PASS.isEmpty()) {
            dataSource.setPassword(PASS);
        }
        return dataSource;
    }

    @Override
    protected void initDatabase(Connection connection, Statement stmt, String dbName) throws SQLException {
        stmt.execute("CREATE DATABASE " + dbName + " CHARACTER SET utf8mb4");
    }

    @Override
    protected Map<String, String> createStoreProperties() {
        Map<String, String> props = super.createStoreProperties();
        props.put("externalRefsURIColumnLength", "768");
        return props;
    }
}

