/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Constraint
extends SchemaObjectBase
implements Comparable<Constraint> {
    public static final String CHECK = "CHECK";
    public static final String REFERENTIAL = "REFERENTIAL";
    public static final String UNIQUE = "UNIQUE";
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    protected Table table;

    Constraint(Schema schema, int n, String string, Table table) {
        this.initSchemaObjectBase(schema, n, string, "constraint");
        this.table = table;
        this.setTemporary(table.isTemporary());
    }

    public abstract String getConstraintType();

    public abstract void checkRow(Session var1, Table var2, Row var3, Row var4);

    public abstract boolean usesIndex(Index var1);

    public abstract void setIndexOwner(Index var1);

    public abstract HashSet<Column> getReferencedColumns(Table var1);

    public abstract String getCreateSQLWithoutIndexes();

    public abstract boolean isBefore();

    public abstract void checkExistingData(Session var1);

    public abstract void rebuild();

    public abstract Index getUniqueIndex();

    @Override
    public void checkRename() {
    }

    @Override
    public int getType() {
        return 5;
    }

    public Table getTable() {
        return this.table;
    }

    public Table getRefTable() {
        return this.table;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    private int getConstraintTypeOrder() {
        String string = this.getConstraintType();
        if (CHECK.equals(string)) {
            return 0;
        }
        if (PRIMARY_KEY.equals(string)) {
            return 1;
        }
        if (UNIQUE.equals(string)) {
            return 2;
        }
        if (REFERENTIAL.equals(string)) {
            return 3;
        }
        throw DbException.throwInternalError("type: " + string);
    }

    @Override
    public int compareTo(Constraint constraint) {
        if (this == constraint) {
            return 0;
        }
        int n = this.getConstraintTypeOrder();
        int n2 = constraint.getConstraintTypeOrder();
        return n - n2;
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return true;
    }
}

