/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.net4j.util.WrappedException;

public class LoadBranchesIndication
extends CDOServerReadIndication {
    private int startID;
    private int endID;

    public LoadBranchesIndication(CDOServerProtocol protocol) {
        super(protocol, (short)36);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.startID = in.readXInt();
        this.endID = in.readXInt();
    }

    @Override
    protected void responding(final CDODataOutput out) throws IOException {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        branchManager.getBranches(this.startID, this.endID, new CDOBranchHandler(){

            public void handleBranch(CDOBranch branch) {
                try {
                    out.writeByte(1);
                    out.writeCDOBranch(branch);
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        });
        out.writeByte(0);
    }
}

