/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.IBufferPool;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.internal.tcp.TCPAcceptor;
import org.eclipse.net4j.internal.tcp.TCPClientConnector;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.TCPSelector;
import org.eclipse.net4j.internal.tcp.ssl.SSLAcceptor;
import org.eclipse.net4j.internal.tcp.ssl.SSLClientConnector;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.tests.AbstractTransportTest;
import org.eclipse.net4j.tests.bundle.OM;
import org.eclipse.net4j.util.collection.RoundRobinBlockingQueue;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ThreadPool;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.ChallengeNegotiator;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.Randomizer;
import org.eclipse.net4j.util.security.ResponseNegotiator;
import org.eclipse.net4j.util.security.UserManager;
import org.eclipse.spi.net4j.Channel;
import org.eclipse.spi.net4j.InternalChannel;

public class TCPConnectorTest
extends AbstractTransportTest {
    private static final int TIMEOUT = 10000;
    private static final int PORT = 2040;
    private static final String USER_ID = "stepper";
    private static final String INVALID_USER_ID = "invalid";
    private static final char[] PASSWORD = "eike2008".toCharArray();
    private static final char[] INVALID_PASSWORD = "invalid".toCharArray();
    private static final PasswordCredentials CREDENTIALS = new PasswordCredentials("stepper", PASSWORD);
    private ExecutorService threadPool;
    private IBufferPool bufferPool;
    private TCPSelector selector;
    private TCPAcceptor acceptor;
    private TCPConnector connector;
    private Randomizer randomizer;
    private UserManager userManager;
    private ChallengeNegotiator challengeNegotiator;
    private PasswordCredentialsProvider credentialsProvider;
    private ResponseNegotiator responseNegotiator;

    @Override
    protected void doTearDown() throws Exception {
        this.cleanup();
        super.doTearDown();
    }

    private void cleanup() throws Exception {
        TCPConnectorTest.sleep(100L);
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
        if (this.responseNegotiator != null) {
            LifecycleUtil.deactivate((Object)this.responseNegotiator);
            this.responseNegotiator = null;
        }
        if (this.credentialsProvider != null) {
            LifecycleUtil.deactivate((Object)this.credentialsProvider);
            this.credentialsProvider = null;
        }
        if (this.acceptor != null) {
            this.acceptor.close();
            this.acceptor = null;
        }
        if (this.challengeNegotiator != null) {
            LifecycleUtil.deactivate((Object)this.challengeNegotiator);
            this.challengeNegotiator = null;
        }
        if (this.userManager != null) {
            LifecycleUtil.deactivate((Object)this.userManager);
            this.userManager = null;
        }
        if (this.randomizer != null) {
            LifecycleUtil.deactivate((Object)this.randomizer);
            this.randomizer = null;
        }
        if (this.selector != null) {
            LifecycleUtil.deactivate((Object)this.selector);
            this.selector = null;
        }
        if (this.bufferPool != null) {
            LifecycleUtil.deactivate((Object)this.bufferPool);
            this.bufferPool = null;
        }
        if (this.threadPool != null) {
            LifecycleUtil.deactivate((Object)this.threadPool);
            this.threadPool = null;
        }
    }

    private void provideTransport() {
        this.selector = new TCPSelector();
        if (this.useSSLTransport()) {
            this.acceptor = new SSLAcceptor();
            this.container.putElement("org.eclipse.net4j.acceptors", "ssl", null, (Object)this.acceptor);
            this.connector = new SSLClientConnector();
            this.separateContainer.putElement("org.eclipse.net4j.connectors", "ssl", null, (Object)this.acceptor);
        } else {
            this.acceptor = new TCPAcceptor();
            this.container.putElement("org.eclipse.net4j.acceptors", "tcp", null, (Object)this.acceptor);
            this.connector = new TCPClientConnector();
            this.container.putElement("org.eclipse.net4j.connectors", "tcp", null, (Object)this.acceptor);
        }
    }

    private void provideTransport(final long increaseDelayAcceptor) {
        this.selector = new TCPSelector();
        if (this.useSSLTransport()) {
            this.acceptor = new SSLAcceptor(){

                public void handleAccept(ITCPSelector selector, ServerSocketChannel serverSocketChannel) {
                    ConcurrencyUtil.sleep((long)increaseDelayAcceptor);
                    super.handleAccept(selector, serverSocketChannel);
                }
            };
            this.connector = new SSLClientConnector();
        } else {
            this.acceptor = new TCPAcceptor(){

                public void handleAccept(ITCPSelector selector, ServerSocketChannel serverSocketChannel) {
                    ConcurrencyUtil.sleep((long)increaseDelayAcceptor);
                    super.handleAccept(selector, serverSocketChannel);
                }
            };
            this.connector = new TCPClientConnector();
        }
    }

    public void testDeferredActivation() throws Exception {
        long DELAY = 500L;
        this.threadPool = ThreadPool.create();
        this.bufferPool = Net4jUtil.createBufferPool();
        LifecycleUtil.activate((Object)this.bufferPool);
        this.provideTransport(500L);
        this.selector.activate();
        this.acceptor.setStartSynchronously(true);
        this.acceptor.setSynchronousStartTimeout(10000L);
        this.acceptor.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.acceptor.getConfig().setReceiveExecutor(this.threadPool);
        this.acceptor.setSelector(this.selector);
        this.acceptor.setAddress("0.0.0.0");
        this.acceptor.setPort(2040);
        this.acceptor.activate();
        this.connector.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.connector.getConfig().setReceiveExecutor(this.threadPool);
        this.connector.setSelector((ITCPSelector)this.selector);
        this.connector.setHost("localhost");
        this.connector.setPort(2040);
        this.connector.activate();
        this.connector.waitForConnection(15000L);
        TCPConnectorTest.assertEquals((boolean)true, (boolean)this.connector.isActive());
    }

    public void testDeferredActivation10() throws Exception {
        int i = 0;
        while (i < 10) {
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            IOUtil.OUT().println("#####################################################");
            IOUtil.OUT().println(" RUN = " + i);
            IOUtil.OUT().println("#####################################################");
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            this.testDeferredActivation();
            this.cleanup();
            ++i;
        }
    }

    public void testNegotiationSuccess() throws Exception {
        this.threadPool = ThreadPool.create();
        this.bufferPool = Net4jUtil.createBufferPool();
        LifecycleUtil.activate((Object)this.bufferPool);
        this.randomizer = new Randomizer();
        this.randomizer.activate();
        this.userManager = new UserManager();
        this.userManager.activate();
        this.userManager.addUser(USER_ID, PASSWORD);
        this.challengeNegotiator = new ChallengeNegotiator();
        this.challengeNegotiator.setRandomizer((IRandomizer)this.randomizer);
        this.challengeNegotiator.setUserManager((IUserManager)this.userManager);
        this.challengeNegotiator.activate();
        this.provideTransport();
        this.selector.activate();
        this.acceptor.setStartSynchronously(true);
        this.acceptor.setSynchronousStartTimeout(10000L);
        this.acceptor.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.acceptor.getConfig().setReceiveExecutor(this.threadPool);
        this.acceptor.getConfig().setNegotiator((INegotiator)this.challengeNegotiator);
        this.acceptor.setSelector(this.selector);
        this.acceptor.setAddress("0.0.0.0");
        this.acceptor.setPort(2040);
        this.acceptor.activate();
        this.credentialsProvider = new PasswordCredentialsProvider((IPasswordCredentials)CREDENTIALS);
        LifecycleUtil.activate((Object)this.credentialsProvider);
        this.responseNegotiator = new ResponseNegotiator();
        this.responseNegotiator.setCredentialsProvider((IPasswordCredentialsProvider)this.credentialsProvider);
        this.responseNegotiator.activate();
        this.connector.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.connector.getConfig().setReceiveExecutor(this.threadPool);
        this.connector.getConfig().setNegotiator((INegotiator)this.responseNegotiator);
        this.connector.setSelector((ITCPSelector)this.selector);
        this.connector.setHost("localhost");
        this.connector.setPort(2040);
        this.connector.activate();
        this.connector.waitForConnection(15000L);
        InternalChannel clientChannel = this.connector.openChannel();
        TCPConnectorTest.assertEquals((String)USER_ID, (String)clientChannel.getUserID());
        IConnector serverConnector = this.acceptor.getElements()[0];
        IChannel serverChannel = ((IChannel[])serverConnector.getElements())[0];
        TCPConnectorTest.assertEquals((String)USER_ID, (String)serverChannel.getUserID());
        System.out.println(serverChannel);
    }

    public void testNegotiationSuccess10() throws Exception {
        int i = 0;
        while (i < 10) {
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            IOUtil.OUT().println("#####################################################");
            IOUtil.OUT().println("                          RUN = " + i);
            IOUtil.OUT().println("#####################################################");
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            IOUtil.OUT().println();
            this.testNegotiationSuccess();
            this.cleanup();
            ++i;
        }
    }

    public void testInvalidUser() throws Exception {
        this.threadPool = ThreadPool.create();
        this.bufferPool = Net4jUtil.createBufferPool();
        LifecycleUtil.activate((Object)this.bufferPool);
        this.randomizer = new Randomizer();
        this.randomizer.activate();
        this.userManager = new UserManager();
        this.userManager.activate();
        this.userManager.addUser(INVALID_USER_ID, PASSWORD);
        this.challengeNegotiator = new ChallengeNegotiator();
        this.challengeNegotiator.setRandomizer((IRandomizer)this.randomizer);
        this.challengeNegotiator.setUserManager((IUserManager)this.userManager);
        this.challengeNegotiator.activate();
        this.provideTransport();
        this.selector.activate();
        this.acceptor.setStartSynchronously(true);
        this.acceptor.setSynchronousStartTimeout(10000L);
        this.acceptor.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.acceptor.getConfig().setReceiveExecutor(this.threadPool);
        this.acceptor.getConfig().setNegotiator((INegotiator)this.challengeNegotiator);
        this.acceptor.setSelector(this.selector);
        this.acceptor.setAddress("0.0.0.0");
        this.acceptor.setPort(2040);
        this.acceptor.activate();
        this.credentialsProvider = new PasswordCredentialsProvider((IPasswordCredentials)CREDENTIALS);
        LifecycleUtil.activate((Object)this.credentialsProvider);
        this.responseNegotiator = new ResponseNegotiator();
        this.responseNegotiator.setCredentialsProvider((IPasswordCredentialsProvider)this.credentialsProvider);
        this.responseNegotiator.activate();
        this.connector.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.connector.getConfig().setReceiveExecutor(this.threadPool);
        this.connector.getConfig().setNegotiator((INegotiator)this.responseNegotiator);
        this.connector.setSelector((ITCPSelector)this.selector);
        this.connector.setHost("localhost");
        this.connector.setPort(2040);
        try {
            this.connector.connectAsync();
            this.connector.waitForConnection(3000L);
            TCPConnectorTest.fail((String)"ConnectorException expected");
        }
        catch (ConnectorException ex) {
            OM.LOG.info("Expected ConnectorException:", (Throwable)ex);
            TCPConnectorTest.assertEquals((boolean)true, (boolean)(ex.getCause() instanceof NegotiationException));
        }
    }

    public void testInvalidPassword() throws Exception {
        this.threadPool = ThreadPool.create();
        this.bufferPool = Net4jUtil.createBufferPool();
        LifecycleUtil.activate((Object)this.bufferPool);
        this.randomizer = new Randomizer();
        this.randomizer.activate();
        this.userManager = new UserManager();
        this.userManager.activate();
        this.userManager.addUser(USER_ID, INVALID_PASSWORD);
        this.challengeNegotiator = new ChallengeNegotiator();
        this.challengeNegotiator.setRandomizer((IRandomizer)this.randomizer);
        this.challengeNegotiator.setUserManager((IUserManager)this.userManager);
        this.challengeNegotiator.activate();
        this.provideTransport();
        this.selector.activate();
        this.acceptor.setStartSynchronously(true);
        this.acceptor.setSynchronousStartTimeout(10000L);
        this.acceptor.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.acceptor.getConfig().setReceiveExecutor(this.threadPool);
        this.acceptor.getConfig().setNegotiator((INegotiator)this.challengeNegotiator);
        this.acceptor.setSelector(this.selector);
        this.acceptor.setAddress("0.0.0.0");
        this.acceptor.setPort(2040);
        this.acceptor.activate();
        this.credentialsProvider = new PasswordCredentialsProvider((IPasswordCredentials)CREDENTIALS);
        LifecycleUtil.activate((Object)this.credentialsProvider);
        this.responseNegotiator = new ResponseNegotiator();
        this.responseNegotiator.setCredentialsProvider((IPasswordCredentialsProvider)this.credentialsProvider);
        this.responseNegotiator.activate();
        this.connector.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.connector.getConfig().setReceiveExecutor(this.threadPool);
        this.connector.getConfig().setNegotiator((INegotiator)this.responseNegotiator);
        this.connector.setSelector((ITCPSelector)this.selector);
        this.connector.setHost("localhost");
        this.connector.setPort(2040);
        try {
            this.connector.connectAsync();
            this.connector.waitForConnection(3000L);
            TCPConnectorTest.fail((String)"ConnectorException expected");
        }
        catch (ConnectorException ex) {
            OM.LOG.info("Expected ConnectorException:", (Throwable)ex);
            TCPConnectorTest.assertEquals((boolean)true, (boolean)(ex.getCause() instanceof NegotiationException));
        }
    }

    public void testNoNegotiator() throws Exception {
        this.threadPool = ThreadPool.create();
        this.bufferPool = Net4jUtil.createBufferPool();
        LifecycleUtil.activate((Object)this.bufferPool);
        this.provideTransport();
        this.selector.activate();
        this.acceptor.setStartSynchronously(true);
        this.acceptor.setSynchronousStartTimeout(10000L);
        this.acceptor.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.acceptor.getConfig().setReceiveExecutor(this.threadPool);
        this.acceptor.setSelector(this.selector);
        this.acceptor.setAddress("0.0.0.0");
        this.acceptor.setPort(2040);
        this.acceptor.activate();
        this.connector.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.connector.getConfig().setReceiveExecutor(this.threadPool);
        this.connector.setSelector((ITCPSelector)this.selector);
        this.connector.setHost("localhost");
        this.connector.setPort(2040);
        this.connector.setUserID("SHOULD_FAIL_LATER");
        try {
            this.connector.connect();
            TCPConnectorTest.fail((String)"ConnectorException expected");
        }
        catch (ConnectorException ex) {
            OM.LOG.info("Expected ConnectorException:", (Throwable)ex);
            TCPConnectorTest.assertEquals((boolean)true, (boolean)(ex.getCause() instanceof IllegalStateException));
        }
    }

    public void testNegotiatorTooLate() throws Exception {
        this.threadPool = ThreadPool.create();
        this.bufferPool = Net4jUtil.createBufferPool();
        LifecycleUtil.activate((Object)this.bufferPool);
        this.provideTransport();
        this.selector.activate();
        this.acceptor.setStartSynchronously(true);
        this.acceptor.setSynchronousStartTimeout(10000L);
        this.acceptor.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.acceptor.getConfig().setReceiveExecutor(this.threadPool);
        this.acceptor.setSelector(this.selector);
        this.acceptor.setAddress("0.0.0.0");
        this.acceptor.setPort(2040);
        this.acceptor.activate();
        this.connector.getConfig().setBufferProvider((IBufferProvider)this.bufferPool);
        this.connector.getConfig().setReceiveExecutor(this.threadPool);
        this.connector.setSelector((ITCPSelector)this.selector);
        this.connector.setHost("localhost");
        this.connector.setPort(2040);
        this.connector.connect();
        this.credentialsProvider = new PasswordCredentialsProvider((IPasswordCredentials)CREDENTIALS);
        LifecycleUtil.activate((Object)this.credentialsProvider);
        this.responseNegotiator = new ResponseNegotiator();
        this.responseNegotiator.setCredentialsProvider((IPasswordCredentialsProvider)this.credentialsProvider);
        this.responseNegotiator.activate();
        try {
            this.connector.getConfig().setNegotiator((INegotiator)this.responseNegotiator);
            TCPConnectorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ex) {
            OM.LOG.info("Expected IllegalStateException:", (Throwable)ex);
        }
    }

    public void testRoundRobinBlockingQueue() throws Exception {
        RoundRobinBlockingQueue queue = new RoundRobinBlockingQueue();
        Channel[] channels = new Channel[3];
        int i = 0;
        while (i < channels.length) {
            Channel c = new Channel();
            c.setID((short)i);
            channels[i] = c;
            ++i;
        }
        TCPConnectorTest.assertEquals((boolean)true, (boolean)queue.isEmpty());
        TCPConnectorTest.assertNull(queue.peek());
        TCPConnectorTest.assertNull(queue.poll());
        i = 0;
        while (i < channels.length) {
            int j = 0;
            while (j < 10) {
                queue.put(channels[i]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 30) {
            IChannel peek1 = (IChannel)queue.peek();
            IChannel peek2 = (IChannel)queue.peek();
            TCPConnectorTest.assertSame((Object)peek1, (Object)peek2);
            IChannel poll = (IChannel)queue.poll();
            TCPConnectorTest.assertEquals((int)(i % 3), (int)poll.getID());
            TCPConnectorTest.assertSame((Object)peek1, (Object)poll);
            ++i;
        }
        TCPConnectorTest.assertEquals((boolean)true, (boolean)queue.isEmpty());
        TCPConnectorTest.assertNull(queue.peek());
        TCPConnectorTest.assertNull(queue.poll());
    }

    public static final class SSL
    extends TCPConnectorTest {
        @Override
        protected boolean useJVMTransport() {
            return false;
        }

        @Override
        protected boolean useSSLTransport() {
            return true;
        }
    }

    public static final class TCP
    extends TCPConnectorTest {
        @Override
        protected boolean useJVMTransport() {
            return false;
        }

        @Override
        protected boolean useSSLTransport() {
            return false;
        }
    }
}

